/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.datasource;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.performance.PerformanceStatistics;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.datasource.JdbcConnectionFactory;
import jp.ossc.nimbus.service.resource.datasource.JdbcConnectionFactoryFromDataSourceServiceMBean;
import jp.ossc.nimbus.service.resource.datasource.JdbcConnectionTransactionResource;
import jp.ossc.nimbus.service.resource.datasource.NimbusJdbcConnection;
import jp.ossc.nimbus.service.sequence.Sequence;

public class JdbcConnectionFactoryFromDataSourceService
extends ServiceBase
implements JdbcConnectionFactory,
JdbcConnectionFactoryFromDataSourceServiceMBean {
    private static final long serialVersionUID = -5025578679152037666L;
    static final Class DEFAULT_CONNECTION_CLASS = NimbusJdbcConnection.class;
    static final String JDBCR = "JDBCR";
    static final String JDBCR0 = "JDBCR0";
    static final String JDBCR00 = "JDBCR00";
    static final String JDBCR000 = "JDBCR000";
    static final String JDBCR0000 = "JDBCR0000";
    static final String JDBCR00001 = "JDBCR00001";
    static final String JDBCR00002 = "JDBCR00002";
    static final String JDBCR00003 = "JDBCR00003";
    static final String JDBCR00004 = "JDBCR00004";
    private JndiFinder mJndiFinder = null;
    private ServiceName mJndiFinderServiceName = null;
    private ServiceName mLogServiceName = null;
    private Logger mLogger = null;
    private Map mDsMap = null;
    private boolean mIsAutoCommit = false;
    private boolean mIsManagedResource = true;
    private int mConnectionMode = 0;
    private ServiceName mJournalServiceName = null;
    private int mJournalLevel = 0;
    private ServiceName mPerformanceServiceName = null;
    private ServiceName mSequenceServiceName = null;
    private Journal mJournalService = null;
    private PerformanceStatistics mPerformanceService = null;
    private Sequence mSequenceService = null;
    private String mConnectionClassName = null;
    private Class mConnectionClass;
    private Constructor mConnectionConstructor;
    private String dataSourceName = "";

    public void startService() {
        this.mJndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.mJndiFinderServiceName);
        if (this.mLogServiceName != null) {
            this.mLogger = (Logger)ServiceManagerFactory.getServiceObject(this.mLogServiceName);
        }
        if (this.mLogger == null) {
            this.mLogger = this.getLogger();
        }
        this.mDsMap = new Hashtable();
        if (this.mConnectionClassName != null) {
            try {
                this.mConnectionClass = Class.forName(this.mConnectionClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Connection class :" + this.mConnectionClassName + " not found.");
            }
            if (!this.isValidConnectionClass(this.mConnectionClass)) {
                throw new IllegalArgumentException("Connection class  :" + this.mConnectionClassName + " must be derived class of " + DEFAULT_CONNECTION_CLASS);
            }
        } else {
            this.mConnectionClass = DEFAULT_CONNECTION_CLASS;
        }
        try {
            this.mConnectionConstructor = this.mConnectionClass.getDeclaredConstructor(Connection.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Connection class must have constructor : " + this.mConnectionClassName + "(" + Connection.class + ")");
        }
        if (this.mJournalServiceName != null) {
            try {
                this.mJournalService = (Journal)ServiceManagerFactory.getServiceObject(this.mJournalServiceName);
            }
            catch (ServiceNotFoundException e) {
                throw new IllegalArgumentException("Cannot resolve Journal Service : " + this.mJournalServiceName + ".");
            }
            if (this.mJournalService == null) {
                throw new IllegalArgumentException("Cannot resolve Journal Service");
            }
            try {
                this.mSequenceService = (Sequence)ServiceManagerFactory.getServiceObject(this.mSequenceServiceName);
            }
            catch (ServiceNotFoundException e) {
                throw new IllegalArgumentException("Cannot resolve Sequence Service : " + this.mSequenceServiceName + ".");
            }
            if (this.mSequenceService == null) {
                throw new IllegalArgumentException("Cannot resolve Sequence Service");
            }
        }
        if (this.mPerformanceServiceName != null) {
            try {
                this.mPerformanceService = (PerformanceStatistics)ServiceManagerFactory.getServiceObject(this.mPerformanceServiceName);
            }
            catch (ServiceNotFoundException e) {
                throw new IllegalArgumentException("Cannot resolve Performance Service : " + this.mPerformanceServiceName + ".");
            }
            if (this.mPerformanceService == null) {
                throw new IllegalArgumentException("Cannot resolve PerformanceService");
            }
        }
    }

    public void stopService() {
        this.mJndiFinder = null;
        this.mLogger = null;
    }

    private boolean isValidConnectionClass(Class conClass) {
        if (DEFAULT_CONNECTION_CLASS.equals(conClass)) {
            return true;
        }
        return DEFAULT_CONNECTION_CLASS.isAssignableFrom(conClass);
    }

    public Connection makeConnection(String key) {
        DataSource ds = null;
        NimbusJdbcConnection con = null;
        if (key == null || key.length() == 0) {
            key = this.dataSourceName;
        }
        if ((ds = (DataSource)this.mDsMap.get(key)) == null) {
            try {
                ds = (DataSource)this.mJndiFinder.lookup(key);
            }
            catch (NamingException e) {
                throw new ServiceException("JdbcConnectionFactoryFromDataSourceService001", "NamingException key is " + key, e);
            }
            this.mDsMap.put(key, ds);
        }
        Connection fromCon = null;
        try {
            fromCon = ds.getConnection();
        }
        catch (SQLException e1) {
            if (this.mLogger != null) {
                this.mLogger.write(JDBCR00002, (Object)new Boolean(this.mIsAutoCommit).toString());
            }
            throw new ServiceException("JdbcConnectionFactoryFromDataSourceService002", "Connection get Error", e1);
        }
        try {
            con = (NimbusJdbcConnection)this.mConnectionConstructor.newInstance(fromCon);
        }
        catch (Exception e) {
            if (this.mLogger != null) {
                this.mLogger.write(JDBCR00004, (Object)new Boolean(this.mIsAutoCommit).toString());
            }
            throw new ServiceException("JdbcConnectionFactoryFromDataSourceService002", "Connection get Error", e);
        }
        if (this.mPerformanceService != null) {
            con.setPerformanceService(this.mPerformanceService);
        }
        if (this.mJournalService != null) {
            con.setJournalService(this.mJournalService);
            con.setJournalLevel(this.mJournalLevel);
            con.setSequenceService(this.mSequenceService);
        }
        if (this.mConnectionMode == 1) {
            con.setFakeMode(true);
        } else {
            con.setFakeMode(false);
        }
        if (!this.mIsManagedResource) {
            try {
                if (this.mLogger != null) {
                    this.mLogger.write(JDBCR00002, (Object)new Boolean(this.mIsAutoCommit).toString());
                }
                con.setTrueAutoCommit(this.mIsAutoCommit);
            }
            catch (SQLException e2) {
                if (this.mLogger != null) {
                    this.mLogger.write(JDBCR00003, e2);
                }
                throw new ServiceException("JdbcConnectionFactoryFromDataSourceService003", "AutoCommitChange Error", e2);
            }
        }
        return con;
    }

    public void setLogServiceName(ServiceName name) {
        this.mLogServiceName = name;
    }

    public ServiceName getLogServiceName() {
        return this.mLogServiceName;
    }

    public void setJndiFinderServiceName(ServiceName name) {
        this.mJndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.mJndiFinderServiceName;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.mIsAutoCommit = isAutoCommit;
    }

    public TransactionResource makeResource(String key) throws SQLException {
        Connection con = this.makeConnection(key);
        JdbcConnectionTransactionResource ret = new JdbcConnectionTransactionResource(con);
        return ret;
    }

    public void setManagedResource(boolean isManaged) {
        this.mIsManagedResource = isManaged;
    }

    public void setConnectionClassName(String name) {
        this.mConnectionClassName = name;
    }

    public void setPerformanceServiceName(ServiceName serviceName) {
        this.mPerformanceServiceName = serviceName;
    }

    public ServiceName getPerformanceServiceName() {
        return this.mPerformanceServiceName;
    }

    public void setJournalServiceName(ServiceName serviceName) {
        this.mJournalServiceName = serviceName;
    }

    public ServiceName getJournalServiceName() {
        return this.mJournalServiceName;
    }

    public void setSequenceServiceName(ServiceName serviceName) {
        this.mSequenceServiceName = serviceName;
    }

    public ServiceName getSequenceServiceName() {
        return this.mSequenceServiceName;
    }

    public void setJournalLevel(int level) {
        this.mJournalLevel = level;
    }

    public int getJournalLevel() {
        return this.mJournalLevel;
    }

    public int getConnectionMode() {
        return this.mConnectionMode;
    }

    public void setConnectionMode(int mode) {
        this.mConnectionMode = mode;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.mJndiFinder = jndiFinder;
    }

    public void setJournalService(Journal journalService) {
        this.mJournalService = journalService;
    }

    public void setLogger(Logger logger) {
        this.mLogger = logger;
    }

    public void setPerformanceService(PerformanceStatistics performanceService) {
        this.mPerformanceService = performanceService;
    }

    public void setSequenceService(Sequence sequenceService) {
        this.mSequenceService = sequenceService;
    }
}

