/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.datasource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.performance.PerformanceStatistics;
import jp.ossc.nimbus.service.resource.datasource.NimbusResultSet;
import jp.ossc.nimbus.service.sequence.Sequence;

public class AbstNimbusStatement {
    protected Journal journalService;
    protected PerformanceStatistics performanceService;
    protected Sequence seqenceService;
    protected int journalLevel;
    protected Statement mStatement;
    protected ArrayList mResultSetList = new ArrayList();

    public AbstNimbusStatement(Statement stmt) {
        this.mStatement = stmt;
    }

    public void setJournalService(Journal journal, Sequence seq, int level) {
        this.journalService = journal;
        this.seqenceService = seq;
        this.journalLevel = level;
    }

    public int getJournalLevel() {
        return this.journalLevel;
    }

    public void setPerformanceService(PerformanceStatistics perform) {
        this.performanceService = perform;
    }

    public String getSequenceNo() {
        return this.seqenceService.increment();
    }

    public Connection getConnection() throws SQLException {
        return this.mStatement.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this.mStatement.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.mStatement.getFetchSize();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.mStatement.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.mStatement.getMaxRows();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.mStatement.getWarnings();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.mStatement.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.mStatement.getResultSetHoldability();
    }

    public int getQueryTimeout() throws SQLException {
        return this.mStatement.getQueryTimeout();
    }

    public int getUpdateCount() throws SQLException {
        return this.mStatement.getUpdateCount();
    }

    public void setFetchDirection(int arg0) throws SQLException {
        this.mStatement.setFetchDirection(arg0);
    }

    public void setFetchSize(int arg0) throws SQLException {
        this.mStatement.setFetchSize(arg0);
    }

    public void setMaxFieldSize(int arg0) throws SQLException {
        this.mStatement.setMaxFieldSize(arg0);
    }

    public void setMaxRows(int arg0) throws SQLException {
        this.mStatement.setMaxRows(arg0);
    }

    public void clearWarnings() throws SQLException {
        this.mStatement.clearWarnings();
    }

    public void setQueryTimeout(int arg0) throws SQLException {
        this.mStatement.setQueryTimeout(arg0);
    }

    public boolean getMoreResults() throws SQLException {
        return this.mStatement.getMoreResults();
    }

    public boolean getMoreResults(int arg0) throws SQLException {
        return this.mStatement.getMoreResults(arg0);
    }

    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.mStatement.setEscapeProcessing(arg0);
    }

    public void setCursorName(String arg0) throws SQLException {
        this.mStatement.setCursorName(arg0);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet tmp = this.mStatement.getGeneratedKeys();
        NimbusResultSet set = new NimbusResultSet(tmp);
        this.mResultSetList.add(set);
        return set;
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSet tmp = this.mStatement.getResultSet();
        NimbusResultSet set = new NimbusResultSet(tmp);
        this.mResultSetList.add(set);
        return set;
    }

    public int getResultSetType() throws SQLException {
        return this.mStatement.getResultSetType();
    }
}

