/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.ThrowableJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class ThrowableJournalEditorService
extends ImmutableJournalEditorServiceBase
implements ThrowableJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 2145141927079525859L;
    private static final String SERVLET_EXCEPTION_NAME = "javax.servlet.ServletException";
    private static final String GET_ROOT_CAUSE_METHOD = "getRootCause";
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private boolean isOutputCause = true;
    private boolean bOutputTab = true;

    public void setOutputCause(boolean output) {
        this.isOutputCause = output;
    }

    public boolean getOutputCause() {
        return this.isOutputCause;
    }

    protected String toString(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        Throwable e = (Throwable)value;
        if (e != null) {
            buf.append("Exception occuers :").append(e.toString()).append(LINE_SEP);
            StackTraceElement[] elemss = e.getStackTrace();
            if (elemss != null) {
                for (int i = 0; i < elemss.length; ++i) {
                    if (this.bOutputTab) {
                        buf.append(TAB);
                    }
                    if (elemss[i] != null) {
                        buf.append(elemss[i].toString()).append(LINE_SEP);
                        continue;
                    }
                    buf.append("null").append(LINE_SEP);
                }
            }
            if (this.isOutputCause) {
                Throwable ee = this.getCause(e);
                while (ee != null) {
                    buf.append("Caused by:").append(ee.toString()).append(LINE_SEP);
                    StackTraceElement[] elems = ee.getStackTrace();
                    if (elems != null) {
                        for (int i = 0; i < elems.length; ++i) {
                            if (this.bOutputTab) {
                                buf.append(TAB);
                            }
                            if (elems[i] != null) {
                                buf.append(elems[i].toString()).append(LINE_SEP);
                                continue;
                            }
                            buf.append("null").append(LINE_SEP);
                        }
                    }
                    ee = this.getCause(ee);
                }
            }
        } else {
            buf.append("Exception occuers :").append(e).append(LINE_SEP);
        }
        return buf.toString();
    }

    private Throwable getCause(Throwable th) {
        Throwable cause = null;
        String thClassName = th.getClass().getName();
        if (thClassName.equals(SERVLET_EXCEPTION_NAME)) {
            try {
                cause = (Throwable)th.getClass().getMethod(GET_ROOT_CAUSE_METHOD, null).invoke((Object)th, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        } else if (thClassName.equals(JMS_EXCEPTION_NAME)) {
            try {
                cause = (Exception)th.getClass().getMethod(GET_LINKED_EXCEPTION_METHOD, null).invoke((Object)th, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        } else {
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }

    public boolean getOutputTab() {
        return this.bOutputTab;
    }

    public void setOutputTab(boolean outputTab) {
        this.bOutputTab = outputTab;
    }
}

