/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import jp.ossc.nimbus.service.jms.JMSConnectionCreateException;
import jp.ossc.nimbus.service.jms.JMSConnectionFactoryService;
import jp.ossc.nimbus.service.jms.ReconnectableQueueConnection;

public class JMSQueueConnectionFactoryService
extends JMSConnectionFactoryService {
    private static final long serialVersionUID = 5183874873387069255L;

    protected Connection createConnection(String user, String pwd) throws JMSException, JMSConnectionCreateException {
        if (!(this.connectionFactory instanceof QueueConnectionFactory)) {
            throw new JMSConnectionCreateException("ConnectionFactory is not QueueConnectionFactory.");
        }
        if (this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_RECOVER || this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_DEAD) {
            ReconnectableQueueConnection con = null;
            con = user == null ? new ReconnectableQueueConnection(this.connectionFactory) : new ReconnectableQueueConnection(this.connectionFactory, user, pwd);
            con.setKeepAliveChecker(this.jndiKeepAliveChecker);
            con.setReconnectMode(this.autoReconnectMode);
            if (this.autoReconnectErrorLogMessageId != null) {
                con.setReconnectErrorLogMessageId(this.autoReconnectErrorLogMessageId);
                con.setLogger(this.getLogger());
            }
            return con;
        }
        if (user != null) {
            return ((QueueConnectionFactory)this.connectionFactory).createQueueConnection(user, pwd);
        }
        return ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
    }
}

