/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class CodeMasterNotifyBean
extends HashMap {
    private static final long serialVersionUID = 3508475057737920813L;
    private JndiFinder mTopicFinder;
    private TopicSession mRes;
    private String mFlowKey;
    private Date mDate;
    private Object mData;
    private String mTopicName;

    public void setTopicName(String name) {
        this.mTopicName = name;
    }

    public void setResource(TopicSession rc) {
        this.mRes = rc;
    }

    public void setMasterFlowKey(String masterKey) {
        this.mFlowKey = masterKey;
    }

    public void setDate(Date effectiveDate) {
        this.mDate = effectiveDate;
    }

    public void setData(Object data) {
        this.mData = data;
    }

    public void setJndiFinder(JndiFinder finder) {
        this.mTopicFinder = finder;
    }

    public void addMessage() {
        if (this.mFlowKey == null) {
            return;
        }
        this.put(this.mFlowKey, this.mData);
        this.put(this.mFlowKey + "$updateTime", this.mDate == null ? new Date() : this.mDate);
        this.mDate = null;
        this.mFlowKey = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send() throws JMSException, NamingException {
        if (this.size() == 0) {
            return;
        }
        TopicSession session = this.mRes;
        MapMessage msg = session.createMapMessage();
        Set set = this.keySet();
        Iterator ite = set.iterator();
        while (ite.hasNext()) {
            ByteArrayOutputStream baos;
            String key;
            block12: {
                IOException e3;
                Object var12_9;
                key = (String)ite.next();
                Object obj = this.get(key);
                if (obj == null) {
                    msg.setString(key, null);
                    continue;
                }
                if (obj instanceof Date) {
                    Date dt = (Date)obj;
                    msg.setLong(key, dt.getTime());
                    continue;
                }
                if (obj instanceof Boolean || obj instanceof Byte || obj instanceof byte[] || obj instanceof Character || obj instanceof Double || obj instanceof Float || obj instanceof Integer || obj instanceof Long || obj instanceof Short || obj instanceof String) {
                    msg.setObject(key, obj);
                    continue;
                }
                baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = null;
                try {
                    try {
                        oos = new ObjectOutputStream(baos);
                        oos.writeObject(obj);
                        oos.flush();
                    }
                    catch (IOException e2) {
                        JMSException ex = new JMSException("Not serializable : " + obj);
                        ex.setLinkedException((Exception)e2);
                        throw ex;
                    }
                    var12_9 = null;
                    if (oos == null) break block12;
                }
                catch (Throwable throwable) {
                    var12_9 = null;
                    if (oos == null) throw throwable;
                    try {
                        oos.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e3) {}
                oos.close();
            }
            msg.setBytes(key, baos.toByteArray());
        }
        Topic tp = null;
        tp = this.mTopicName == null ? (Topic)this.mTopicFinder.lookup() : (Topic)this.mTopicFinder.lookup(this.mTopicName);
        TopicPublisher tpub = session.createPublisher(tp);
        msg.setJMSDeliveryMode(2);
        tpub.publish((Message)msg);
        this.clear();
    }

    public void addMessageAndSend() throws JMSException, NamingException {
        this.addMessage();
        this.send();
    }
}

