/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ExceptionHandler;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ExceptionHandlingInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.util.ClassMappingTree;

public class ExceptionHandlingInterceptorService
extends ServletFilterInterceptorService
implements ExceptionHandlingInterceptorServiceMBean {
    private static final long serialVersionUID = -5888057404214069278L;
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    protected Properties exceptionAndHandlerMapping;
    protected ClassMappingTree exceptionMapForHandler;
    protected ServiceName defaultExceptionHandlerServiceName;
    protected ExceptionHandler defaultExceptionHandler;

    public void setExceptionAndHandlerMapping(Properties map) {
        this.exceptionAndHandlerMapping = map;
    }

    public Properties getExceptionAndHandlerMapping() {
        return this.exceptionAndHandlerMapping;
    }

    public void setDefaultExceptionHandlerServiceName(ServiceName name) {
        this.defaultExceptionHandlerServiceName = name;
    }

    public ServiceName getDefaultExceptionHandlerServiceName() {
        return this.defaultExceptionHandlerServiceName;
    }

    public void startService() throws Exception {
        if (this.exceptionAndHandlerMapping != null) {
            this.exceptionMapForHandler = new ClassMappingTree();
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            Iterator<Object> exNames = this.exceptionAndHandlerMapping.keySet().iterator();
            while (exNames.hasNext()) {
                String exName = (String)exNames.next();
                Class<?> clazz = Class.forName(exName, true, loader);
                String name = (String)this.exceptionAndHandlerMapping.get(exName);
                editor.setAsText(name);
                ServiceName serviceName = (ServiceName)editor.getValue();
                this.exceptionMapForHandler.add(clazz, ServiceManagerFactory.getServiceObject(serviceName));
            }
        }
        if (this.defaultExceptionHandlerServiceName != null) {
            this.defaultExceptionHandler = (ExceptionHandler)ServiceManagerFactory.getServiceObject(this.defaultExceptionHandlerServiceName);
        }
    }

    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            Object ret;
            block5: {
                ret = null;
                try {
                    ret = chain.invokeNext(context);
                }
                catch (Throwable th) {
                    ServletRequest request = context.getServletRequest();
                    ServletResponse response = context.getServletResponse();
                    boolean isHandled = false;
                    ExceptionHandler handler = this.getTargetExceptionHandlerCause(th);
                    if (handler != null) {
                        Throwable targetTh = this.getTargetException(this.exceptionMapForHandler, th);
                        if (targetTh == null) {
                            targetTh = th;
                        }
                        handler.handleException(targetTh, request, response);
                        isHandled = true;
                    }
                    if (isHandled) break block5;
                    throw th;
                }
            }
            return ret;
        }
        return chain.invokeNext(context);
    }

    protected ExceptionHandler getTargetExceptionHandlerCause(Throwable th) {
        ExceptionHandler handler = (ExceptionHandler)this.getTargetHandlerCause(this.exceptionMapForHandler, th);
        return handler == null ? this.defaultExceptionHandler : handler;
    }

    protected Object getTargetHandlerCause(ClassMappingTree handlers, Throwable th) {
        if (handlers == null) {
            return th;
        }
        Object handler = handlers.getValue(th.getClass());
        if (handler != null) {
            return handler;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? null : this.getTargetHandlerCause(handlers, cause);
    }

    protected Throwable getTargetException(ClassMappingTree handlers, Throwable th) {
        if (handlers == null) {
            return th;
        }
        Object handler = handlers.getValue(th.getClass());
        if (handler != null) {
            return th;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? null : this.getTargetException(handlers, cause);
    }

    protected Throwable getCause(Throwable th) {
        Throwable cause = null;
        if (th instanceof ServletException) {
            cause = ((ServletException)th).getRootCause();
        } else if (th.getClass().getName().equals(JMS_EXCEPTION_NAME)) {
            try {
                cause = (Exception)th.getClass().getMethod(GET_LINKED_EXCEPTION_METHOD, null).invoke((Object)th, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }
}

