/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.recset;

import java.io.Serializable;

public class FieldSchema
implements Serializable {
    private static final long serialVersionUID = 750474574072043812L;
    public static final int C_KEY_UNIQUE = 0;
    public static final int C_KEY_ROW_VERSION = 1;
    public static final int C_KEY_READ = 2;
    public static final int C_KEY_UPDATE = 3;
    public static final int C_KEY_DUMMY = 4;
    public static final int C_TYPE_NONE = -1;
    public static final int C_TYPE_INT = 1;
    public static final int C_TYPE_LONG = 8;
    public static final int C_TYPE_STRING = 2;
    public static final int C_TYPE_CHAR = 3;
    public static final int C_TYPE_DATE = 4;
    public static final int C_TYPE_FLOAT = 5;
    public static final int C_TYPE_DOUBLE = 7;
    public static final int C_TYPE_TIMESTAMP = 9;
    public static final int C_TYPE_BLOB = 10;
    public static final int C_TYPE_CLOB = 11;
    private String mFieldName = null;
    private int mFieldType = -1;
    private int mFieldLength = -1;
    private int mIndex = -1;
    private boolean mIsCrypt = false;
    private int mSqlType = -1;
    private int mFieldKey = -1;

    public int getFieldLength() {
        return this.mFieldLength;
    }

    public String getFieldName() {
        return this.mFieldName;
    }

    public int getFieldType() {
        return this.mFieldType;
    }

    public int getFieldKey() {
        return this.mFieldKey;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public boolean isCrypt() {
        return this.mIsCrypt && (this.mFieldType == 2 || this.mFieldType == 3);
    }

    public boolean isUniqueKey() {
        return this.mFieldKey == 0;
    }

    public boolean isUpdateField() {
        return this.mFieldKey == 0 || this.mFieldKey == 1 || this.mFieldKey == 3;
    }

    public boolean isRowVersionField() {
        return this.mFieldKey == 1;
    }

    public void setFieldLength(int l) {
        if (this.mFieldLength == -1) {
            this.mFieldLength = l;
        }
    }

    public void setFieldName(String name) {
        if (this.mFieldName == null) {
            this.mFieldName = name;
        }
    }

    public void setFieldType(int type) {
        if (this.mFieldType != -1) {
            return;
        }
        switch (type) {
            case 1: {
                this.mSqlType = 4;
                break;
            }
            case 8: {
                this.mSqlType = 4;
                break;
            }
            case 2: {
                this.mSqlType = 12;
                break;
            }
            case 3: {
                this.mSqlType = 1;
                break;
            }
            case 4: {
                this.mSqlType = 91;
                break;
            }
            case 9: {
                this.mSqlType = 93;
                break;
            }
            case 5: {
                this.mSqlType = 6;
                break;
            }
            case 7: {
                this.mSqlType = 8;
                break;
            }
            case 10: {
                this.mSqlType = 2004;
                break;
            }
            case 11: {
                this.mSqlType = 2005;
                break;
            }
            default: {
                this.mFieldType = -1;
                return;
            }
        }
        this.mFieldType = type;
    }

    public void setFieldKey(int key) {
        if (this.mFieldKey == -1) {
            switch (key) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.mFieldKey = key;
                    break;
                }
            }
        }
    }

    public void setIndex(int l) {
        if (this.mIndex == -1) {
            this.mIndex = l;
        }
    }

    public void setCrypt(boolean val) {
        this.mIsCrypt = val;
    }

    public void setSqlType(int arg) {
        this.mSqlType = arg;
    }

    public int getSqlType() {
        return this.mSqlType;
    }
}

