/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.core.DefaultLogMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import org.w3c.dom.Element;

public class ServerMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = -5309966428718081110L;
    public static final String SERVER_TAG_NAME = "server";
    private static final String REF_URL_TAG_NAME = "ref-url";
    private static final String REPOSITORY_TAG_NAME = "manager-repository";
    private static final String PROPERTY_EDITORS_TAG_NAME = "property-editors";
    private static final String PROPERTY_EDITOR_TAG_NAME = "property-editor";
    private static final String LOG_TAG_NAME = "log";
    private static final String MESSAGE_TAG_NAME = "message";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String SERVER_PROPERTY_TAG_NAME = "server-property";
    private final Map managers = new LinkedHashMap();
    private final Set referenceURL = new LinkedHashSet();
    private final Map propertyEditors = new LinkedHashMap();
    private final URL myUrl;
    private ServiceNameMetaData repository;
    private ServiceNameMetaData log;
    private ServiceNameMetaData message;
    private DefaultLogMetaData defaultLog;
    private ServiceLoader myLoader;
    private Map properties = new LinkedHashMap();
    private String encoding;
    private String docType;

    public ServerMetaData(ServiceLoader loader, URL url) {
        this.myUrl = url;
        this.myLoader = loader;
    }

    public URL getURL() {
        return this.myUrl;
    }

    public ServiceLoader getServiceLoader() {
        return this.myLoader;
    }

    public ManagerMetaData getManager(String name) {
        return (ManagerMetaData)this.managers.get(name);
    }

    public Collection getManagers() {
        return this.managers.values();
    }

    public void addManager(ManagerMetaData manager) {
        this.managers.put(manager.getName(), manager);
    }

    public Set getReferenceURL() {
        return this.referenceURL;
    }

    public void addReferenceURL(String urlStr) {
        this.referenceURL.add(urlStr);
    }

    public Map getPropertyEditors() {
        return this.propertyEditors;
    }

    public void addPropertyEditor(String type, String editor) {
        this.propertyEditors.put(type, editor);
    }

    public ServiceNameMetaData getRepository() {
        return this.repository;
    }

    public void setRepository(ServiceNameMetaData data) {
        this.repository = data;
    }

    public ServiceNameMetaData getLog() {
        return this.log;
    }

    public void setLog(ServiceNameMetaData data) {
        this.log = data;
    }

    public ServiceNameMetaData getMessage() {
        return this.message;
    }

    public void setMessage(ServiceNameMetaData data) {
        this.message = data;
    }

    public DefaultLogMetaData getDefaultLog() {
        return this.defaultLog;
    }

    public void setDefaultLog(DefaultLogMetaData data) {
        this.defaultLog = data;
    }

    public String getProperty(String property) {
        return (String)this.properties.get(property);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        return props;
    }

    public void setProperty(String property, String value) {
        this.properties.put(property, value);
    }

    public ServiceNameMetaData createRepositoryMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, REPOSITORY_TAG_NAME, managerName, serviceName);
    }

    public ServiceNameMetaData createLogMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, LOG_TAG_NAME, managerName, serviceName);
    }

    public ServiceNameMetaData createMessageMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, MESSAGE_TAG_NAME, managerName, serviceName);
    }

    public void setDocType(String str) {
        this.docType = str;
    }

    public String getDocType() {
        return this.docType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void importXML(Element element) throws DeploymentException {
        Element editorsElement;
        Element messageElement;
        Element logElement;
        super.importXML(element);
        if (!element.getTagName().equals(SERVER_TAG_NAME)) {
            throw new DeploymentException("Root tag must be server : " + element.getTagName());
        }
        Iterator refURLElements = ServerMetaData.getChildrenByTagName(element, REF_URL_TAG_NAME);
        while (refURLElements.hasNext()) {
            Element refURLelement = (Element)refURLElements.next();
            String content = ServerMetaData.getElementContent(refURLelement);
            if (content == null || content.length() == 0) continue;
            this.referenceURL.add(content);
        }
        Iterator managerElements = ServerMetaData.getChildrenByTagName(element, "manager");
        while (managerElements.hasNext()) {
            ManagerMetaData managerData = new ManagerMetaData(this.myLoader, this);
            managerData.importXML((Element)managerElements.next());
            this.addManager(managerData);
        }
        Element repositoryElement = ServerMetaData.getOptionalChild(element, REPOSITORY_TAG_NAME);
        if (repositoryElement != null) {
            this.repository = new ServiceNameMetaData(this);
            this.repository.importXML(repositoryElement);
        }
        if ((logElement = ServerMetaData.getOptionalChild(element, LOG_TAG_NAME)) != null) {
            this.log = new ServiceNameMetaData(this);
            this.log.importXML(logElement);
        }
        if ((messageElement = ServerMetaData.getOptionalChild(element, MESSAGE_TAG_NAME)) != null) {
            this.message = new ServiceNameMetaData(this);
            this.message.importXML(messageElement);
        }
        Iterator propElements = ServerMetaData.getChildrenByTagName(element, SERVER_PROPERTY_TAG_NAME);
        while (propElements.hasNext()) {
            Element propElement = (Element)propElements.next();
            String serverProp = ServerMetaData.getElementContent(propElement);
            this.properties.put(ServerMetaData.getUniqueAttribute(propElement, NAME_ATTRIBUTE_NAME), serverProp);
        }
        Element defaultLogElement = ServerMetaData.getOptionalChild(element, "default-log");
        if (defaultLogElement != null) {
            this.defaultLog = new DefaultLogMetaData(this);
            this.defaultLog.importXML(defaultLogElement);
        }
        if ((editorsElement = ServerMetaData.getOptionalChild(element, PROPERTY_EDITORS_TAG_NAME)) != null) {
            Iterator editorElements = ServerMetaData.getChildrenByTagName(editorsElement, PROPERTY_EDITOR_TAG_NAME);
            while (editorElements.hasNext()) {
                Element editorElement = (Element)editorElements.next();
                String type = ServerMetaData.getUniqueAttribute(editorElement, TYPE_ATTRIBUTE_NAME);
                String editor = ServerMetaData.getElementContent(editorElement);
                if (editor == null) {
                    throw new DeploymentException("Contents of property-editor element is null.");
                }
                this.addPropertyEditor(type, editor);
            }
        }
    }

    public StringBuffer toXML(StringBuffer buf) {
        buf.append("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            buf.append(" encoding=\"");
            buf.append(this.encoding);
            buf.append("\"");
        }
        buf.append("?>");
        buf.append(LINE_SEPARATOR);
        if (this.docType != null) {
            buf.append(this.docType);
            buf.append(LINE_SEPARATOR);
            buf.append(LINE_SEPARATOR);
        }
        this.appendComment(buf);
        buf.append('<').append(SERVER_TAG_NAME).append('>');
        if (this.properties.size() != 0) {
            buf.append(LINE_SEPARATOR);
            Iterator names = this.properties.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                buf.append('<').append(SERVER_PROPERTY_TAG_NAME);
                buf.append(' ').append(NAME_ATTRIBUTE_NAME).append("=\"").append(name).append("\">");
                buf.append(LINE_SEPARATOR);
                buf.append(this.addIndent((String)this.properties.get(name)));
                buf.append(LINE_SEPARATOR);
                buf.append("</").append(SERVER_PROPERTY_TAG_NAME).append('>');
                if (!names.hasNext()) continue;
                buf.append(LINE_SEPARATOR);
            }
        }
        if (this.referenceURL.size() != 0) {
            buf.append(LINE_SEPARATOR);
            Iterator urls = this.referenceURL.iterator();
            while (urls.hasNext()) {
                String url = (String)urls.next();
                buf.append('<').append(REF_URL_TAG_NAME).append('>');
                buf.append(url);
                buf.append("</").append(REF_URL_TAG_NAME).append('>');
                if (!urls.hasNext()) continue;
                buf.append(LINE_SEPARATOR);
            }
        }
        if (this.propertyEditors.size() != 0) {
            buf.append(LINE_SEPARATOR);
            buf.append('<').append(PROPERTY_EDITORS_TAG_NAME).append('>');
            buf.append(LINE_SEPARATOR);
            StringBuffer subBuf = new StringBuffer();
            Iterator types = this.propertyEditors.keySet().iterator();
            while (types.hasNext()) {
                String type = (String)types.next();
                subBuf.append('<').append(PROPERTY_EDITOR_TAG_NAME);
                subBuf.append(' ').append(TYPE_ATTRIBUTE_NAME).append("=\"").append(type).append("\">");
                subBuf.append(LINE_SEPARATOR);
                subBuf.append(this.addIndent((String)this.propertyEditors.get(type)));
                subBuf.append(LINE_SEPARATOR);
                subBuf.append("</").append(PROPERTY_EDITOR_TAG_NAME).append('>');
                subBuf.append(LINE_SEPARATOR);
            }
            buf.append(this.addIndent(subBuf));
            buf.append("</").append(PROPERTY_EDITORS_TAG_NAME).append('>');
        }
        if (this.defaultLog != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.defaultLog.toXML(new StringBuffer())));
        }
        if (this.repository != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.repository.toXML(new StringBuffer())));
        }
        if (this.log != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.log.toXML(new StringBuffer())));
        }
        if (this.message != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.message.toXML(new StringBuffer())));
        }
        if (this.managers.size() != 0) {
            Iterator datas = this.managers.values().iterator();
            buf.append(LINE_SEPARATOR);
            while (datas.hasNext()) {
                buf.append(this.addIndent(((MetaData)datas.next()).toXML(new StringBuffer())));
                if (!datas.hasNext()) continue;
                buf.append(LINE_SEPARATOR);
            }
        }
        buf.append(LINE_SEPARATOR);
        buf.append("</").append(SERVER_TAG_NAME).append('>');
        return buf;
    }
}

