/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.core.AttributeMetaData;
import jp.ossc.nimbus.core.FactoryServiceBase;
import jp.ossc.nimbus.core.FactoryServiceBaseMBean;
import jp.ossc.nimbus.core.FieldMetaData;
import jp.ossc.nimbus.core.InvokeMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceProxy;

public class GenericsFactoryServiceProxy
extends FactoryServiceBase
implements DynamicMBean {
    private static final long serialVersionUID = -6799305487173484547L;
    private static final String MBEAN_SUFFIX = "MBean";
    protected Set constructorInfos = new HashSet();
    protected Map attributeInfos = new HashMap();
    protected Set operationInfos = new HashSet();
    protected MBeanInfo mbeanInfo;
    protected Object template;
    protected ServiceMetaData metaData;
    static /* synthetic */ Class class$javax$management$DynamicMBean;

    public GenericsFactoryServiceProxy(Class clazz, boolean isManagement) throws Exception {
        Class mbeanInterface;
        this.setManagement(isManagement);
        this.initConstructors();
        this.initBaseAttributes();
        this.initBaseOperations();
        if (isManagement && (mbeanInterface = GenericsFactoryServiceProxy.findMBeanInterface(clazz)) != null) {
            this.initAttributesOf(mbeanInterface, clazz);
            this.initOperationsOf(mbeanInterface, clazz);
        }
        this.initMBeanInfo();
    }

    protected void initConstructors() throws Exception {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length == 0) continue;
            this.constructorInfos.add(new MBeanConstructorInfo(null, constructors[i]));
        }
    }

    protected void initBaseAttributes() throws Exception {
        this.initAttributesOf(FactoryServiceBaseMBean.class, this.getClass());
    }

    private boolean isDeclaredMethod(Method method, Class clazz) {
        try {
            Method decMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
            if (Object.class.equals(decMethod.getDeclaringClass())) {
                return false;
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    protected void initAttributesOf(Class mbeanInterface, Class target) throws Exception {
        SimpleProperty[] props = SimpleProperty.getProperties(target);
        for (int i = 0; i < props.length; ++i) {
            if (this.attributeInfos.containsKey(props[i].getPropertyName()) || (!props[i].isReadable(target) || !this.isDeclaredMethod(props[i].getReadMethod(target), mbeanInterface)) && (!props[i].isWritable(target) || !this.isDeclaredMethod(props[i].getWriteMethod(target), mbeanInterface))) continue;
            String propName = props[i].getPropertyName();
            if (Character.isLowerCase(propName.charAt(0))) {
                propName = propName.length() == 1 ? Character.toString(Character.toUpperCase(propName.charAt(0))) : Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
            }
            this.attributeInfos.put(propName, new MBeanAttributeInfo(propName, null, props[i].isReadable(target) ? props[i].getReadMethod(target) : null, props[i].isWritable(target) ? props[i].getWriteMethod(target) : null));
        }
    }

    protected void initBaseOperations() throws Exception {
        this.initOperationsOf(FactoryServiceBaseMBean.class, this.getClass());
    }

    protected void initOperationsOf(Class mbeanInterface, Class target) throws Exception {
        Method[] methods = mbeanInterface.getMethods();
        SimpleProperty[] props = SimpleProperty.getProperties(target);
        for (int i = 0; i < methods.length; ++i) {
            MBeanOperationInfo oprationInfo;
            Method method = methods[i];
            boolean isOperationMethod = true;
            for (int j = 0; j < props.length; ++j) {
                if (props[j].isReadable(target)) {
                    Method readMethod = props[j].getReadMethod(target);
                    if (method.getName().equals(readMethod.getName()) && readMethod.getParameterTypes().length == 0) {
                        isOperationMethod = false;
                        break;
                    }
                }
                if (!props[j].isWritable(target)) continue;
                Method writeMethod = props[j].getWriteMethod(target);
                if (!method.getName().equals(writeMethod.getName()) || writeMethod.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(writeMethod.getParameterTypes()[0])) continue;
                isOperationMethod = false;
                break;
            }
            if (!isOperationMethod || this.operationInfos.contains(oprationInfo = new MBeanOperationInfo("", method = target.getMethod(method.getName(), method.getParameterTypes())))) continue;
            this.operationInfos.add(oprationInfo);
        }
    }

    protected void initMBeanInfo() {
        this.mbeanInfo = new MBeanInfo(this.getClass().getName(), null, this.attributeInfos.values().toArray(new MBeanAttributeInfo[this.attributeInfos.size()]), this.constructorInfos.toArray(new MBeanConstructorInfo[this.constructorInfos.size()]), this.operationInfos.toArray(new MBeanOperationInfo[this.operationInfos.size()]), new MBeanNotificationInfo[0]);
    }

    public void startService() throws Exception {
        ServiceMetaData serviceData = this.manager.getServiceMetaData(this.name);
        this.metaData = new ServiceMetaData(serviceData.getServiceLoader(), (MetaData)serviceData, serviceData.getManager());
        this.metaData.setCode(serviceData.getCode());
        this.metaData.setConstructor(serviceData.getConstructor());
        Iterator fields = serviceData.getFields().iterator();
        while (fields.hasNext()) {
            this.metaData.addField((FieldMetaData)fields.next());
        }
        Iterator attrs = serviceData.getAttributes().iterator();
        while (attrs.hasNext()) {
            this.metaData.addAttribute((AttributeMetaData)attrs.next());
        }
        Iterator invokes = serviceData.getInvokes().iterator();
        while (invokes.hasNext()) {
            this.metaData.addInvoke((InvokeMetaData)invokes.next());
        }
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                this.manager.startService(service, this.metaData);
            }
        }
    }

    public void stopService() throws Exception {
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                this.manager.stopService(service, this.metaData);
            }
        }
        if (this.template != null) {
            this.release(this.template);
            this.template = null;
        }
    }

    public void destroyService() throws Exception {
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                this.manager.destroyService(service, this.metaData);
            }
        }
        this.metaData = null;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MBeanAttributeInfo attributeInfo = (MBeanAttributeInfo)this.attributeInfos.get(attribute);
        if (attributeInfo != null && attributeInfo.isReadable()) {
            Property prop = PropertyFactory.createProperty(attribute);
            try {
                Object target;
                if (prop.isReadable(this)) {
                    return prop.getProperty(this);
                }
                if (this.template == null) {
                    if (this.isCreateTemplateOnStart) {
                        return null;
                    }
                    try {
                        this.createTemplate();
                    }
                    catch (Exception e) {
                        throw new ReflectionException(e);
                    }
                }
                if (prop.isReadable(target = this.convertServiceToObject(this.template))) {
                    return prop.getProperty(target);
                }
                throw new AttributeNotFoundException(attribute);
            }
            catch (NoSuchPropertyException e) {
                throw new AttributeNotFoundException(attribute);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e);
            }
        }
        throw new AttributeNotFoundException(attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                list.add(new Attribute(attributes[i], this.getAttribute(attributes[i])));
                continue;
            }
            catch (AttributeNotFoundException e) {
                continue;
            }
            catch (MBeanException e) {
                continue;
            }
            catch (ReflectionException e) {
                // empty catch block
            }
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block30: {
            block25: {
                block28: {
                    block29: {
                        block26: {
                            block27: {
                                attributeInfo = (MBeanAttributeInfo)this.attributeInfos.get(attribute.getName());
                                if (attributeInfo == null || !attributeInfo.isWritable()) break block30;
                                if (this.metaData != null) {
                                    attrData = this.metaData.getAttribute(attribute.getName());
                                    if (attrData == null && attribute.getName().length() > 1) {
                                        tmpName = new StringBuffer();
                                        if (Character.isLowerCase(attribute.getName().charAt(0))) {
                                            tmpName.append(Character.toUpperCase(attribute.getName().charAt(0)));
                                        } else {
                                            tmpName.append(Character.toLowerCase(attribute.getName().charAt(0)));
                                        }
                                        if (attribute.getName().length() > 2) {
                                            tmpName.append(attribute.getName().substring(1));
                                        }
                                        attrData = this.metaData.getAttribute(tmpName.toString());
                                    }
                                    if (attrData != null) {
                                        attrData.setValue(attribute.getValue());
                                    }
                                }
                                prop = (SimpleProperty)PropertyFactory.createProperty(attribute.getName());
                                targetException = null;
                                if (prop.isWritable(this.getClass())) {
                                    try {
                                        prop.setProperty(this, attribute.getValue());
                                    }
                                    catch (InvocationTargetException e) {
                                        targetException = e;
                                    }
                                    break block25;
                                }
                                if (this.template != null) ** GOTO lbl43
                                if (!this.isCreateTemplateOnStart) break block26;
                                if (targetException == null) break block27;
                                throw new ReflectionException(targetException);
                            }
                            return;
                        }
                        try {
                            this.createTemplate();
                        }
                        catch (Exception e) {
                            throw new ReflectionException(e);
                        }
lbl43:
                        // 2 sources

                        target = this.convertServiceToObject(this.template);
                        try {
                            prop.setProperty(target, attribute.getValue());
                        }
                        catch (InvocationTargetException e) {
                            targetException = e;
                        }
                        if (this.managedInstances != null && this.managedInstances.size() != 0) break block28;
                        if (targetException == null) break block29;
                        throw new ReflectionException(targetException);
                    }
                    return;
                }
                try {
                    instances = this.managedInstances.iterator();
                    while (instances.hasNext()) {
                        instance = this.convertServiceToObject((Service)instances.next());
                        if (prop.isWritable(instance.getClass())) {
                            try {
                                prop.setProperty(instance, attribute.getValue());
                            }
                            catch (InvocationTargetException e) {
                                targetException = e;
                            }
                            continue;
                        }
                        throw new AttributeNotFoundException("class=" + instance.getClass().getName() + ", attributename=" + attribute.getName());
                    }
                }
                catch (NoSuchPropertyException e) {
                    try {
                        throw new AttributeNotFoundException("name=" + attribute.getName() + ", value=" + attribute.getValue());
                    }
                    catch (Throwable var9_13) {
                        if (targetException != null) {
                            throw new ReflectionException(targetException);
                        }
                        throw var9_13;
                    }
                }
            }
            if (targetException != null) {
                throw new ReflectionException(targetException);
            }
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        int max = attributes.size();
        for (int i = 0; i < max; ++i) {
            try {
                this.setAttribute((Attribute)attributes.get(i));
                list.add(attributes.get(i));
                continue;
            }
            catch (AttributeNotFoundException e) {
                continue;
            }
            catch (InvalidAttributeValueException e) {
                continue;
            }
            catch (MBeanException e) {
                continue;
            }
            catch (ReflectionException e) {
                // empty catch block
            }
        }
        return list;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Class[] paramTypes = null;
        if (signature != null) {
            paramTypes = new Class[signature.length];
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                for (int i = 0; i < signature.length; ++i) {
                    paramTypes[i] = Class.forName(signature[i], false, loader);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e);
            }
        }
        Method method = null;
        try {
            method = this.getClass().getMethod(actionName, paramTypes);
            return method.invoke((Object)this, params);
        }
        catch (NoSuchMethodException e) {
            if (!this.isManagement()) {
                return null;
            }
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        if (this.template == null) {
            if (this.isCreateTemplateOnStart) {
                return null;
            }
            try {
                this.createTemplate();
            }
            catch (Exception e) {
                throw new ReflectionException(e);
            }
        }
        Object target = this.convertServiceToObject(this.template);
        Object ret = null;
        InvocationTargetException targetException = null;
        try {
            method = target.getClass().getMethod(actionName, paramTypes);
            ret = method.invoke(target, params);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            targetException = e;
        }
        if (this.managedInstances == null || this.managedInstances.size() == 0) {
            return ret;
        }
        Iterator instances = this.managedInstances.iterator();
        while (instances.hasNext()) {
            Object instance = this.convertServiceToObject((Service)instances.next());
            try {
                method = instance.getClass().getMethod(actionName, paramTypes);
                ret = method.invoke(instance, params);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
            catch (InvocationTargetException e) {
                targetException = e;
            }
        }
        if (targetException != null) {
            throw new ReflectionException(targetException);
        }
        return ret;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    public void release(Object obj) {
        if (obj instanceof Service && (obj != this.template || !this.isManagement() || this.getState() == 4)) {
            Service service = (Service)obj;
            if (this.manager == null) {
                service.stop();
                service.destroy();
            } else {
                this.manager.stopService(service, this.metaData);
                this.manager.destroyService(service, this.metaData);
            }
        }
        super.release(obj);
    }

    protected final Object createInstance() throws Exception {
        return this.createInstance(false);
    }

    protected Object createTemplate() throws Exception {
        return this.createInstance(true);
    }

    protected final Object createInstance(boolean isTemplate) throws Exception {
        if (this.manager == null || this.metaData == null) {
            return null;
        }
        Object obj = null;
        obj = this.isManagement() ? this.manager.instanciateService(this.metaData) : this.manager.createObject(this.metaData);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Service) {
            Service service = (Service)obj;
            if (!isTemplate && this.isManagement() && this.getServiceManagerName() != null) {
                service.setServiceManagerName(this.getServiceManagerName());
                service.setServiceName(this.getServiceName() + '$' + this.getManagedInstanceSet().size());
            } else {
                service.setServiceManagerName(null);
                service.setServiceName(null);
            }
            if (service.getState() == 7) {
                this.manager.createService(service, this.metaData);
            }
            if (service instanceof ServiceBase) {
                ServiceBase base = (ServiceBase)service;
                if (this.manager != null) {
                    base.logger.setDefaultLogger(this.manager.getLogger());
                    if (this.getSystemLoggerServiceName() == null) {
                        base.logger.setLogger(this.manager.getLogger());
                    }
                    base.message.setDefaultMessageRecordFactory(this.manager.getMessageRecordFactory());
                    if (this.getSystemMessageRecordFactoryServiceName() == null) {
                        base.message.setMessageRecordFactory(this.manager.getMessageRecordFactory());
                    }
                }
                if (this.getSystemLoggerServiceName() != null) {
                    base.setSystemLoggerServiceName(this.getSystemLoggerServiceName());
                }
                if (this.getSystemMessageRecordFactoryServiceName() != null) {
                    base.setSystemMessageRecordFactoryServiceName(this.getSystemMessageRecordFactoryServiceName());
                }
            }
            if (service.getState() == 1) {
                this.manager.startService(service, this.metaData);
            }
        }
        if (isTemplate && this.isManagement()) {
            this.template = obj;
        }
        return obj;
    }

    private Object convertServiceToObject(Object service) {
        Object child;
        Object target = service;
        while (target instanceof ServiceProxy && (child = ((ServiceProxy)target).getTarget()) != target) {
            target = child;
        }
        return target;
    }

    public void setSystemLoggerServiceName(ServiceName name) {
        super.setSystemLoggerServiceName(name);
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                if (!(service instanceof ServiceBase)) continue;
                ((ServiceBase)service).setSystemLoggerServiceName(name);
            }
        }
    }

    public void setSystemMessageRecordFactoryServiceName(ServiceName name) {
        super.setSystemMessageRecordFactoryServiceName(name);
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                if (!(service instanceof ServiceBase)) continue;
                ((ServiceBase)service).setSystemMessageRecordFactoryServiceName(name);
            }
        }
    }

    private static Class findMBeanInterface(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String className = clazz.getName();
        String mbeanInterfaceName = className + MBEAN_SUFFIX;
        Class<?>[] interfaces = clazz.getInterfaces();
        int max = interfaces.length;
        for (int i = 0; i < max; ++i) {
            if (!interfaces[i].equals(class$javax$management$DynamicMBean == null ? GenericsFactoryServiceProxy.class$("javax.management.DynamicMBean") : class$javax$management$DynamicMBean) && !interfaces[i].getName().equals(mbeanInterfaceName)) continue;
            return interfaces[i];
        }
        return GenericsFactoryServiceProxy.findMBeanInterface(clazz.getSuperclass());
    }
}

