/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaCheckException;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;
import jp.ossc.nimbus.util.converter.FormatConverter;
import jp.ossc.nimbus.util.converter.ReversibleConverter;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class DefaultPropertySchema
implements PropertySchema {
    protected static final String ARRAY_CLASS_SUFFIX = "[]";
    protected static final String CONVERTER_CLASS_PROPERTY_PREFIX = "{";
    protected static final String CONVERTER_CLASS_PROPERTY_SUFFIX = "}";
    protected static final Map converterManager = Collections.synchronizedMap(new HashMap());
    protected String schema;
    protected String name;
    protected Class type;
    protected Converter formatConverter;
    protected ServiceName formatConverterName;
    protected Converter parseConverter;
    protected ServiceName parseConverterName;
    protected Constrain constrainExpression;

    public void setSchema(String schema) throws PropertySchemaDefineException {
        if (schema == null || schema.length() == 0) {
            throw new PropertySchemaDefineException(schema, "The schema is insufficient.");
        }
        this.parseSchemata(schema, DefaultPropertySchema.parseCSV(schema));
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static List parseCSV(String text) {
        ArrayList<String> list;
        block25: {
            BufferedReader br;
            StringReader sr;
            block23: {
                int length = text.length();
                list = new ArrayList<String>();
                if (length == 0) {
                    return list;
                }
                sr = new StringReader(text);
                br = new BufferedReader(sr, length);
                StringBuffer buf = new StringBuffer();
                String line = null;
                while ((line = br.readLine()) != null) {
                    String val = DefaultPropertySchema.trim(line);
                    boolean isBlockEscape = false;
                    boolean isEscape = false;
                    int max = val.length();
                    block14: for (int i = 0; i < max; ++i) {
                        char c = val.charAt(i);
                        switch (c) {
                            case ',': {
                                if (isBlockEscape) {
                                    buf.append(c);
                                    continue block14;
                                }
                                if (isEscape) {
                                    buf.append(c);
                                    isEscape = false;
                                    continue block14;
                                }
                                list.add(buf.toString());
                                buf.setLength(0);
                                continue block14;
                            }
                            case '\"': {
                                if (isBlockEscape) {
                                    isBlockEscape = false;
                                    continue block14;
                                }
                                if (isEscape) {
                                    buf.append(c);
                                    isEscape = false;
                                    continue block14;
                                }
                                isBlockEscape = true;
                                continue block14;
                            }
                            case '\\': {
                                if (isBlockEscape) {
                                    buf.append(c);
                                    continue block14;
                                }
                                if (isEscape) {
                                    buf.append(c);
                                    isEscape = false;
                                    continue block14;
                                }
                                isEscape = true;
                                continue block14;
                            }
                            default: {
                                if (!isBlockEscape && isEscape) {
                                    buf.append('\\');
                                    isEscape = false;
                                }
                                buf.append(c);
                            }
                        }
                    }
                }
                if (buf.length() == 0) break block23;
                list.add(buf.toString());
                buf.setLength(0);
            }
            Object var14_14 = null;
            try {
                br.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            sr.close();
            {
                break block25;
                catch (IOException e) {
                    e.printStackTrace();
                    Object var14_15 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    sr.close();
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    br.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                sr.close();
                throw throwable;
            }
        }
        return list;
    }

    protected static String trim(String str) {
        int i;
        String result = str;
        int max = result.length();
        for (i = 0; i < max; ++i) {
            char c = result.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result = result.substring(i);
            break;
        }
        i = result.length();
        while (--i >= 0) {
            char c = result.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result = result.substring(0, i + 1);
            break;
        }
        return result;
    }

    protected void parseSchemata(String schema, List schemata) throws PropertySchemaDefineException {
        int max = schemata.size();
        for (int i = 0; i < max; ++i) {
            this.parseSchema(schema, i, (String)schemata.get(i));
        }
    }

    protected void parseSchema(String schema, int index, String val) throws PropertySchemaDefineException {
        switch (index) {
            case 0: {
                this.parseName(schema, val);
                break;
            }
            case 1: {
                this.parseType(schema, val);
                break;
            }
            case 2: {
                this.parseParseConverter(schema, val);
                break;
            }
            case 3: {
                this.parseFormatConverter(schema, val);
                break;
            }
            case 4: {
                this.parseConstrain(schema, val);
            }
        }
    }

    protected void parseName(String schema, String val) throws PropertySchemaDefineException {
        this.name = val;
    }

    protected void parseType(String schema, String val) throws PropertySchemaDefineException {
        if (val != null && val.length() != 0) {
            try {
                this.type = DefaultPropertySchema.convertStringToClass(val, true);
            }
            catch (ClassNotFoundException e) {
                throw new PropertySchemaDefineException(schema, "The type is illegal.", e);
            }
        }
    }

    protected void parseParseConverter(String schema, String val) throws PropertySchemaDefineException {
        Object conv = this.parseConverter(schema, val);
        if (conv != null) {
            if (conv instanceof ServiceName) {
                this.parseConverterName = (ServiceName)conv;
            } else {
                this.parseConverter = (Converter)conv;
            }
        }
    }

    protected void parseFormatConverter(String schema, String val) throws PropertySchemaDefineException {
        Object conv = this.parseConverter(schema, val);
        if (conv != null) {
            if (conv instanceof ServiceName) {
                this.formatConverterName = (ServiceName)conv;
            } else {
                this.formatConverter = (Converter)conv;
            }
        }
    }

    protected Object parseConverter(String schema, String val) throws PropertySchemaDefineException {
        if (val != null && val.length() != 0) {
            if (converterManager.containsKey(val)) {
                return converterManager.get(val);
            }
            String className = val;
            List properties = null;
            int propStartIndex = className.indexOf(CONVERTER_CLASS_PROPERTY_PREFIX);
            if (propStartIndex != -1 && className.endsWith(CONVERTER_CLASS_PROPERTY_SUFFIX)) {
                properties = DefaultPropertySchema.parseCSV(className.substring(propStartIndex + 1, className.length() - 1));
                className = className.substring(0, propStartIndex);
            }
            try {
                Class converterClass = DefaultPropertySchema.convertStringToClass(className, true);
                if (!Converter.class.isAssignableFrom(converterClass)) {
                    throw new PropertySchemaDefineException(schema, "Converter dose not implement Converter.");
                }
                Converter converter = (Converter)converterClass.newInstance();
                if (properties != null && properties.size() != 0) {
                    this.initConverter(schema, converter, properties);
                }
                converterManager.put(val, converter);
                return converter;
            }
            catch (ClassNotFoundException e) {
                ServiceNameEditor serviceNameEditor = new ServiceNameEditor();
                try {
                    serviceNameEditor.setAsText(val);
                }
                catch (IllegalArgumentException e2) {
                    throw new PropertySchemaDefineException(schema, "Converter is illegal.", e2);
                }
                return (ServiceName)serviceNameEditor.getValue();
            }
            catch (InstantiationException e) {
                throw new PropertySchemaDefineException(schema, "Converter is illegal.", e);
            }
            catch (IllegalAccessException e) {
                throw new PropertySchemaDefineException(schema, "Converter is illegal.", e);
            }
        }
        return null;
    }

    protected void initConverter(String schema, Converter converter, List properties) throws PropertySchemaDefineException {
        if (converter instanceof FormatConverter) {
            this.initFormatConverter(schema, (FormatConverter)converter, properties);
        } else if (converter instanceof ReversibleConverter) {
            this.initReversibleConverter(schema, (ReversibleConverter)converter, properties);
        } else {
            throw new PropertySchemaDefineException(schema, "The property injection of this converter is not supported.");
        }
    }

    protected void initFormatConverter(String schema, FormatConverter converter, List properties) throws PropertySchemaDefineException {
        if (properties.size() != 2) {
            throw new PropertySchemaDefineException(schema, "The property injection of this converter is \"convertType,format\"");
        }
        try {
            converter.setConvertType(Integer.parseInt((String)properties.get(0)));
            converter.setFormat((String)properties.get(1));
        }
        catch (Exception e) {
            throw new PropertySchemaDefineException(schema, "The property injection of this converter is \"convertType,format\"", e);
        }
    }

    protected void initReversibleConverter(String schema, ReversibleConverter converter, List properties) throws PropertySchemaDefineException {
        if (properties.size() != 1) {
            throw new PropertySchemaDefineException(schema, "The property injection of this converter is \"convertType\"");
        }
        try {
            converter.setConvertType(Integer.parseInt((String)properties.get(0)));
        }
        catch (Exception e) {
            throw new PropertySchemaDefineException(schema, "The property injection of this converter is \"convertType\"", e);
        }
    }

    protected void parseConstrain(String schema, String val) throws PropertySchemaDefineException {
        if (val != null && val.length() != 0) {
            try {
                this.constrainExpression = new Constrain(val);
            }
            catch (Exception e) {
                throw new PropertySchemaDefineException(this.toString(), "Illegal constrain : " + val, e);
            }
        }
    }

    protected static Class convertStringToClass(String typeStr, boolean isWrapp) throws ClassNotFoundException {
        Class type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                Class clazz = isWrapp ? Byte.class : Byte.TYPE;
                type = clazz;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                Class clazz = isWrapp ? Character.class : Character.TYPE;
                type = clazz;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                Class clazz = isWrapp ? Short.class : Short.TYPE;
                type = clazz;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                Class clazz = isWrapp ? Integer.class : Integer.TYPE;
                type = clazz;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                Class clazz = isWrapp ? Long.class : Long.TYPE;
                type = clazz;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                Class clazz = isWrapp ? Float.class : Float.TYPE;
                type = clazz;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                Class clazz = isWrapp ? Double.class : Double.TYPE;
                type = clazz;
            } else if (Boolean.TYPE.getName().equals(typeStr)) {
                Class clazz = isWrapp ? Boolean.class : Boolean.TYPE;
                type = clazz;
            } else if (typeStr.endsWith(ARRAY_CLASS_SUFFIX) && typeStr.length() > 2) {
                Class elementType = DefaultPropertySchema.convertStringToClass(typeStr.substring(0, typeStr.length() - 2), false);
                type = Array.newInstance(elementType, 0).getClass();
            } else {
                type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
            }
        }
        return type;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Converter getParseConverter() {
        if (this.parseConverter != null) {
            return this.parseConverter;
        }
        if (this.parseConverterName != null) {
            return (Converter)ServiceManagerFactory.getServiceObject(this.parseConverterName);
        }
        return null;
    }

    public Converter getFormatConverter() {
        if (this.formatConverter != null) {
            return this.formatConverter;
        }
        if (this.formatConverterName != null) {
            return (Converter)ServiceManagerFactory.getServiceObject(this.formatConverterName);
        }
        return null;
    }

    public String getConstrain() {
        return this.constrainExpression == null ? null : this.constrainExpression.constrain;
    }

    public Object set(Object val) throws PropertySetException {
        this.checkSchema(val);
        return val;
    }

    public Object get(Object val) throws PropertyGetException {
        return val;
    }

    public Object format(Object val) throws PropertyGetException {
        Object result = val;
        Converter converter = this.getFormatConverter();
        if (converter != null) {
            try {
                result = converter.convert(result);
            }
            catch (ConvertException e) {
                throw new PropertyGetException((PropertySchema)this, (Throwable)e);
            }
        }
        return result;
    }

    public Object parse(Object val) throws PropertySetException {
        Object result = val;
        Converter converter = this.getParseConverter();
        if (converter != null) {
            try {
                result = converter.convert(result);
            }
            catch (ConvertException e) {
                throw new PropertySetException((PropertySchema)this, (Throwable)e);
            }
        }
        return result;
    }

    protected void checkSchema(Object val) throws PropertySchemaCheckException {
        this.checkType(val);
        this.checkConstrain(val);
    }

    protected void checkType(Object val) throws PropertySchemaCheckException {
        if (this.type == null || val == null) {
            return;
        }
        if (Number.class.isAssignableFrom(this.type) && val instanceof Number) {
            return;
        }
        Class<?> clazz = val.getClass();
        if (!this.type.isAssignableFrom(clazz)) {
            throw new PropertySchemaCheckException((PropertySchema)this, "The type is unmatch. type=" + clazz.getName());
        }
    }

    protected void checkConstrain(Object val) throws PropertySchemaCheckException {
        if (this.constrainExpression == null) {
            return;
        }
        try {
            if (!this.constrainExpression.evaluate(val)) {
                throw new PropertySchemaCheckException((PropertySchema)this, "It violates the constrain. value=" + val);
            }
        }
        catch (Exception e) {
            throw new PropertySchemaCheckException(this, "The constrain is illegal. value=" + val, e);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('{');
        buf.append("name=").append(this.name);
        buf.append(",type=").append(this.type == null ? null : this.type.getName());
        if (this.parseConverter == null && this.parseConverterName == null) {
            buf.append(",parseConverter=null");
        } else if (this.parseConverter != null) {
            buf.append(",parseConverter=").append(this.parseConverter);
        } else {
            buf.append(",parseConverter=").append(this.parseConverterName);
        }
        if (this.formatConverter == null && this.formatConverterName == null) {
            buf.append(",formatConverter=null");
        } else if (this.formatConverter != null) {
            buf.append(",formatConverter=").append(this.formatConverter);
        } else {
            buf.append(",formatConverter=").append(this.formatConverterName);
        }
        buf.append(",constrain=").append(this.constrainExpression == null ? null : this.constrainExpression.constrain);
        buf.append('}');
        return buf.toString();
    }

    protected static class Constrain {
        protected static final String CONSTRAIN_TARGET_KEY = "value";
        protected static final String CONSTRAIN_DELIMITER = "@";
        public final String constrain;
        protected final List keyList = new ArrayList();
        protected final List properties = new ArrayList();
        protected Expression expression;

        public Constrain(String constrain) throws Exception {
            this.constrain = constrain;
            StringTokenizer token = new StringTokenizer(constrain, CONSTRAIN_DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer buf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (CONSTRAIN_DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        buf.append(str);
                    }
                } else if (CONSTRAIN_DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_constrainKey" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        buf.append(tmpKey);
                        if (!beforeToken.startsWith(CONSTRAIN_TARGET_KEY)) {
                            throw new IllegalArgumentException(constrain);
                        }
                        if (CONSTRAIN_TARGET_KEY.equals(beforeToken)) {
                            this.properties.add(null);
                        } else {
                            beforeToken = beforeToken.charAt(CONSTRAIN_TARGET_KEY.length()) == '.' ? beforeToken.substring(CONSTRAIN_TARGET_KEY.length() + 1) : beforeToken.substring(CONSTRAIN_TARGET_KEY.length());
                            this.properties.add(PropertyFactory.createProperty(beforeToken));
                        }
                    } else {
                        buf.append(str);
                    }
                }
                beforeToken = str;
            }
            if (this.keyList.size() == 0) {
                throw new IllegalArgumentException(constrain);
            }
            this.expression = ExpressionFactory.createExpression((String)buf.toString());
            this.evaluate("", true);
        }

        public boolean evaluate(Object object) throws Exception {
            return this.evaluate(object, false);
        }

        protected boolean evaluate(Object object, boolean isTest) throws Exception {
            JexlContext jexlContext = JexlHelper.createContext();
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                String keyString = (String)this.keyList.get(i);
                Property property = (Property)this.properties.get(i);
                Object val = object;
                if (property != null) {
                    try {
                        val = property.getProperty(object);
                    }
                    catch (NoSuchPropertyException e) {
                    }
                    catch (InvocationTargetException e) {
                        // empty catch block
                    }
                }
                jexlContext.getVars().put(keyString, val);
            }
            Object exp = this.expression.evaluate(jexlContext);
            if (exp instanceof Boolean) {
                return (Boolean)exp;
            }
            if (exp == null && isTest) {
                return true;
            }
            throw new IllegalArgumentException(this.expression.getExpression());
        }
    }
}

