/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.CSVJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.ServletResponseCSVJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class ServletResponseCSVJournalEditorService
extends CSVJournalEditorServiceBase
implements ServletResponseCSVJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -6286194221503184866L;
    private final Map outputElements = new HashMap();
    protected String[] outputElementKeys = new String[]{"BUFFER_SIZE", "CHARACTER_ENCODING", "CONTENT_TYPE", "LOCALE", "IS_COMMITTED"};

    public ServletResponseCSVJournalEditorService() {
        this.defineElements();
    }

    protected void defineElements() {
        this.defineElementEditor("BUFFER_SIZE", new ElementEditor(){
            private static final long serialVersionUID = -7575191743363439054L;

            protected StringBuffer toString(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
                return ServletResponseCSVJournalEditorService.this.makeBufferSizeFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("CHARACTER_ENCODING", new ElementEditor(){
            private static final long serialVersionUID = 6592097705683445383L;

            protected StringBuffer toString(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
                return ServletResponseCSVJournalEditorService.this.makeCharacterEncodingFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("CONTENT_TYPE", new ElementEditor(){
            private static final long serialVersionUID = -603014377797799829L;

            protected StringBuffer toString(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
                return ServletResponseCSVJournalEditorService.this.makeContentTypeFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("LOCALE", new ElementEditor(){
            private static final long serialVersionUID = 8621678035553948526L;

            protected StringBuffer toString(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
                return ServletResponseCSVJournalEditorService.this.makeLocaleFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("IS_COMMITTED", new ElementEditor(){
            private static final long serialVersionUID = -3783827994145082331L;

            protected StringBuffer toString(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
                return ServletResponseCSVJournalEditorService.this.makeIsCommittedFormat(finder, key, response, buf);
            }
        });
    }

    protected void defineElementEditor(String key, ElementEditor editor) {
        this.outputElements.put(key, editor);
    }

    protected JournalEditor findElementEditor(String key) {
        return (JournalEditor)this.outputElements.get(key);
    }

    public void setOutputElementKeys(String[] keys) throws IllegalArgumentException {
        if (keys != null && keys.length != 0) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.outputElements.containsKey(key)) continue;
                throw new IllegalArgumentException(key + " is undefined.");
            }
            this.outputElementKeys = keys;
        }
    }

    public String[] getOutputElementKeys() {
        return this.outputElementKeys;
    }

    protected void processCSV(EditorFinder finder, Object key, Object value) {
        for (int i = 0; i < this.outputElementKeys.length; ++i) {
            JournalEditor editor = this.findElementEditor(this.outputElementKeys[i]);
            this.addElement(editor.toObject(finder, key, value));
        }
    }

    protected StringBuffer makeBufferSizeFormat(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
        return buf.append(response.getBufferSize());
    }

    protected StringBuffer makeCharacterEncodingFormat(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
        return buf.append(response.getCharacterEncoding());
    }

    protected StringBuffer makeContentTypeFormat(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
        return buf.append(response.getContentType());
    }

    protected StringBuffer makeLocaleFormat(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
        this.makeObjectFormat(finder, null, response.getLocale(), buf);
        return buf;
    }

    protected StringBuffer makeIsCommittedFormat(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
        return buf.append(response.isCommitted());
    }

    protected abstract class ElementEditor
    extends ImmutableJournalEditorServiceBase
    implements Serializable {
        protected ElementEditor() {
        }

        public String toString(EditorFinder finder, Object key, Object value) {
            StringBuffer buf = new StringBuffer(super.toString(finder, key, value));
            return this.toString(finder, key, (ServletResponse)value, buf).toString();
        }

        protected abstract StringBuffer toString(EditorFinder var1, Object var2, ServletResponse var3, StringBuffer var4);
    }
}

