/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBaseMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public abstract class ImmutableJournalEditorServiceBase
extends ServiceBase
implements ImmutableJournalEditorServiceBaseMBean,
Serializable {
    protected static final String EMPTY_STRING = "";
    protected static final String NULL_STRING = "null";
    protected static final char BACK_SPACE = '\b';
    protected static final char CARRIAGE_RETURN = '\r';
    protected static final char LINE_FEED = '\n';
    protected static final char FORM_FEED = '\f';
    protected static final char HORIZONTAL_TAB = '\t';
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String INDENT_STRING = "  ";
    private String lineSeparator = LINE_SEPARATOR;
    private String indent = "  ";
    private boolean isOutputKey = false;

    public void setOutputKey(boolean isOutput) {
        this.isOutputKey = isOutput;
    }

    public boolean isOutputKey() {
        return this.isOutputKey;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = this.convertEscapeLiteral(separator);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getIndent() {
        return this.indent;
    }

    public Object toObject(EditorFinder finder, Object key, Object value) {
        return this.toString(finder, key, value);
    }

    public String toString(EditorFinder finder, Object key, Object value) {
        StringBuffer buf = new StringBuffer();
        if (this.isOutputKey()) {
            this.makeKeyFormat(finder, key, value, buf);
        }
        return this.toString(finder, key, value, buf);
    }

    protected String toString(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        return buf.toString();
    }

    protected StringBuffer makeKeyFormat(EditorFinder finder, Object key, Object obj, StringBuffer buf) {
        if (key == null) {
            return buf;
        }
        return buf.append('[').append(key).append(']');
    }

    protected StringBuffer makeObjectFormat(EditorFinder finder, Object key, Object obj, StringBuffer buf) {
        Object value = null;
        if (obj != null) {
            JournalEditor editor = finder.findEditor(key, obj.getClass());
            value = editor != null ? editor.toObject(finder, key, obj) : obj.toString();
        }
        return buf.append(value);
    }

    protected StringBuffer addIndent(StringBuffer buf) {
        return this.setIndent(buf, 1);
    }

    protected String addIndent(String str) {
        return this.setIndent(str, 1);
    }

    protected StringBuffer setIndent(StringBuffer buf, int indent) {
        String str = buf.toString();
        buf.setLength(0);
        return buf.append(this.setIndent(str, indent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String setIndent(String str, int indent) {
        StringBuffer buf;
        block14: {
            if (str == null) {
                return null;
            }
            if (this.getIndent() == null || this.getIndent().length() == 0) {
                return str;
            }
            buf = new StringBuffer();
            for (int i = 0; i < indent; ++i) {
                buf.append(this.getIndent());
            }
            String indentString = buf.toString();
            buf.setLength(0);
            int length = str.length();
            if (length == 0) {
                return buf.toString();
            }
            StringReader sr = new StringReader(str);
            BufferedReader br = new BufferedReader(sr, length);
            String line = br.readLine();
            while (line != null) {
                buf.append(indentString).append(line);
                line = br.readLine();
                if (line == null) continue;
                buf.append(LINE_SEPARATOR);
            }
            Object var10_11 = null;
            try {
                br.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            sr.close();
            {
                break block14;
                catch (IOException e) {
                    e.printStackTrace();
                    Object var10_12 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    sr.close();
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    br.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                sr.close();
                throw throwable;
            }
        }
        return buf.toString();
    }

    private String convertEscapeLiteral(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return str;
        }
        int index = str.indexOf(92);
        if (index == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.substring(index));
        boolean isInEscape = false;
        for (int i = index; i < length; ++i) {
            int c = str.charAt(i);
            if (!isInEscape && c == 92) {
                isInEscape = true;
                continue;
            }
            if (isInEscape) {
                switch (c) {
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 92: {
                        break;
                    }
                    default: {
                        buf.append('\\');
                    }
                }
            }
            buf.append((char)c);
            isInEscape = false;
        }
        return buf.toString();
    }
}

