/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.recset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import jp.ossc.nimbus.recset.FieldSchema;
import jp.ossc.nimbus.recset.InvalidSchemaException;
import jp.ossc.nimbus.util.CsvArrayList;

public class RowSchema
implements Serializable {
    private static final long serialVersionUID = 2519505358076142786L;
    private static final String C_FIELD_TYPE_VARCHAR = "VARCHAR";
    private static final String C_FIELD_TYPE_CHAR = "CHAR";
    private static final String C_FIELD_TYPE_LONG = "LONG";
    private static final String C_FIELD_TYPE_INT = "INT";
    private static final String C_FIELD_TYPE_FLOAT = "FLOAT";
    private static final String C_FIELD_TYPE_DOUBLE = "DOUBLE";
    private static final String C_FIELD_TYPE_DATE = "DATE";
    private static final String C_FIELD_TYPE_TIMESTAMP = "TIMESTAMP";
    private static final String C_FIELD_TYPE_BLOB = "BLOB";
    private static final String C_FIELD_TYPE_CLOB = "CLOB";
    private HashMap mFieldHash = new HashMap();
    private ArrayList mFieldAry = new ArrayList();
    private ArrayList mUniqueKeyAry = new ArrayList();
    private int mHashCode = 0;

    public int getUniqueKeySize() {
        return this.mUniqueKeyAry.size();
    }

    public FieldSchema getUniqueFieldSchema(int index) {
        return (FieldSchema)this.mUniqueKeyAry.get(index);
    }

    public RowSchema makeGoneSchema() {
        RowSchema ret = new RowSchema();
        for (int rcnt = 0; rcnt < this.mFieldAry.size(); ++rcnt) {
            FieldSchema fs = this.get(rcnt);
            FieldSchema newFs = new FieldSchema();
            newFs.setFieldName(fs.getFieldName());
            newFs.setFieldType(fs.getFieldType());
            newFs.setFieldLength(fs.getFieldLength());
            newFs.setFieldKey(fs.getFieldKey());
            newFs.setCrypt(fs.isCrypt());
            if (!fs.isUpdateField()) continue;
            ret.add(newFs);
        }
        return ret;
    }

    public Integer getHashCodeObject() {
        return new Integer(this.mHashCode);
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        if (this == another) {
            return true;
        }
        return another instanceof RowSchema && this.mHashCode == another.hashCode();
    }

    public void initSchema(String schema) {
        if (this.mFieldAry.size() == 0) {
            CsvArrayList parser = new CsvArrayList();
            parser.splitCL(schema);
            ListIterator ite = parser.listIterator();
            while (ite.hasNext()) {
                String fieldStr = (String)ite.next();
                FieldSchema field = this.makeFieldSchema(fieldStr);
                if (field == null) continue;
                this.add(field);
            }
            this.mHashCode = schema.hashCode();
        }
    }

    private FieldSchema makeFieldSchema(String fieldInf) {
        if (fieldInf == null || fieldInf.length() == 0) {
            return null;
        }
        CsvArrayList colInf = new CsvArrayList();
        int sz = colInf.split(fieldInf);
        if (sz < 4) {
            throw new InvalidSchemaException(fieldInf + "invalid");
        }
        FieldSchema field = new FieldSchema();
        field.setFieldName(colInf.getStr(0));
        String tp = colInf.getStr(1);
        if (tp.equals(C_FIELD_TYPE_VARCHAR)) {
            field.setFieldType(2);
        } else if (tp.equals(C_FIELD_TYPE_CHAR)) {
            field.setFieldType(3);
        } else if (tp.equals(C_FIELD_TYPE_LONG)) {
            field.setFieldType(8);
        } else if (tp.equals(C_FIELD_TYPE_INT)) {
            field.setFieldType(1);
        } else if (tp.equals(C_FIELD_TYPE_DOUBLE)) {
            field.setFieldType(7);
        } else if (tp.equals(C_FIELD_TYPE_FLOAT)) {
            field.setFieldType(5);
        } else if (tp.equals(C_FIELD_TYPE_DATE)) {
            field.setFieldType(4);
        } else if (tp.equals(C_FIELD_TYPE_TIMESTAMP)) {
            field.setFieldType(9);
        } else if (tp.equals(C_FIELD_TYPE_BLOB)) {
            field.setFieldType(10);
        } else if (tp.equals(C_FIELD_TYPE_CLOB)) {
            field.setFieldType(11);
        } else {
            throw new InvalidSchemaException(fieldInf + " invalid");
        }
        field.setFieldLength(Integer.parseInt(colInf.getStr(2)));
        field.setFieldKey(Integer.parseInt(colInf.getStr(3)));
        if (sz > 4) {
            field.setCrypt(Integer.parseInt(colInf.getStr(4)) > 0);
        }
        return field;
    }

    public int size() {
        if (this.mFieldAry == null) {
            return 0;
        }
        return this.mFieldAry.size();
    }

    public FieldSchema get(int index) {
        return (FieldSchema)this.mFieldAry.get(index);
    }

    public FieldSchema get(String name) {
        return (FieldSchema)this.mFieldHash.get(name);
    }

    public ListIterator listIterator() {
        return this.mFieldAry.listIterator();
    }

    private void add(FieldSchema scm) {
        if (this.mFieldHash.containsKey(scm.getFieldName())) {
            throw new InvalidSchemaException(scm.getFieldName() + "is duplicate");
        }
        this.mFieldHash.put(scm.getFieldName(), scm);
        this.mFieldAry.add(scm);
        scm.setIndex(this.mFieldAry.size() - 1);
        if (scm.isUniqueKey()) {
            this.mUniqueKeyAry.add(scm);
        }
    }
}

