/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;

public class PrefixFileFilter
implements FilenameFilter,
Serializable {
    private static final long serialVersionUID = 3579204076741445814L;
    protected String prefix;
    private String upperPrefix;
    protected boolean isIgnoreCase;

    public PrefixFileFilter() {
        this(null, false);
    }

    public PrefixFileFilter(String prefix) {
        this(prefix, false);
    }

    public PrefixFileFilter(String prefix, boolean isIgnoreCase) {
        this.setPrefix(prefix);
        this.setIgnoreCase(isIgnoreCase);
    }

    public void setPrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            this.prefix = null;
        } else {
            this.prefix = prefix;
            this.upperPrefix = prefix.toUpperCase();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setIgnoreCase(boolean isIgnoreCase) {
        this.isIgnoreCase = isIgnoreCase;
    }

    public boolean isIgnoreCase() {
        return this.isIgnoreCase;
    }

    public boolean accept(File dir, String fileName) {
        if (this.isIgnoreCase) {
            String tmp = fileName.toUpperCase();
            return tmp.startsWith(this.upperPrefix);
        }
        return fileName.startsWith(this.prefix);
    }
}

