/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.Serializable;
import jp.ossc.nimbus.util.converter.AlphabetCharacterConverter;
import jp.ossc.nimbus.util.converter.AlphabetStringConverter;
import jp.ossc.nimbus.util.converter.CharacterConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;
import jp.ossc.nimbus.util.converter.CustomConverter;
import jp.ossc.nimbus.util.converter.CustomStringConverter;
import jp.ossc.nimbus.util.converter.KatakanaCharacterConverter;
import jp.ossc.nimbus.util.converter.KatakanaHiraganaCharacterConverter;
import jp.ossc.nimbus.util.converter.KatakanaHiraganaStringConverter;
import jp.ossc.nimbus.util.converter.KatakanaStringConverter;
import jp.ossc.nimbus.util.converter.NumberCharacterConverter;
import jp.ossc.nimbus.util.converter.NumberStringConverter;
import jp.ossc.nimbus.util.converter.PatternStringConverter;
import jp.ossc.nimbus.util.converter.StringConverter;
import jp.ossc.nimbus.util.converter.SymbolCharacterConverter;
import jp.ossc.nimbus.util.converter.SymbolStringConverter;

public class Converters {
    private static final StringConverter ALPHABET_HANKAKU_FROM_ZENKAKU_STRING = new StringConverterImpl(new AlphabetStringConverter(1));
    private static final StringConverter ALPHABET_ZENKAKU_FROM_HANKAKU_STRING = new StringConverterImpl(new AlphabetStringConverter(2));
    private static final StringConverter KATAKANA_HANKAKU_FROM_ZENKAKU_STRING = new StringConverterImpl(new KatakanaStringConverter(1));
    private static final StringConverter KATAKANA_ZENKAKU_FROM_HANKAKU_STRING = new StringConverterImpl(new KatakanaStringConverter(2));
    private static final StringConverter NUMBER_HANKAKU_FROM_ZENKAKU_STRING = new StringConverterImpl(new NumberStringConverter(1));
    private static final StringConverter NUMBER_ZENKAKU_FROM_HANKAKU_STRING = new StringConverterImpl(new NumberStringConverter(2));
    private static final StringConverter SYMBOL_HANKAKU_FROM_ZENKAKU_STRING = new StringConverterImpl(new SymbolStringConverter(1));
    private static final StringConverter SYMBOL_ZENKAKU_FROM_HANKAKU_STRING = new StringConverterImpl(new SymbolStringConverter(2));
    private static final StringConverter KATAKANA_FROM_HIRAGANA_STRING = new StringConverterImpl(new KatakanaHiraganaStringConverter(1));
    private static final StringConverter HIRAGANA_FROM_KATAKANA_STRING = new StringConverterImpl(new KatakanaHiraganaStringConverter(2));
    private static final StringConverter HANKAKU_FROM_ZENKAKU_STRING = new StringConverterImpl(new CustomConverter(new Converter[]{new AlphabetStringConverter(1), new KatakanaStringConverter(1), new NumberStringConverter(1), new SymbolStringConverter(1)}));
    private static final StringConverter ZENKAKU_FROM_HANKAKU_STRING = new StringConverterImpl(new CustomConverter(new Converter[]{new AlphabetStringConverter(2), new KatakanaStringConverter(2), new NumberStringConverter(2), new SymbolStringConverter(2)}));
    private static final CharacterConverter ALPHABET_HANKAKU_FROM_ZENKAKU_CHAR = new CharacterConverterImpl(new AlphabetCharacterConverter(1));
    private static final CharacterConverter ALPHABET_ZENKAKU_FROM_HANKAKU_CHAR = new CharacterConverterImpl(new AlphabetCharacterConverter(2));
    private static final CharacterConverter KATAKANA_HANKAKU_FROM_ZENKAKU_CHAR = new CharacterConverterImpl(new KatakanaCharacterConverter(1));
    private static final CharacterConverter KATAKANA_ZENKAKU_FROM_HANKAKU_CHAR = new CharacterConverterImpl(new KatakanaCharacterConverter(2));
    private static final CharacterConverter NUMBER_HANKAKU_FROM_ZENKAKU_CHAR = new CharacterConverterImpl(new NumberCharacterConverter(1));
    private static final CharacterConverter NUMBER_ZENKAKU_FROM_HANKAKU_CHAR = new CharacterConverterImpl(new NumberCharacterConverter(2));
    private static final CharacterConverter SYMBOL_HANKAKU_FROM_ZENKAKU_CHAR = new CharacterConverterImpl(new SymbolCharacterConverter(1));
    private static final CharacterConverter SYMBOL_ZENKAKU_FROM_HANKAKU_CHAR = new CharacterConverterImpl(new SymbolCharacterConverter(2));
    private static final CharacterConverter KATAKANA_FROM_HIRAGANA_CHAR = new CharacterConverterImpl(new KatakanaHiraganaCharacterConverter(1));
    private static final CharacterConverter HIRAGANA_FROM_KATAKANA_CHAR = new CharacterConverterImpl(new KatakanaHiraganaCharacterConverter(2));
    private static final CharacterConverter HANKAKU_FROM_ZENKAKU_CHAR = new CharacterConverterImpl(new CustomConverter(new Converter[]{new AlphabetCharacterConverter(1), new KatakanaCharacterConverter(1), new NumberCharacterConverter(1), new SymbolCharacterConverter(1)}));
    private static final CharacterConverter ZENKAKU_FROM_HANKAKU_CHAR = new CharacterConverterImpl(new CustomConverter(new Converter[]{new AlphabetCharacterConverter(2), new KatakanaCharacterConverter(2), new NumberCharacterConverter(2), new SymbolCharacterConverter(2)}));

    private Converters() {
    }

    public static StringConverter getAlphabetHankakuFromZenkakuStringConverter() {
        return ALPHABET_HANKAKU_FROM_ZENKAKU_STRING;
    }

    public static StringConverter getAlphabetZenkakuFromHankakuStringConverter() {
        return ALPHABET_ZENKAKU_FROM_HANKAKU_STRING;
    }

    public static StringConverter getKatakanaHankakuFromZenkakuStringConverter() {
        return KATAKANA_HANKAKU_FROM_ZENKAKU_STRING;
    }

    public static StringConverter getKatakanaZenkakuFromHankakuStringConverter() {
        return KATAKANA_ZENKAKU_FROM_HANKAKU_STRING;
    }

    public static StringConverter getNumberHankakuFromZenkakuStringConverter() {
        return NUMBER_HANKAKU_FROM_ZENKAKU_STRING;
    }

    public static StringConverter getNumberZenkakuFromHankakuStringConverter() {
        return NUMBER_ZENKAKU_FROM_HANKAKU_STRING;
    }

    public static StringConverter getSymbolHankakuFromZenkakuStringConverter() {
        return SYMBOL_HANKAKU_FROM_ZENKAKU_STRING;
    }

    public static StringConverter getSymbolZenkakuFromHankakuStringConverter() {
        return SYMBOL_ZENKAKU_FROM_HANKAKU_STRING;
    }

    public static StringConverter getKatakanaFromHiraganaStringConverter() {
        return KATAKANA_FROM_HIRAGANA_STRING;
    }

    public static StringConverter getHiraganaFromKatakanaStringConverter() {
        return HIRAGANA_FROM_KATAKANA_STRING;
    }

    public static StringConverter getHankakuFromZenkakuStringConverter() {
        return HANKAKU_FROM_ZENKAKU_STRING;
    }

    public static StringConverter getZenkakuFromHankakuStringConverter() {
        return ZENKAKU_FROM_HANKAKU_STRING;
    }

    public static CharacterConverter getAlphabetHankakuFromZenkakuCharacterConverter() {
        return ALPHABET_HANKAKU_FROM_ZENKAKU_CHAR;
    }

    public static CharacterConverter getAlphabetZenkakuFromHankakuCharacterConverter() {
        return ALPHABET_ZENKAKU_FROM_HANKAKU_CHAR;
    }

    public static CharacterConverter getKatakanaHankakuFromZenkakuCharacterConverter() {
        return KATAKANA_HANKAKU_FROM_ZENKAKU_CHAR;
    }

    public static CharacterConverter getKatakanaZenkakuFromHankakuCharacterConverter() {
        return KATAKANA_ZENKAKU_FROM_HANKAKU_CHAR;
    }

    public static CharacterConverter getNumberHankakuFromZenkakuCharacterConverter() {
        return NUMBER_HANKAKU_FROM_ZENKAKU_CHAR;
    }

    public static CharacterConverter getNumberZenkakuFromHankakuCharacterConverter() {
        return NUMBER_ZENKAKU_FROM_HANKAKU_CHAR;
    }

    public static CharacterConverter getSymbolHankakuFromZenkakuCharacterConverter() {
        return SYMBOL_HANKAKU_FROM_ZENKAKU_CHAR;
    }

    public static CharacterConverter getSymbolZenkakuFromHankakuCharacterConverter() {
        return SYMBOL_ZENKAKU_FROM_HANKAKU_CHAR;
    }

    public static CharacterConverter getKatakanaFromHiraganaCharacterConverter() {
        return KATAKANA_FROM_HIRAGANA_CHAR;
    }

    public static CharacterConverter getHiraganaFromKatakanaCharacterConverter() {
        return HIRAGANA_FROM_KATAKANA_CHAR;
    }

    public static CharacterConverter getHankakuFromZenkakuCharacterConverter() {
        return HANKAKU_FROM_ZENKAKU_CHAR;
    }

    public static CharacterConverter getZenkakuFromHankakuCharacterConverter() {
        return ZENKAKU_FROM_HANKAKU_CHAR;
    }

    public static StringConverter newCustomStringConverter(int type, String[] fromStrs, String[] toStrs) {
        return new CustomStringConverter(type, fromStrs, toStrs);
    }

    public static StringConverter newCustomStringConverter(int type, char[] fromChars, char[] toChars) {
        return new CustomStringConverter(type, fromChars, toChars);
    }

    public static StringConverter newCustomStringConverter(int type, String[] fromStrs, String[] toStrs, char[] fromChars, char[] toChars) {
        return new CustomStringConverter(type, fromStrs, toStrs, fromChars, toChars);
    }

    public static CustomConverter newCustomConverter() {
        return new CustomConverter();
    }

    public static CustomConverter newCustomConverter(Converter[] convs) {
        return new CustomConverter(convs);
    }

    public static PatternStringConverter patternStringConverter() {
        return new PatternStringConverter();
    }

    public static PatternStringConverter patternStringConverter(int flags) {
        return new PatternStringConverter(flags);
    }

    public static PatternStringConverter patternStringConverter(int flags, String[] fromStrs, String[] toStrs) {
        return new PatternStringConverter(flags, fromStrs, toStrs);
    }

    private static final class CharacterConverterImpl
    implements CharacterConverter,
    Serializable {
        private Converter converter;

        public CharacterConverterImpl(Converter conv) {
            this.converter = conv;
        }

        public CharacterConverterImpl(CharacterConverter conv) {
            this.converter = conv;
        }

        public Object convert(Object obj) throws ConvertException {
            return this.converter.convert(obj);
        }

        public Character convert(Character c) throws ConvertException {
            return (Character)this.converter.convert(c);
        }

        public char convert(char c) throws ConvertException {
            if (this.converter instanceof CharacterConverter) {
                return ((CharacterConverter)this.converter).convert(c);
            }
            return c;
        }
    }

    private static final class StringConverterImpl
    implements StringConverter,
    Serializable {
        private Converter converter;

        public StringConverterImpl(Converter conv) {
            this.converter = conv;
        }

        public StringConverterImpl(StringConverter conv) {
            this.converter = conv;
        }

        public Object convert(Object obj) throws ConvertException {
            return this.converter.convert(obj);
        }

        public String convert(String obj) throws ConvertException {
            return (String)this.converter.convert(obj);
        }
    }
}

