/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.smtpchecker;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.smtpchecker.SmtpChekerServiceMBean;
import jp.ossc.nimbus.service.smtpchecker.SmtpKeepAliveChecker;

public class SmtpCheckerService
extends ServiceBase
implements SmtpChekerServiceMBean,
SmtpKeepAliveChecker {
    protected String mHostName;
    protected InetAddress mIp;
    protected volatile int mPort = 0;
    protected volatile int mTimeOut = 1000;
    protected Logger mLogger;
    protected ServiceName mLoggerName;
    protected static final String C_HELLOW = "HELO localhost\r\n";
    protected static final String C_STOP_KEY = "WOUGN0600002002";
    protected static final String C_WRONG_SIGN = "2";
    protected static final String C_ERRSTATE_KEY = "WOUGN0600002003";
    protected static final String C_NORMALSTATE_KEY = "WOUGN0600002004";
    protected static final String C_QUITE = "QUIT\r\n";
    protected static final String C_TIMEOUT_KEY = "WOUGN0600002005";
    protected static final String C_PROTOCAL_KEY = "WOUGN0600002006";
    protected static final String C_IOERROR_KEY = "WOUGN0600002007";
    protected static final String C_CLOSEERROR_KEY = "WOUGN0600002008";

    public void startService() {
        if (this.mLoggerName != null) {
            this.mLogger = (Logger)ServiceManagerFactory.getServiceObject(this.mLoggerName);
        }
    }

    public void setStateChangeLoggerServiceName(ServiceName name) {
        this.mLoggerName = name;
    }

    public ServiceName getStateChangeLoggerServiceName() {
        if (this.mLoggerName == null) {
            return null;
        }
        return this.mLoggerName;
    }

    public void setHostName(String hostName) {
        this.mHostName = hostName;
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(hostName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mIp = ia;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public void setPort(int port) {
        this.mPort = port;
    }

    public int getPort() {
        return this.mPort;
    }

    public void setTimeoutMiliSeconds(int milisec) {
        this.mTimeOut = milisec;
    }

    public int getTimeoutMiliSeconds() {
        return this.mTimeOut;
    }

    public String getHostIp() {
        return this.mIp.getHostAddress();
    }

    public void setLogger(Logger logger) {
        this.mLogger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isAlive() {
        boolean ret;
        block32: {
            Socket sock;
            block31: {
                ret = true;
                sock = null;
                int len = 1024;
                sock = new Socket(this.mIp, this.mPort);
                BufferedInputStream in = new BufferedInputStream(sock.getInputStream(), len);
                BufferedOutputStream out = new BufferedOutputStream(sock.getOutputStream(), len);
                String hello = C_HELLOW;
                out.write(hello.getBytes(), 0, hello.getBytes().length);
                out.flush();
                sock.setSoTimeout(this.mTimeOut);
                byte[] resBuf = new byte[len];
                int readLen = in.read(resBuf, 0, len);
                if (readLen == -1) {
                    if (this.mLogger != null) {
                        this.mLogger.write(C_STOP_KEY, (Object)this.mHostName);
                    }
                    ret = false;
                    break block31;
                }
                String retCode = new String(resBuf, 0, readLen);
                if (!retCode.startsWith(C_WRONG_SIGN)) {
                    if (this.mLogger != null) {
                        Object[] wd = new String[]{this.mHostName, retCode};
                        this.mLogger.write(C_ERRSTATE_KEY, wd);
                    }
                    ret = false;
                } else if (this.mLogger != null) {
                    this.mLogger.write(C_NORMALSTATE_KEY, (Object)this.mHostName);
                }
                String quit = C_QUITE;
                out.write(quit.getBytes(), 0, quit.getBytes().length);
                out.flush();
            }
            Object var12_16 = null;
            try {
                if (sock != null) {
                    sock.close();
                }
                break block32;
            }
            catch (Exception ex) {
                if (this.mLogger != null) {
                    Object[] wd = new String[]{this.mHostName};
                    this.mLogger.write(C_CLOSEERROR_KEY, wd, (Throwable)ex);
                }
                ret = false;
            }
            break block32;
            {
                catch (InterruptedIOException e) {
                    if (this.mLogger != null) {
                        this.mLogger.write(C_TIMEOUT_KEY, (Object)this.mHostName);
                    }
                    ret = false;
                    Object var12_17 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                        }
                        break block32;
                    }
                    catch (Exception ex) {
                        if (this.mLogger != null) {
                            Object[] wd = new String[]{this.mHostName};
                            this.mLogger.write(C_CLOSEERROR_KEY, wd, (Throwable)ex);
                        }
                        ret = false;
                    }
                    break block32;
                }
                catch (SocketException e) {
                    if (this.mLogger != null) {
                        Object[] wd = new String[]{this.mHostName};
                        this.mLogger.write(C_PROTOCAL_KEY, wd, (Throwable)e);
                    }
                    ret = false;
                    Object var12_18 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                        }
                        break block32;
                    }
                    catch (Exception ex) {
                        if (this.mLogger != null) {
                            Object[] wd = new String[]{this.mHostName};
                            this.mLogger.write(C_CLOSEERROR_KEY, wd, (Throwable)ex);
                        }
                        ret = false;
                    }
                    break block32;
                }
                catch (IOException e) {
                    if (this.mLogger != null) {
                        Object[] wd = new String[]{this.mHostName};
                        this.mLogger.write(C_IOERROR_KEY, wd, (Throwable)e);
                    }
                    ret = false;
                    Object var12_19 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                        }
                        break block32;
                    }
                    catch (Exception ex) {
                        if (this.mLogger != null) {
                            Object[] wd = new String[]{this.mHostName};
                            this.mLogger.write(C_CLOSEERROR_KEY, wd, (Throwable)ex);
                        }
                        ret = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                try {
                    if (sock != null) {
                        sock.close();
                    }
                }
                catch (Exception ex) {
                    if (this.mLogger != null) {
                        Object[] wd = new String[]{this.mHostName};
                        this.mLogger.write(C_CLOSEERROR_KEY, wd, (Throwable)ex);
                    }
                    ret = false;
                }
                throw throwable;
            }
        }
        return ret;
    }
}

