/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class MemorySemaphore
implements Semaphore,
Serializable {
    protected volatile int mResourceCnt = -1;
    protected volatile int mInitialResource = -1;
    protected volatile boolean mFourceEndFlg = false;
    protected transient List waitThreads = new Vector();
    protected transient Set wakeUpThreads = Collections.synchronizedSet(new HashSet());
    protected transient List usedThreads = new Vector();
    protected transient Map threadTasks = Collections.synchronizedMap(new HashMap());
    protected long sleepTime = 10000L;
    protected transient Timer forceFreeTimer = new Timer(true);

    public boolean getResource() {
        return this.getResource(-1L);
    }

    public boolean getResource(int maxWaitCount) {
        return this.getResource(-1L, maxWaitCount);
    }

    public boolean getResource(long timeOutMiliSecond) {
        return this.getResource(timeOutMiliSecond, -1);
    }

    public boolean getResource(long timeOutMiliSecond, int maxWaitCount) {
        return this.getResource(timeOutMiliSecond, maxWaitCount, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getResource(long timeOutMiliSecond, int maxWaitCount, long forceFreeMiliSecond) {
        Thread current;
        block43: {
            boolean bl;
            block42: {
                boolean bl2;
                block41: {
                    boolean bl3;
                    block40: {
                        boolean bl4;
                        block39: {
                            List list;
                            boolean bl5;
                            block38: {
                                if (maxWaitCount > 0 && this.waitThreads.size() >= maxWaitCount) {
                                    return false;
                                }
                                current = Thread.currentThread();
                                if (this.waitThreads != null) {
                                    List list2 = this.waitThreads;
                                    synchronized (list2) {
                                        this.waitThreads.add(current);
                                        this.wakeUpThreads.add(current);
                                    }
                                }
                                long timeOutMs = -1L;
                                if (timeOutMiliSecond >= 0L) {
                                    timeOutMs = timeOutMiliSecond;
                                }
                                long processTime = 0L;
                                try {
                                    while (timeOutMs <= 0L || timeOutMs > processTime) {
                                        if (this.mFourceEndFlg) {
                                            bl5 = false;
                                            Object var17_15 = null;
                                            if (this.waitThreads == null) return bl5;
                                            list = this.waitThreads;
                                            break block38;
                                        }
                                        while (this.mResourceCnt == 0 && (timeOutMs < 0L || timeOutMs > processTime)) {
                                            if (this.mFourceEndFlg) {
                                                bl4 = false;
                                                break block39;
                                            }
                                            long proc = 0L;
                                            if (timeOutMs > 0L) {
                                                proc = System.currentTimeMillis();
                                            }
                                            try {
                                                if (!Thread.interrupted()) {
                                                    this.wakeUpThreads.remove(current);
                                                    Thread.sleep(timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime);
                                                    this.wakeUpThreads.add(current);
                                                }
                                            }
                                            catch (InterruptedException e) {
                                                if (!this.wakeUpThreads.contains(current)) {
                                                    boolean bl6 = false;
                                                    Object var17_17 = null;
                                                    if (this.waitThreads == null) return bl6;
                                                    List list3 = this.waitThreads;
                                                    synchronized (list3) {
                                                        this.waitThreads.remove(current);
                                                        this.wakeUpThreads.remove(current);
                                                        return bl6;
                                                    }
                                                }
                                                Thread.interrupted();
                                            }
                                            if (timeOutMs <= 0L) continue;
                                            proc = System.currentTimeMillis() - proc;
                                            processTime += proc;
                                        }
                                        MemorySemaphore memorySemaphore = this;
                                        synchronized (memorySemaphore) {
                                            if (this.mFourceEndFlg) {
                                                bl3 = false;
                                                // MONITOREXIT @DISABLED, blocks:[1, 35, 20, 10] lbl66 : MonitorExitStatement: MONITOREXIT : var11_8
                                                break block40;
                                            }
                                            if (this.mResourceCnt > 0 && this.waitThreads.size() != 0 && this.waitThreads.get(0) == current) {
                                                --this.mResourceCnt;
                                                ForceFreeTimerTask task = null;
                                                if (forceFreeMiliSecond > 0L) {
                                                    task = new ForceFreeTimerTask(current);
                                                    this.forceFreeTimer.schedule((TimerTask)task, forceFreeMiliSecond);
                                                }
                                                this.usedThreads.add(current);
                                                if (this.threadTasks.containsKey(current)) {
                                                    Object tasks = this.threadTasks.get(current);
                                                    ArrayList<Object> taskList = null;
                                                    if (tasks instanceof List) {
                                                        taskList = (ArrayList<Object>)tasks;
                                                    } else {
                                                        taskList = new ArrayList<Object>();
                                                        taskList.add(tasks);
                                                        this.threadTasks.put(current, taskList);
                                                    }
                                                    taskList.add(task);
                                                } else {
                                                    this.threadTasks.put(current, task);
                                                }
                                                bl2 = true;
                                                // MONITOREXIT @DISABLED, blocks:[1, 34, 20, 10] lbl94 : MonitorExitStatement: MONITOREXIT : var11_8
                                                break block41;
                                            }
                                            if (timeOutMs == 0L) {
                                                bl = false;
                                                // MONITOREXIT @DISABLED, blocks:[33, 1, 20, 10] lbl99 : MonitorExitStatement: MONITOREXIT : var11_8
                                                break block42;
                                            }
                                        }
                                    }
                                    break block43;
                                }
                                catch (Throwable throwable) {
                                    Object var17_22 = null;
                                    if (this.waitThreads == null) throw throwable;
                                    List list4 = this.waitThreads;
                                    synchronized (list4) {
                                        this.waitThreads.remove(current);
                                        this.wakeUpThreads.remove(current);
                                        throw throwable;
                                    }
                                }
                            }
                            synchronized (list) {
                                this.waitThreads.remove(current);
                                this.wakeUpThreads.remove(current);
                                return bl5;
                            }
                        }
                        Object var17_16 = null;
                        if (this.waitThreads == null) return bl4;
                        List list = this.waitThreads;
                        synchronized (list) {
                            this.waitThreads.remove(current);
                            this.wakeUpThreads.remove(current);
                            return bl4;
                        }
                    }
                    Object var17_18 = null;
                    if (this.waitThreads == null) return bl3;
                    List list = this.waitThreads;
                    synchronized (list) {
                        this.waitThreads.remove(current);
                        this.wakeUpThreads.remove(current);
                        return bl3;
                    }
                }
                Object var17_19 = null;
                if (this.waitThreads == null) return bl2;
                List list = this.waitThreads;
                synchronized (list) {
                    this.waitThreads.remove(current);
                    this.wakeUpThreads.remove(current);
                    return bl2;
                }
            }
            Object var17_20 = null;
            if (this.waitThreads == null) return bl;
            List list = this.waitThreads;
            synchronized (list) {
                this.waitThreads.remove(current);
                this.wakeUpThreads.remove(current);
                return bl;
            }
        }
        Object var17_21 = null;
        if (this.waitThreads == null) return false;
        List list = this.waitThreads;
        synchronized (list) {
            this.waitThreads.remove(current);
            this.wakeUpThreads.remove(current);
            return false;
        }
    }

    public void freeResource() {
        this.freeResource(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void freeResource(Thread usedThread) {
        if (this.usedThreads.contains(usedThread)) {
            Object task;
            Object tasks = this.threadTasks.get(usedThread);
            if (tasks instanceof List) {
                List taskList = (List)tasks;
                TimerTask task2 = (TimerTask)taskList.remove(0);
                if (task2 != null) {
                    task2.cancel();
                }
                if (taskList.size() == 0) {
                    this.threadTasks.remove(usedThread);
                    this.usedThreads.remove(usedThread);
                }
            } else {
                task = (TimerTask)tasks;
                if (task != null) {
                    ((TimerTask)task).cancel();
                }
                this.threadTasks.remove(usedThread);
                this.usedThreads.remove(usedThread);
            }
            if (this.mResourceCnt < this.mInitialResource) {
                task = this;
                synchronized (task) {
                    ++this.mResourceCnt;
                }
            }
        }
        List list = this.waitThreads;
        synchronized (list) {
            Thread waitThread;
            if (this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread = (Thread)this.waitThreads.get(0))) {
                this.wakeUpThreads.add(waitThread);
                waitThread.interrupt();
            }
        }
    }

    public int getResourceCapacity() {
        return this.mInitialResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceCapacity(int capa) {
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            if (this.mInitialResource == -1) {
                this.mInitialResource = capa;
                this.mResourceCnt = capa;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceRemain() {
        int cnt;
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            cnt = this.mResourceCnt;
        }
        return cnt;
    }

    public int getWaitingCount() {
        return this.waitThreads.size();
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        this.mFourceEndFlg = true;
        List list = this.waitThreads;
        synchronized (list) {
            Thread waitThread;
            if (this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread = (Thread)this.waitThreads.get(0))) {
                this.wakeUpThreads.add(waitThread);
                waitThread.interrupt();
            }
        }
        while (this.usedThreads.size() != 0) {
            this.freeResource((Thread)this.usedThreads.get(0));
        }
        this.forceFreeTimer.cancel();
        this.forceFreeTimer = new Timer(true);
    }

    public synchronized void accept() {
        this.mFourceEndFlg = false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.waitThreads = new Vector();
        this.wakeUpThreads = Collections.synchronizedSet(new HashSet());
        this.usedThreads = new Vector();
        this.threadTasks = Collections.synchronizedMap(new HashMap());
        this.forceFreeTimer = new Timer(true);
    }

    protected class ForceFreeTimerTask
    extends TimerTask {
        protected Thread usedThread;

        public ForceFreeTimerTask(Thread usedThread) {
            this.usedThread = usedThread;
        }

        public void run() {
            MemorySemaphore.this.freeResource(this.usedThread);
        }
    }
}

