/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.msgresource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.byteconvert.ByteConverter;
import jp.ossc.nimbus.service.msgresource.CommonMessageFormat;
import jp.ossc.nimbus.service.msgresource.MessageFormat;
import jp.ossc.nimbus.service.msgresource.MessageResourceDefine;
import jp.ossc.nimbus.service.msgresource.MessageResourceUtil;
import jp.ossc.nimbus.util.CsvArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BytesOrStreamMessageFormat
extends CommonMessageFormat
implements MessageFormat,
MessageResourceDefine {
    private ArrayList mPayLoadItems = null;
    private ByteConverter mByteConverter = null;
    private String mMessageType = null;
    final String TYPE_VALUE_SEP = ":";
    final int BUFLEN = 8192;

    public BytesOrStreamMessageFormat(ByteConverter converter, String msgType) {
        super(converter);
        this.mByteConverter = converter;
        this.mPayLoadItems = new ArrayList();
        this.mPropertyItems = new ArrayList();
        if (!msgType.equals("Bytes") && !msgType.equals("Stream")) {
            throw new ServiceException("MESSAGERESOURCEFACTORY015", "Must be Specified Bytes OR Stream");
        }
        this.mMessageType = msgType;
    }

    public String marshal(Message msg) {
        if (!(msg instanceof BytesMessage) && !(msg instanceof StreamMessage)) {
            return null;
        }
        byte[] readBytesBuffer = new byte[8192];
        StringBuffer retMsg = new StringBuffer();
        MessageWrapper msgWrapper = new MessageWrapper(msg);
        try {
            retMsg.append(this.dumpProperties(msg));
            Iterator Items = this.mPayLoadItems.iterator();
            while (Items.hasNext()) {
                PayLoadItem item = (PayLoadItem)Items.next();
                int type = item.getType();
                block1 : switch (type) {
                    case 0: {
                        retMsg.append("Byte");
                        retMsg.append(":");
                        int tmp = msgWrapper.readByte();
                        retMsg.append("0x");
                        retMsg.append(Integer.toHexString(tmp));
                        break;
                    }
                    case 1: {
                        retMsg.append("UnsignedByte");
                        retMsg.append(":");
                        int tmp = msgWrapper.readUnsignedByte();
                        retMsg.append("0x");
                        retMsg.append(Integer.toHexString(tmp));
                        break;
                    }
                    case 2: {
                        int tmp;
                        retMsg.append("Bytes");
                        retMsg.append(":");
                        int readNum = -1;
                        while ((readNum = msgWrapper.readBytes(readBytesBuffer)) != -1) {
                            for (int rCnt = 0; rCnt < readNum; ++rCnt) {
                                tmp = readBytesBuffer[rCnt];
                                retMsg.append("0x");
                                retMsg.append(Integer.toHexString(tmp));
                                retMsg.append(" ");
                            }
                            if (readNum != 8192) break block1;
                        }
                        break;
                    }
                    case 3: {
                        retMsg.append("Boolean");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readBoolean());
                        break;
                    }
                    case 4: {
                        retMsg.append("Char");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readChar());
                        break;
                    }
                    case 5: {
                        retMsg.append("Short");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readShort());
                        break;
                    }
                    case 6: {
                        retMsg.append("UnsignedShort");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readUnsignedShort());
                        break;
                    }
                    case 7: {
                        retMsg.append("Int");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readInt());
                        break;
                    }
                    case 8: {
                        retMsg.append("Long");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readLong());
                        break;
                    }
                    case 9: {
                        retMsg.append("Float");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readFloat());
                        break;
                    }
                    case 10: {
                        retMsg.append("Double");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readDouble());
                        break;
                    }
                    case 11: {
                        retMsg.append("UTF");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readUTF());
                        break;
                    }
                    case 12: {
                        retMsg.append("String");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readString());
                        break;
                    }
                    case 13: {
                        retMsg.append("Object");
                        retMsg.append("(" + this.getWrappedTypeStr(item.getWrappedType()) + ")");
                        retMsg.append(":");
                        retMsg.append(msgWrapper.readObject());
                    }
                }
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new ServiceException("MESSAGERESOURCEFACTORY016", "Fail to read Message", e);
        }
        return retMsg.toString();
    }

    protected void setPayload(Message msg, String payload) {
        MessageWrapper msgWrapper = new MessageWrapper(msg);
        Iterator Items = this.mPayLoadItems.iterator();
        try {
            while (Items.hasNext()) {
                PayLoadItem item = (PayLoadItem)Items.next();
                int type = item.getType();
                String valueStr = null;
                if (item.UseFile()) {
                    CsvArrayList elems = new CsvArrayList();
                    elems.split(payload);
                    int index = -1;
                    try {
                        index = Integer.parseInt(item.getValue());
                        valueStr = (String)elems.get(index);
                    }
                    catch (Exception e) {
                        throw new ServiceException("MESSAGERESOURCEFACTORY017", "Invalid column num specified.");
                    }
                } else {
                    valueStr = item.getValue();
                }
                switch (type) {
                    case 0: {
                        byte[] tmp = this.mByteConverter.hex2byte(valueStr);
                        msgWrapper.writeByte(tmp[0]);
                        break;
                    }
                    case 2: {
                        byte[] buf = this.mByteConverter.hex2byte(valueStr);
                        msgWrapper.writeBytes(buf);
                        break;
                    }
                    case 3: {
                        Boolean bool = Boolean.valueOf(valueStr);
                        msgWrapper.writeBoolean(bool);
                        break;
                    }
                    case 4: {
                        msgWrapper.writeChar(valueStr.charAt(0));
                        break;
                    }
                    case 5: {
                        msgWrapper.writeShort(Short.parseShort(valueStr));
                        break;
                    }
                    case 7: {
                        msgWrapper.writeInt(Integer.parseInt(valueStr));
                        break;
                    }
                    case 8: {
                        msgWrapper.writeLong(Long.parseLong(valueStr));
                        break;
                    }
                    case 9: {
                        msgWrapper.writeFloat(Float.parseFloat(valueStr));
                        break;
                    }
                    case 10: {
                        msgWrapper.writeDouble(Double.parseDouble(valueStr));
                        break;
                    }
                    case 11: {
                        msgWrapper.writeUTF(valueStr);
                        break;
                    }
                    case 12: {
                        msgWrapper.writeString(valueStr);
                        break;
                    }
                    case 13: {
                        Object obj = this.createObject(item.getWrappedType(), valueStr);
                        msgWrapper.writeObject(obj);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY017", "PayLoad Setting failed.", e);
        }
    }

    public Message unMarshal(QueueSession session) {
        Object msg = null;
        try {
            msg = this.mMessageType.equals("Bytes") ? session.createBytesMessage() : session.createStreamMessage();
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY020", "PayLoad Setting failed.", e);
        }
        String recordStr = null;
        Properties prop = null;
        if (this.mMessageInput != null) {
            recordStr = this.mMessageInput.getInputString();
            prop = this.mMessageInput.getMessageHeadProp();
            this.mMessageInput.nextLine();
        }
        this.setMessageHeadProperties((Message)msg, prop);
        this.setPayload((Message)msg, recordStr);
        return msg;
    }

    protected void recvPayloadParse(Element elem) {
        NodeList list = elem.getElementsByTagName("payload");
        if (list.getLength() < 1) {
            throw new ServiceException("MESSAGERESOURCEFACTORY011", "Not Found <payload>");
        }
        Element payLoad = (Element)list.item(0);
        NodeList payLoadItems = payLoad.getElementsByTagName("item");
        for (int rCnt = 0; rCnt < payLoadItems.getLength(); ++rCnt) {
            String type = null;
            String wrappedType = null;
            boolean bytesLength = false;
            Element payLoadItem = (Element)payLoadItems.item(rCnt);
            type = MessageResourceUtil.getAttMustBeSpecified(payLoadItem, "type");
            int wrappedTypeCode = -1;
            if (type.equals("Object") && (wrappedTypeCode = this.getWrappedTypeCode(wrappedType = MessageResourceUtil.getAttMustBeSpecified(payLoadItem, "wrappedType"), false)) < 0) {
                throw new ServiceException("MESSAGERESOURCEFACTORY012", "Invalid WrappedType :" + wrappedType);
            }
            int typeCode = this.getReadTypeCode(type, this.mMessageType);
            if (typeCode < 0) {
                throw new ServiceException("MESSAGERESOURCEFACTORY012", "Invalid Type :" + type);
            }
            this.mPayLoadItems.add(new PayLoadItem(typeCode, wrappedTypeCode));
        }
    }

    protected void sendPayloadParse(Element elem, boolean fileSpecifiedFlag) {
        NodeList list = elem.getElementsByTagName("payload");
        if (list.getLength() < 1) {
            throw new ServiceException("MESSAGERESOURCEFACTORY012", "Not Found <payload>");
        }
        Element payLoad = (Element)list.item(0);
        NodeList payLoadItems = payLoad.getElementsByTagName("item");
        for (int rCnt = 0; rCnt < payLoadItems.getLength(); ++rCnt) {
            int typeCode;
            String type = null;
            String wrappedType = null;
            String val = null;
            boolean useFile = false;
            Element payLoadItem = (Element)payLoadItems.item(rCnt);
            type = MessageResourceUtil.getAttMustBeSpecified(payLoadItem, "type");
            int wrappedTypeCode = -1;
            if (type.equals("Object") && (wrappedTypeCode = this.getWrappedTypeCode(wrappedType = MessageResourceUtil.getAttMustBeSpecified(payLoadItem, "wrappedType"), false)) < 0) {
                throw new ServiceException("MESSAGERESOURCEFACTORY012", "Invalid Wrapped Type :" + wrappedType);
            }
            val = MessageResourceUtil.getValueMustbeSpecified(payLoadItem);
            String resourceType = payLoadItem.getAttribute("resourceType");
            if (resourceType.equals("file")) {
                if (fileSpecifiedFlag) {
                    useFile = true;
                } else {
                    throw new ServiceException("MESSAGERESOURCEFACTORY015", "File not specified. But type has file attribute.");
                }
            }
            if ((typeCode = this.getWriteTypeCode(type, this.mMessageType)) < 0) {
                throw new ServiceException("MESSAGERESOURCEFACTORY012", "Invalid Type :" + type);
            }
            this.mPayLoadItems.add(new PayLoadItem(typeCode, wrappedTypeCode, val, useFile));
        }
    }

    private class MessageWrapper {
        Message mMessage;

        public MessageWrapper(Message msg) {
            if (!(msg instanceof BytesMessage) && !(msg instanceof StreamMessage)) {
                throw new ServiceException("MESSAGERESOURCEFACTORY300", "Must be Specified BytesMessage or StreamMessage");
            }
            this.mMessage = msg;
        }

        public byte readByte() throws JMSException {
            byte ret = this.mMessage instanceof BytesMessage ? ((BytesMessage)this.mMessage).readByte() : ((StreamMessage)this.mMessage).readByte();
            return ret;
        }

        public int readUnsignedByte() throws JMSException {
            if (!(this.mMessage instanceof BytesMessage)) {
                throw new ServiceException("MESSAGERESOURCEFACTORY301", "readUnsignedByte Method not defined on StreamMessage");
            }
            int ret = ((BytesMessage)this.mMessage).readUnsignedByte();
            return ret;
        }

        public int readBytes(byte[] value) throws JMSException {
            int ret = this.mMessage instanceof BytesMessage ? ((BytesMessage)this.mMessage).readBytes(value) : ((StreamMessage)this.mMessage).readBytes(value);
            return ret;
        }

        public boolean readBoolean() throws JMSException {
            boolean ret = this.mMessage instanceof BytesMessage ? ((BytesMessage)this.mMessage).readBoolean() : ((StreamMessage)this.mMessage).readBoolean();
            return ret;
        }

        public char readChar() throws JMSException {
            char ret = this.mMessage instanceof BytesMessage ? ((BytesMessage)this.mMessage).readChar() : ((StreamMessage)this.mMessage).readChar();
            return ret;
        }

        public short readShort() throws JMSException {
            short ret = this.mMessage instanceof BytesMessage ? ((BytesMessage)this.mMessage).readShort() : ((StreamMessage)this.mMessage).readShort();
            return ret;
        }

        public int readUnsignedShort() throws JMSException {
            if (!(this.mMessage instanceof BytesMessage)) {
                throw new ServiceException("MESSAGERESOURCEFACTORY300", "readUnsignedShort Method not defined on StreamMessage");
            }
            int ret = ((BytesMessage)this.mMessage).readUnsignedShort();
            return ret;
        }

        public int readInt() throws JMSException {
            int ret = this.mMessage instanceof BytesMessage ? ((BytesMessage)this.mMessage).readInt() : ((StreamMessage)this.mMessage).readInt();
            return ret;
        }

        public long readLong() throws JMSException {
            long ret = this.mMessage instanceof BytesMessage ? ((BytesMessage)this.mMessage).readLong() : ((StreamMessage)this.mMessage).readLong();
            return ret;
        }

        public float readFloat() throws JMSException {
            float ret = this.mMessage instanceof BytesMessage ? ((BytesMessage)this.mMessage).readFloat() : ((StreamMessage)this.mMessage).readFloat();
            return ret;
        }

        public double readDouble() throws JMSException {
            double ret = this.mMessage instanceof BytesMessage ? ((BytesMessage)this.mMessage).readDouble() : ((StreamMessage)this.mMessage).readDouble();
            return ret;
        }

        public String readUTF() throws JMSException {
            if (!(this.mMessage instanceof BytesMessage)) {
                throw new ServiceException("MESSAGERESOURCEFACTORY300", "readUTF Method not defined on StreamMessage");
            }
            String ret = ((BytesMessage)this.mMessage).readUTF();
            return ret;
        }

        public String readString() throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                throw new ServiceException("MESSAGERESOURCEFACTORY300", "readString Method not defined on StreamMessage");
            }
            String ret = ((StreamMessage)this.mMessage).readString();
            return ret;
        }

        public Object readObject() throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                throw new ServiceException("MESSAGERESOURCEFACTORY300", "readString Method not defined on StreamMessage");
            }
            Object ret = ((StreamMessage)this.mMessage).readObject();
            return ret;
        }

        public void writeByte(byte value) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                ((BytesMessage)this.mMessage).writeByte(value);
            } else {
                ((StreamMessage)this.mMessage).writeByte(value);
            }
        }

        public void writeBytes(byte[] value) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                ((BytesMessage)this.mMessage).writeBytes(value);
            } else {
                ((StreamMessage)this.mMessage).writeBytes(value);
            }
        }

        public void writeBoolean(boolean value) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                ((BytesMessage)this.mMessage).writeBoolean(value);
            } else {
                ((StreamMessage)this.mMessage).writeBoolean(value);
            }
        }

        public void writeChar(char value) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                ((BytesMessage)this.mMessage).writeChar(value);
            } else {
                ((StreamMessage)this.mMessage).writeChar(value);
            }
        }

        public void writeShort(short value) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                ((BytesMessage)this.mMessage).writeShort(value);
            } else {
                ((StreamMessage)this.mMessage).writeShort(value);
            }
        }

        public void writeInt(int value) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                ((BytesMessage)this.mMessage).writeInt(value);
            } else {
                ((StreamMessage)this.mMessage).writeInt(value);
            }
        }

        public void writeLong(long value) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                ((BytesMessage)this.mMessage).writeLong(value);
            } else {
                ((StreamMessage)this.mMessage).writeLong(value);
            }
        }

        public void writeFloat(float value) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                ((BytesMessage)this.mMessage).writeFloat(value);
            } else {
                ((StreamMessage)this.mMessage).writeFloat(value);
            }
        }

        public void writeDouble(double value) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                ((BytesMessage)this.mMessage).writeDouble(value);
            } else {
                ((StreamMessage)this.mMessage).writeDouble(value);
            }
        }

        public void writeUTF(String value) throws JMSException {
            if (!(this.mMessage instanceof BytesMessage)) {
                throw new ServiceException("MESSAGERESOURCEFACTORY300", "writeUTF Method not defined on StreamMessage");
            }
            ((BytesMessage)this.mMessage).writeUTF(value);
        }

        public void writeString(String value) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                throw new ServiceException("MESSAGERESOURCEFACTORY300", "writeString Method not defined on BytesMessage");
            }
            ((StreamMessage)this.mMessage).writeString(value);
        }

        public void writeObject(Object obj) throws JMSException {
            if (this.mMessage instanceof BytesMessage) {
                ((BytesMessage)this.mMessage).writeObject(obj);
            } else {
                ((StreamMessage)this.mMessage).writeObject(obj);
            }
        }
    }

    private class PayLoadItem {
        int mType;
        int mWrappedType;
        String mVal;
        boolean mFileRefFlag;

        public PayLoadItem(int type, int wrappedtype) {
            this.mType = type;
            this.mWrappedType = wrappedtype;
            this.mVal = null;
            this.mFileRefFlag = false;
        }

        public PayLoadItem(int type, int inctype, String val, boolean fileRefFlag) {
            this.mType = type;
            this.mWrappedType = inctype;
            this.mVal = val;
            this.mFileRefFlag = fileRefFlag;
        }

        public int getType() {
            return this.mType;
        }

        public int getWrappedType() {
            return this.mWrappedType;
        }

        public String getValue() {
            return this.mVal;
        }

        public boolean UseFile() {
            return this.mFileRefFlag;
        }
    }
}

