/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.log;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.log.SimpleCategoryServiceMBean;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.writer.MessageWriteException;

public class SimpleCategoryService
extends jp.ossc.nimbus.service.writer.SimpleCategoryService
implements SimpleCategoryServiceMBean {
    private static final String SCGRY = "SCGRY";
    private static final String SCGRY0 = "SCGRY0";
    private static final String SCGRY00 = "SCGRY00";
    private static final String SCGRY000 = "SCGRY000";
    private static final String SCGRY0000 = "SCGRY0000";
    private static final String SCGRY00001 = "SCGRY00001";
    private static final String SCGRY00002 = "SCGRY00002";
    private static final String SCGRY00003 = "SCGRY00003";
    private static final String SCGRY00004 = "SCGRY00004";
    private static final String PRIORITY_RANGE_DELIMITER = ":";
    protected String categoryName;
    private Range priorityRange;
    private Map labelMap = new HashMap();

    public void startService() throws Exception {
        super.startService();
        if (this.categoryName == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new ServiceException(SCGRY00004, message.findMessage(SCGRY00004));
        }
        if (this.priorityRange == null) {
            this.priorityRange = new Range(-1, -1);
        }
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String name) {
        this.categoryName = name;
    }

    public boolean isValidPriorityRange(int priority) {
        return this.priorityRange.contains(priority);
    }

    public int getPriorityRangeMin() {
        return this.priorityRange.min;
    }

    public int getPriorityRangeMax() {
        return this.priorityRange.max;
    }

    public void setPriorityRangeValue(int min, int max) throws IllegalArgumentException {
        if (min > max) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new IllegalArgumentException(message.findMessage(SCGRY00002));
        }
        this.priorityRange = new Range(min, max);
    }

    public void setPriorityRange(String range) throws IllegalArgumentException {
        this.priorityRange = this.parseRange(range);
    }

    private Range parseRange(String range) throws IllegalArgumentException {
        MessageRecordFactory message = this.getMessageRecordFactory();
        StringTokenizer tokens = new StringTokenizer(range, PRIORITY_RANGE_DELIMITER);
        if (tokens.countTokens() != 2) {
            throw new IllegalArgumentException(message.findMessage(SCGRY00001));
        }
        String minStr = tokens.nextToken();
        String maxStr = tokens.nextToken();
        int min = 0;
        int max = 0;
        try {
            min = Integer.parseInt(minStr);
            max = Integer.parseInt(maxStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(message.findMessage(SCGRY00001));
        }
        if (min > max) {
            throw new IllegalArgumentException(message.findMessage(SCGRY00002));
        }
        return new Range(min, max);
    }

    public String getLabel(int priority) {
        Iterator ranges = this.labelMap.keySet().iterator();
        while (ranges.hasNext()) {
            Range range = (Range)ranges.next();
            if (!range.contains(priority)) continue;
            return (String)this.labelMap.get(range);
        }
        return null;
    }

    public void setLabels(Properties labels) throws IllegalArgumentException {
        Iterator<Object> ranges = labels.keySet().iterator();
        while (ranges.hasNext()) {
            String rangeStr = (String)ranges.next();
            Range range = this.parseRange(rangeStr);
            if (this.labelMap.containsKey(new Integer(range.min)) || this.labelMap.containsKey(new Integer(range.max))) {
                MessageRecordFactory message = this.getMessageRecordFactory();
                throw new IllegalArgumentException(message.findMessage(SCGRY00003));
            }
            this.labelMap.put(range, labels.get(rangeStr));
        }
    }

    public void setLabel(int min, int max, String label) throws IllegalArgumentException {
        if (min > max) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new IllegalArgumentException(message.findMessage(SCGRY00002));
        }
        Range range = new Range(min, max);
        this.labelMap.put(range, label);
    }

    public void write(int priority, Map elements) throws MessageWriteException {
        if (this.isValidPriorityRange(priority)) {
            super.write(elements);
        }
    }

    private class Range
    implements Comparable {
        private final int min;
        private final int max;

        public Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public boolean contains(int val) {
            return this.min <= val && val <= this.max;
        }

        public boolean contains(Range range) {
            return this.min <= range.min && range.max <= this.max;
        }

        public boolean overlaps(Range range) {
            return this.contains(range.min) || this.contains(range.max);
        }

        public int compareTo(Object o) {
            if (o == this) {
                return 0;
            }
            if (o instanceof Range) {
                Range comp = (Range)o;
                if (comp.min == this.min) {
                    if (comp.max == this.max) {
                        return 0;
                    }
                    if (comp.max > this.max) {
                        return -1;
                    }
                    return 1;
                }
                if (comp.min > this.min) {
                    return -1;
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Range) {
                Range comp = (Range)o;
                return comp.min == this.min && comp.max == this.max;
            }
            return false;
        }

        public int hashCode() {
            return this.min + this.max;
        }
    }
}

