/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.util.StringOperator;

public class CashedClassLoader {
    protected URLClassLoader mClassLoader = null;
    protected Hashtable mClassHash;
    protected URL[] mUrls;
    protected ClassLoader mParent;
    private static final String C_JAR_EXTEND = ".JAR";
    private static final String C_BK_SRASH = "\\";
    private static final String C_SRASH = "/";
    private static final String C_DOT = ".";
    private static final String C_CLASS_EXT = ".class";

    public CashedClassLoader(URL[] urls, ClassLoader parent) {
        this.mClassLoader = new URLClassLoader(urls, parent);
        this.mUrls = urls;
        this.mParent = parent;
        this.mClassHash = new Hashtable();
        this.refresh();
    }

    protected void refresh() {
        this.mClassHash.clear();
        for (int cnt = 0; cnt < this.mUrls.length; ++cnt) {
            URL item = this.mUrls[cnt];
            String upper = item.getFile().toUpperCase();
            if (upper.endsWith(C_JAR_EXTEND)) {
                this.setupJarPropList(item);
                continue;
            }
            this.setupDirPropList(item);
        }
    }

    protected void setupJarPropList(URL item) {
        JarFile jar;
        String dirPath = StringOperator.replaceString(item.getFile(), C_BK_SRASH, C_SRASH);
        try {
            jar = new JarFile(dirPath);
        }
        catch (IOException e) {
            throw new ServiceException("CASHCLASSLODER001", "IOException filename = " + dirPath, e);
        }
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            String name = entry.getName();
            if (!name.endsWith(C_CLASS_EXT)) continue;
            name = StringOperator.replaceString(name, C_SRASH, C_DOT);
            name = name.substring(0, name.length() - C_CLASS_EXT.length());
            Class cls = null;
            try {
                cls = this.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException("CASHCLASSLODER002", "ClassNotFoundException clsename = " + name, e);
            }
            this.mClassHash.put(name, cls);
        }
    }

    protected void setupDirPropList(URL item) {
        String dirPath = StringOperator.replaceString(item.getFile(), C_BK_SRASH, C_SRASH);
        if (!item.getFile().endsWith(C_SRASH)) {
            dirPath = dirPath + C_SRASH;
        }
        RecurciveSearchFile file = new RecurciveSearchFile(dirPath);
        ExtentionFileFilter filter = new ExtentionFileFilter(C_CLASS_EXT, true);
        File[] list = file.listAllTreeFiles(filter);
        for (int cnt = 0; cnt < list.length; ++cnt) {
            String path = list[cnt].getAbsolutePath();
            int pos = item.getFile().length() - 1;
            path = path.substring(pos, path.length() - C_CLASS_EXT.length());
            path = StringOperator.replaceString(path, C_SRASH, C_DOT);
            Class cls = null;
            try {
                cls = this.loadClass(path);
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException("CASHCLASSLODER003", "ClassNotFoundException clsename = " + path, e);
            }
            this.mClassHash.put(path, cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class loadClass(String clsName) throws ClassNotFoundException {
        Class<?> cl = null;
        Hashtable hashtable = this.mClassHash;
        synchronized (hashtable) {
            cl = (Class<?>)this.mClassHash.get(clsName);
            if (cl == null) {
                cl = this.mClassLoader.loadClass(clsName);
                if (cl == null) {
                    throw new ClassNotFoundException(clsName);
                }
                this.mClassHash.put(clsName, cl);
            }
        }
        return cl;
    }

    public Hashtable getCashedClass() {
        return this.mClassHash;
    }
}

