/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.CSVJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.ServletRequestCSVJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class ServletRequestCSVJournalEditorService
extends CSVJournalEditorServiceBase
implements ServletRequestCSVJournalEditorServiceMBean,
Serializable {
    private static final String ATTRIBUTE_VALUE_SEPARATOR = "=";
    private static final String ATTRIBUTE_SEPARATOR = ",";
    private static final String PARAMETER_VALUE_SEPARATOR = "=";
    private static final String PARAMETER_SEPARATOR = ",";
    private static final String OPEN_BRACKET = "( ";
    private static final String CLOSE_BRACKET = " )";
    private static final String PORT_SEPARATOR = ":";
    private static final String DEFAULT_SECRET_STRING = "******";
    private String secretString = "******";
    private String[] secretAttributes;
    protected Set secretAttributeSet;
    private String[] enabledAttributes;
    protected Set enabledAttributeSet;
    private String[] secretParameters;
    protected Set secretParameterSet;
    private String[] enabledParameters;
    protected Set enabledParameterSet;
    private final Map outputElements = new HashMap();
    protected String[] outputElementKeys = new String[]{"SENT_SERVER", "RECEIVED_SERVER", "HOST", "PROTOCOL", "SCHEME", "LOCALE", "CONTENT_TYPE", "CONTENT_LENGTH", "CHARACTER_ENCODING", "ATTRIBUTES", "PARAMETERS"};

    public ServletRequestCSVJournalEditorService() {
        this.defineElements();
    }

    protected void defineElements() {
        this.defineElementEditor("SENT_SERVER", new ElementEditor(){

            protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeSentServerFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("RECEIVED_SERVER", new ElementEditor(){

            protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeReceivedServerFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("HOST", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeHostFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("PROTOCOL", new ElementEditor(){

            protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeProtocolFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("SCHEME", new ElementEditor(){

            protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeSchemeFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("LOCALE", new ElementEditor(){

            protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeLocaleFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("CONTENT_TYPE", new ElementEditor(){

            protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeContentTypeFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("CONTENT_LENGTH", new ElementEditor(){

            protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeContentLengthFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("CHARACTER_ENCODING", new ElementEditor(){

            protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeCharacterEncodingFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("ATTRIBUTES", new ElementEditor(){

            protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeAttributesFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("PARAMETERS", new ElementEditor(){

            protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
                return ServletRequestCSVJournalEditorService.this.makeParametersFormat(finder, key, request, buf);
            }
        });
    }

    protected void defineElementEditor(String key, ElementEditor editor) {
        this.outputElements.put(key, editor);
    }

    protected JournalEditor findElementEditor(String key) {
        return (JournalEditor)this.outputElements.get(key);
    }

    public void setOutputElementKeys(String[] keys) throws IllegalArgumentException {
        if (keys != null && keys.length != 0) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.outputElements.containsKey(key)) continue;
                throw new IllegalArgumentException(key + " is undefined.");
            }
            this.outputElementKeys = keys;
        }
    }

    public String[] getOutputElementKeys() {
        return this.outputElementKeys;
    }

    public void setSecretString(String str) {
        this.secretString = str;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public void setSecretAttributes(String[] names) {
        this.secretAttributes = names;
    }

    public String[] getSecretAttributes() {
        return this.secretAttributes;
    }

    public void setEnabledAttributes(String[] names) {
        this.enabledAttributes = names;
    }

    public String[] getEnabledAttributes() {
        return this.enabledAttributes;
    }

    public void setSecretParameters(String[] names) {
        this.secretParameters = names;
    }

    public String[] getSecretParameters() {
        return this.secretParameters;
    }

    public void setEnabledParameters(String[] names) {
        this.enabledParameters = names;
    }

    public String[] getEnabledParameters() {
        return this.enabledParameters;
    }

    public void createService() {
        this.secretAttributeSet = new HashSet();
        this.enabledAttributeSet = new HashSet();
        this.secretParameterSet = new HashSet();
        this.enabledParameterSet = new HashSet();
    }

    public void startService() {
        int i;
        if (this.secretAttributes != null) {
            for (i = 0; i < this.secretAttributes.length; ++i) {
                this.secretAttributeSet.add(this.secretAttributes[i]);
            }
        }
        if (this.enabledAttributes != null) {
            for (i = 0; i < this.enabledAttributes.length; ++i) {
                this.enabledAttributeSet.add(this.enabledAttributes[i]);
            }
        }
        if (this.secretParameters != null) {
            for (i = 0; i < this.secretParameters.length; ++i) {
                this.secretParameterSet.add(this.secretParameters[i]);
            }
        }
        if (this.enabledParameters != null) {
            for (i = 0; i < this.enabledParameters.length; ++i) {
                this.enabledParameterSet.add(this.enabledParameters[i]);
            }
        }
    }

    public void stopService() {
        this.secretAttributeSet.clear();
        this.enabledAttributeSet.clear();
        this.secretParameterSet.clear();
        this.enabledParameterSet.clear();
    }

    public void destroyService() {
        this.secretAttributeSet = null;
        this.enabledAttributeSet = null;
        this.secretParameterSet = null;
        this.enabledParameterSet = null;
    }

    protected void processCSV(EditorFinder finder, Object key, Object value) {
        for (int i = 0; i < this.outputElementKeys.length; ++i) {
            JournalEditor editor = this.findElementEditor(this.outputElementKeys[i]);
            this.addElement(editor.toObject(finder, key, value));
        }
    }

    protected StringBuffer makeSentServerFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        buf.append(request.getRemoteAddr());
        try {
            int port = request.getRemotePort();
            buf.append(PORT_SEPARATOR);
            buf.append(port);
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        buf.append(OPEN_BRACKET).append(request.getRemoteHost()).append(CLOSE_BRACKET);
        return buf;
    }

    protected StringBuffer makeReceivedServerFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        try {
            String localAddr = request.getLocalAddr();
            buf.append(localAddr);
            int localPort = request.getLocalPort();
            buf.append(PORT_SEPARATOR);
            buf.append(localPort);
            String localName = request.getLocalName();
            buf.append(OPEN_BRACKET).append(localName).append(CLOSE_BRACKET);
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        return buf;
    }

    protected StringBuffer makeHostFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        buf.append(request.getServerName());
        buf.append(PORT_SEPARATOR);
        buf.append(request.getServerPort());
        return buf;
    }

    protected StringBuffer makeProtocolFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        return buf.append(request.getProtocol());
    }

    protected StringBuffer makeSchemeFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        return buf.append(request.getScheme());
    }

    protected StringBuffer makeAttributesFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        Enumeration attrNames = request.getAttributeNames();
        if (!attrNames.hasMoreElements()) {
            buf.append("null");
            return buf;
        }
        while (attrNames.hasMoreElements()) {
            String name = (String)attrNames.nextElement();
            if (!this.enabledAttributeSet.isEmpty() && !this.enabledAttributeSet.contains(name)) continue;
            buf.append(name);
            buf.append("=");
            if (this.secretAttributeSet.contains(name)) {
                buf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, request.getAttribute(name), buf);
            }
            if (!attrNames.hasMoreElements()) continue;
            buf.append(",");
        }
        return buf;
    }

    protected StringBuffer makeParametersFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        Enumeration paramNames = request.getParameterNames();
        if (!paramNames.hasMoreElements()) {
            buf.append("null");
            return buf;
        }
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (!this.enabledParameterSet.isEmpty() && !this.enabledParameterSet.contains(name)) continue;
            buf.append(name);
            buf.append("=");
            if (this.secretParameterSet.contains(name)) {
                buf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, request.getParameterValues(name), buf);
            }
            if (!paramNames.hasMoreElements()) continue;
            buf.append(",");
        }
        return buf;
    }

    protected StringBuffer makeLocaleFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        this.makeObjectFormat(finder, null, request.getLocales(), buf);
        return buf;
    }

    protected StringBuffer makeCharacterEncodingFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        return buf.append(request.getCharacterEncoding());
    }

    protected StringBuffer makeContentLengthFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        return buf.append(request.getContentLength());
    }

    protected StringBuffer makeContentTypeFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        return buf.append(request.getContentType());
    }

    protected abstract class ElementEditor
    extends ImmutableJournalEditorServiceBase
    implements Serializable {
        protected ElementEditor() {
        }

        public String toString(EditorFinder finder, Object key, Object value) {
            StringBuffer buf = new StringBuffer(super.toString(finder, key, value));
            return this.toString(finder, key, (ServletRequest)value, buf).toString();
        }

        protected abstract StringBuffer toString(EditorFinder var1, Object var2, ServletRequest var3, StringBuffer var4);
    }
}

