/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ioccall;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.UnitOfWork;
import jp.ossc.nimbus.ioc.ejb.command.SLSBCommandRemote;
import jp.ossc.nimbus.ioc.ejb.facade.SLSBFacadeRemote;
import jp.ossc.nimbus.ioc.ejb.unitofwork.SLSBUnitOfWorkRemote;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.ejb.EJBFactory;
import jp.ossc.nimbus.service.ioccall.DefaultFacadeCallServiceMBean;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;
import jp.ossc.nimbus.service.ioccall.UnsyncRequest;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.jmsqueue.QueueTransanctionResource;

public class DefaultFacadeCallService
extends ServiceBase
implements DefaultFacadeCallServiceMBean,
FacadeCaller {
    private ServiceName mEJBFactoryServiceName;
    private EJBFactory mEjbFactory;
    private String facadeEjbName = "";
    private ServiceName mUnitOfWorkEJBFactoryServiceName;
    private EJBFactory mUnitOfWorkEjbFactory;
    private String unitOfWorkEjbName = "";
    private ServiceName mCommandEJBFactoryServiceName;
    private EJBFactory mCommandEjbFactory;
    private String commandEjbName = "";
    private ServiceName queueServiceName;
    private Queue requestQueue;
    private ServiceName mJndiFinderServiceName;
    private JndiFinder mJndiFinder;
    private String mQueueName;
    private ServiceName mResourceFactoryServiceName;
    private ResourceFactory mResourceFactory;
    private String deliveryModeStr = "PERSISTENT";
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private ServiceName threadContextServiceName;
    private String[] threadContextKeys;

    public void setEjbFactoryServieName(ServiceName name) {
        this.mEJBFactoryServiceName = name;
    }

    public ServiceName getEjbFactoryServieName() {
        return this.mEJBFactoryServiceName;
    }

    public void setFacadeEjbName(String name) {
        this.facadeEjbName = name;
    }

    public String getFacadeEjbName() {
        return this.facadeEjbName;
    }

    public void setUnitOfWorkEjbFactoryServieName(ServiceName name) {
        this.mUnitOfWorkEJBFactoryServiceName = name;
    }

    public ServiceName getUnitOfWorkEjbFactoryServieName() {
        return this.mUnitOfWorkEJBFactoryServiceName;
    }

    public void setUnitOfWorkEjbName(String name) {
        this.unitOfWorkEjbName = name;
    }

    public String getUnitOfWorkEjbName() {
        return this.unitOfWorkEjbName;
    }

    public void setCommandEjbFactoryServieName(ServiceName name) {
        this.mCommandEJBFactoryServiceName = name;
    }

    public ServiceName getCommandEjbFactoryServieName() {
        return this.mCommandEJBFactoryServiceName;
    }

    public void setCommandEjbName(String name) {
        this.commandEjbName = name;
    }

    public String getCommandEjbName() {
        return this.commandEjbName;
    }

    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    public void setQueueFinderServiceName(ServiceName name) {
        this.mJndiFinderServiceName = name;
    }

    public ServiceName getQueueFinderServiceName() {
        return this.mJndiFinderServiceName;
    }

    public void setQueueName(String queueName) {
        this.mQueueName = queueName;
    }

    public String getQueueName() {
        return this.mQueueName;
    }

    public void setQueueSessionFactoryServiceName(ServiceName name) {
        this.mResourceFactoryServiceName = name;
    }

    public ServiceName getQueueSessionFactoryServiceName() {
        return this.mResourceFactoryServiceName;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setThreadContextKeys(String[] keys) {
        this.threadContextKeys = keys;
    }

    public String[] getThreadContextKeys() {
        return this.threadContextKeys;
    }

    public void setDeliveryMode(String mode) {
        if ("PERSISTENT".equals(mode)) {
            this.deliveryMode = 2;
        } else if ("NON_PERSISTENT".equals(mode)) {
            this.deliveryMode = 1;
        } else {
            throw new IllegalArgumentException(mode);
        }
        this.deliveryModeStr = mode;
    }

    public String getDeliveryMode() {
        return this.deliveryModeStr;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setTimeToLive(long millis) {
        this.timeToLive = millis;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void startService() throws Exception {
        if (this.mEJBFactoryServiceName != null) {
            this.mEjbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.mEJBFactoryServiceName);
        }
        if (this.mUnitOfWorkEJBFactoryServiceName != null) {
            this.mUnitOfWorkEjbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.mUnitOfWorkEJBFactoryServiceName);
        }
        if (this.mCommandEJBFactoryServiceName != null) {
            this.mCommandEjbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.mCommandEJBFactoryServiceName);
        }
        if (this.queueServiceName != null) {
            this.requestQueue = (Queue)ServiceManagerFactory.getServiceObject(this.queueServiceName);
        }
        if (this.mResourceFactoryServiceName != null) {
            this.mResourceFactory = (ResourceFactory)ServiceManagerFactory.getServiceObject(this.mResourceFactoryServiceName);
        }
        if (this.mJndiFinderServiceName != null) {
            this.mJndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.mJndiFinderServiceName);
        }
        if (this.mEjbFactory == null && this.mUnitOfWorkEjbFactory == null && this.mCommandEjbFactory == null && this.requestQueue == null && (this.mResourceFactory == null || this.mJndiFinder == null)) {
            throw new ServiceException("DefaultFacadeCallService030", "Effective service is not found. ServiceName may not be defined.");
        }
    }

    public void setEJBFactory(EJBFactory ejbFactory) {
        this.mEjbFactory = ejbFactory;
    }

    public void setUnitOfWorkEjbFactory(EJBFactory unitOfWorkEjbFactory) {
        this.mUnitOfWorkEjbFactory = unitOfWorkEjbFactory;
    }

    public void setCommandEJBFactory(EJBFactory commandEjbFactory) {
        this.mCommandEjbFactory = commandEjbFactory;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.mJndiFinder = jndiFinder;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.mResourceFactory = resourceFactory;
    }

    public Command syncCommandCall(Command value) {
        if (this.mCommandEjbFactory == null) {
            throw new UnsupportedOperationException();
        }
        SLSBCommandRemote remoteObj = null;
        try {
            remoteObj = (SLSBCommandRemote)this.mCommandEjbFactory.get(this.commandEjbName);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService001", "NamingException", e);
        }
        catch (CreateException e) {
            throw new ServiceException("DefaultFacadeCallService002", "CreateException", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("DefaultFacadeCallService003", "NoSuchMethodException", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("DefaultFacadeCallService004", "IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("DefaultFacadeCallService005", "InvocationTargetException", e);
        }
        Command ret = null;
        try {
            ret = remoteObj.invokeCommand(value);
        }
        catch (RemoteException e1) {
            throw new ServiceException("DefaultFacadeCallService010", "RemoteException", e1.detail);
        }
        return ret;
    }

    public UnitOfWork syncUnitOfWorkCall(UnitOfWork value) {
        if (this.mUnitOfWorkEjbFactory == null) {
            throw new UnsupportedOperationException();
        }
        SLSBUnitOfWorkRemote remoteObj = null;
        try {
            remoteObj = (SLSBUnitOfWorkRemote)this.mUnitOfWorkEjbFactory.get(this.unitOfWorkEjbName);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService001", "NamingException", e);
        }
        catch (CreateException e) {
            throw new ServiceException("DefaultFacadeCallService002", "CreateException", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("DefaultFacadeCallService003", "NoSuchMethodException", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("DefaultFacadeCallService004", "IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("DefaultFacadeCallService005", "InvocationTargetException", e);
        }
        UnitOfWork ret = null;
        try {
            ret = remoteObj.invokeUnitOfWork(value);
        }
        catch (RemoteException e1) {
            throw new ServiceException("DefaultFacadeCallService010", "RemoteException", e1.detail);
        }
        return ret;
    }

    public FacadeValue syncFacadeCall(FacadeValue value) {
        if (this.mEjbFactory == null) {
            throw new UnsupportedOperationException();
        }
        SLSBFacadeRemote remoteObj = null;
        try {
            remoteObj = (SLSBFacadeRemote)this.mEjbFactory.get(this.facadeEjbName);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService001", "NamingException", e);
        }
        catch (CreateException e) {
            throw new ServiceException("DefaultFacadeCallService002", "CreateException", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("DefaultFacadeCallService003", "NoSuchMethodException", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("DefaultFacadeCallService004", "IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("DefaultFacadeCallService005", "InvocationTargetException", e);
        }
        this.setHeaderFromThreadContext(value);
        FacadeValue ret = null;
        try {
            ret = remoteObj.invokeFacade(value);
        }
        catch (RemoteException e1) {
            throw new ServiceException("DefaultFacadeCallService010", "RemoteException", e1.detail);
        }
        return ret;
    }

    protected void setHeaderFromThreadContext(FacadeValue value) {
        block4: {
            if (this.threadContextServiceName == null) break block4;
            Context context = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
            if (this.threadContextKeys == null) {
                Iterator keys = context.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    value.putHeader(key, context.get(key));
                }
            } else {
                for (int i = 0; i < this.threadContextKeys.length; ++i) {
                    String key = this.threadContextKeys[i];
                    value.putHeader(key, context.get(key));
                }
            }
        }
    }

    public FacadeValue[] syncParallelFacadeCall(FacadeValue[] values) {
        return this.syncParallelFacadeCall(values, 0L);
    }

    public FacadeValue[] syncParallelFacadeCall(FacadeValue[] values, long timeout) {
        if ((this.mResourceFactory == null || this.mJndiFinder == null) && this.requestQueue == null) {
            throw new UnsupportedOperationException();
        }
        if (this.mResourceFactory != null && this.mJndiFinder != null) {
            return this.syncParallelFacadeCallByJMS(values, timeout);
        }
        return this.syncParallelFacadeCallByQueue(values, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected FacadeValue[] syncParallelFacadeCallByJMS(FacadeValue[] values, long timeout) {
        FacadeValue[] facadeValueArray;
        QueueSender qsender;
        QueueTransanctionResource res;
        block33: {
            if (this.mResourceFactory == null || this.mJndiFinder == null) {
                throw new UnsupportedOperationException();
            }
            res = null;
            try {
                res = (QueueTransanctionResource)this.mResourceFactory.makeResource(null);
                QueueConnection connection = res.getConnectionObject();
                connection.start();
            }
            catch (Exception e) {
                throw new ServiceException("DefaultFacadeCallService021", "Exception", e);
            }
            QueueSession qs = (QueueSession)res.getObject();
            ObjectMessage msg = null;
            qsender = null;
            javax.jms.Queue q = null;
            q = this.mQueueName == null ? (javax.jms.Queue)this.mJndiFinder.lookup() : (javax.jms.Queue)this.mJndiFinder.lookup(this.mQueueName);
            qsender = qs.createSender(q);
            TemporaryQueue[] replyQueues = new TemporaryQueue[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.setHeaderFromThreadContext(values[i]);
                replyQueues[i] = qs.createTemporaryQueue();
                msg = qs.createObjectMessage();
                msg.setJMSReplyTo((Destination)replyQueues[i]);
                msg.setObject((Serializable)values[i]);
                qsender.send((Message)msg, this.deliveryMode, this.priority, this.timeToLive);
            }
            try {
                qsender.close();
                qsender = null;
            }
            catch (JMSException e) {
                // empty catch block
            }
            long procTime = 0L;
            FacadeValue[] result = new FacadeValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                block32: {
                    JMSException e2;
                    block31: {
                        Object var22_23;
                        QueueReceiver receiver = null;
                        try {
                            receiver = qs.createReceiver((javax.jms.Queue)replyQueues[i]);
                            long start = System.currentTimeMillis();
                            long curTimeout = timeout - procTime;
                            if (curTimeout < 0L) {
                                curTimeout = 1L;
                            }
                            ObjectMessage replyMessage = (ObjectMessage)receiver.receive(curTimeout);
                            procTime += System.currentTimeMillis() - start;
                            if (replyMessage != null) {
                                Serializable ret = replyMessage.getObject();
                                if (ret instanceof RuntimeException) {
                                    throw (RuntimeException)ret;
                                }
                                result[i] = (FacadeValue)ret;
                            }
                            var22_23 = null;
                            if (receiver == null) break block31;
                        }
                        catch (Throwable throwable) {
                            var22_23 = null;
                            if (receiver != null) {
                                try {
                                    receiver.close();
                                }
                                catch (JMSException e2) {
                                    // empty catch block
                                }
                            }
                            try {
                                replyQueues[i].delete();
                            }
                            catch (JMSException e2) {
                                // empty catch block
                            }
                            replyQueues[i] = null;
                            throw throwable;
                        }
                        try {
                            receiver.close();
                        }
                        catch (JMSException e2) {
                            // empty catch block
                        }
                    }
                    try {
                        replyQueues[i].delete();
                        break block32;
                    }
                    catch (JMSException e2) {
                        // empty catch block
                    }
                    {
                    }
                }
                replyQueues[i] = null;
            }
            facadeValueArray = result;
            Object var25_26 = null;
            if (qsender == null) break block33;
            try {
                qsender.close();
                qsender = null;
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        try {
            res.close();
        }
        catch (Exception e1) {
            // empty catch block
        }
        {
            return facadeValueArray;
            catch (JMSException e4) {
                throw new ServiceException("DefaultFacadeCallService022", "JMSException", e4);
            }
            catch (NamingException e) {
                throw new ServiceException("DefaultFacadeCallService023", "NamingException", e);
            }
        }
        catch (Throwable throwable) {
            Object var25_27 = null;
            if (qsender != null) {
                try {
                    qsender.close();
                    qsender = null;
                }
                catch (JMSException e) {
                    // empty catch block
                }
            }
            try {
                res.close();
            }
            catch (Exception e1) {}
            throw throwable;
        }
    }

    protected FacadeValue[] syncParallelFacadeCallByQueue(FacadeValue[] values, long timeout) {
        if (this.requestQueue == null) {
            throw new UnsupportedOperationException();
        }
        DefaultQueueService[] replyQueues = new DefaultQueueService[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.setHeaderFromThreadContext(values[i]);
            try {
                replyQueues[i] = new DefaultQueueService();
                replyQueues[i].create();
                replyQueues[i].start();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.requestQueue.push(new UnsyncRequest(this, values[i], replyQueues[i]));
        }
        long procTime = 0L;
        FacadeValue[] result = new FacadeValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            long start = System.currentTimeMillis();
            long curTimeout = timeout - procTime;
            if (curTimeout < 0L) {
                curTimeout = 1L;
            }
            Object response = replyQueues[i].get(curTimeout);
            procTime += System.currentTimeMillis() - start;
            try {
                replyQueues[i].stop();
                replyQueues[i].destroy();
                replyQueues[i] = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (response instanceof RuntimeException) {
                throw (RuntimeException)response;
            }
            result[i] = (FacadeValue)response;
        }
        return result;
    }

    public void unsyncFacadeCall(FacadeValue value) {
        if ((this.mResourceFactory == null || this.mJndiFinder == null) && this.requestQueue == null) {
            throw new UnsupportedOperationException();
        }
        if (this.mResourceFactory != null && this.mJndiFinder != null) {
            this.unsyncFacadeCallByJMS(value);
        } else {
            this.unsyncFacadeCallByQueue(value);
        }
    }

    protected void unsyncFacadeCallByJMS(FacadeValue value) {
        if (this.mResourceFactory == null || this.mJndiFinder == null) {
            throw new UnsupportedOperationException();
        }
        TransactionResource res = null;
        try {
            res = this.mResourceFactory.makeResource(null);
        }
        catch (Exception e) {
            throw new ServiceException("DefaultFacadeCallService021", "Exception", e);
        }
        this.setHeaderFromThreadContext(value);
        QueueSession qs = (QueueSession)res.getObject();
        ObjectMessage msg = null;
        try {
            msg = qs.createObjectMessage();
            msg.setObject((Serializable)value);
            javax.jms.Queue q = null;
            q = this.mQueueName == null ? (javax.jms.Queue)this.mJndiFinder.lookup() : (javax.jms.Queue)this.mJndiFinder.lookup(this.mQueueName);
            QueueSender qsender = null;
            qsender = qs.createSender(q);
            qsender.send((Message)msg, this.deliveryMode, this.priority, this.timeToLive);
            qsender.close();
        }
        catch (JMSException e4) {
            throw new ServiceException("DefaultFacadeCallService022", "JMSException", e4);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService023", "NamingException", e);
        }
        finally {
            try {
                res.close();
            }
            catch (Exception e1) {}
        }
    }

    protected void unsyncFacadeCallByQueue(FacadeValue value) {
        if (this.requestQueue == null) {
            throw new UnsupportedOperationException();
        }
        this.setHeaderFromThreadContext(value);
        this.requestQueue.push(new UnsyncRequest(this, value));
    }

    public void unsyncFacadeCall(FacadeValue[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.unsyncFacadeCall(values[i]);
        }
    }
}

