/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.graph.TickUnitAdjustCommonDivisorMap;
import jp.ossc.nimbus.service.graph.TickUnitAdjustCommonDivisorMapServiceMBean;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class TickUnitAdjustCommonDivisorMapService
extends ServiceBase
implements TickUnitAdjustCommonDivisorMapServiceMBean,
TickUnitAdjustCommonDivisorMap {
    private String[] commonDivisorMaps;
    private Map commonDivisorMap;

    public void setCommonDivisorMap(String[] map) {
        this.commonDivisorMaps = map;
    }

    public String[] getCommonDivisorMap() {
        return this.commonDivisorMaps;
    }

    public void startService() throws Exception {
        super.startService();
        if (this.commonDivisorMaps != null && this.commonDivisorMaps.length != 0) {
            this.commonDivisorMap = new LinkedHashMap();
            for (int i = 0; i < this.commonDivisorMaps.length; ++i) {
                int index = this.commonDivisorMaps[i].lastIndexOf(61);
                if (index == -1 || index == this.commonDivisorMaps[i].length() - 1) {
                    throw new IllegalArgumentException(this.commonDivisorMaps[i]);
                }
                Condition cond = new Condition(this.commonDivisorMaps[i].substring(0, index));
                double val = Double.NaN;
                try {
                    val = Double.parseDouble(this.commonDivisorMaps[i].substring(index + 1).trim());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(this.commonDivisorMaps[i]);
                }
                this.commonDivisorMap.put(cond, new Double(val));
            }
        }
    }

    public double getCommonDivisor(double val) {
        if (this.commonDivisorMap == null) {
            return Double.NaN;
        }
        Iterator conds = this.commonDivisorMap.keySet().iterator();
        while (conds.hasNext()) {
            Condition cond = (Condition)conds.next();
            try {
                if (!cond.evaluate(new Double(val))) continue;
                Double ret = (Double)this.commonDivisorMap.get(cond);
                if (ret == null) {
                    return Double.NaN;
                }
                return ret;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Double.NaN;
    }

    private class Condition
    implements Serializable {
        public Expression expression;

        Condition(String cond) throws Exception {
            this.expression = ExpressionFactory.createExpression((String)cond);
            this.evaluate(new Double(0.0));
        }

        public boolean evaluate(Double val) throws Exception {
            JexlContext jexlContext = JexlHelper.createContext();
            jexlContext.getVars().put("VALUE", val);
            Object exp = this.expression.evaluate(jexlContext);
            if (exp instanceof Boolean) {
                return (Boolean)exp;
            }
            throw new IllegalArgumentException(this.expression.getExpression());
        }
    }
}

