/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import jp.ossc.nimbus.service.graph.AbstractTickUnitAdjusterService;
import jp.ossc.nimbus.service.graph.DateAxisTickUnitAdjusterServiceMBean;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.ValueAxis;

public class DateAxisTickUnitAdjusterService
extends AbstractTickUnitAdjusterService
implements DateAxisTickUnitAdjusterServiceMBean {
    private DateFormat format;

    protected void adjust(ValueAxis axis) {
        if (!(axis instanceof DateAxis)) {
            throw new IllegalArgumentException("axis is not DateAxis.");
        }
        DateAxis dateAxis = (DateAxis)axis;
        DateTickUnit orgTickUnit = dateAxis.getTickUnit();
        int unit = orgTickUnit.getUnit();
        double length = dateAxis.getRange().getLength();
        switch (unit) {
            case 5: {
                length /= 1000.0;
                break;
            }
            case 4: {
                length /= 60000.0;
                break;
            }
            case 3: {
                length /= 3600000.0;
                break;
            }
            case 2: {
                length /= 8.64E7;
                break;
            }
            case 1: {
                length /= 2.4192E9;
                break;
            }
            case 0: {
                length /= 3.1536E10;
                break;
            }
        }
        double unitCount = length / (double)this.displayGraduationCount;
        unitCount = unitCount <= 0.0 ? 1.0 : this.adjustUnitCountByCommonDivisor(axis, unitCount);
        DateFormat newFormat = null;
        newFormat = this.format != null ? this.format : new SimpleDateFormat();
        int newUnitCount = (int)Math.ceil(unitCount);
        dateAxis.setTickUnit(new DateTickUnit(unit, newUnitCount, newFormat));
        if (this.autoRangeMinimumSizeEnabled) {
            double autoRangeMinimumSize = Double.NaN;
            switch (unit) {
                case 6: {
                    autoRangeMinimumSize = 1.0;
                    break;
                }
                case 5: {
                    autoRangeMinimumSize = 1000.0;
                    break;
                }
                case 4: {
                    autoRangeMinimumSize = 60000.0;
                    break;
                }
                case 3: {
                    autoRangeMinimumSize = 3600000.0;
                    break;
                }
                case 2: {
                    autoRangeMinimumSize = 8.64E7;
                    break;
                }
                case 1: {
                    autoRangeMinimumSize = 2.6784E9;
                    break;
                }
                case 0: {
                    autoRangeMinimumSize = 3.1536E10;
                    break;
                }
            }
            if (!Double.isNaN(autoRangeMinimumSize)) {
                dateAxis.setAutoRangeMinimumSize(autoRangeMinimumSize * 2.0);
            }
        }
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public DateFormat getFormat() {
        return this.format;
    }
}

