/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.debug;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.debug.Debug;
import jp.ossc.nimbus.service.debug.DebugServiceMBean;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.log.Logger;

public class DebugService
extends ServiceBase
implements Debug,
DebugServiceMBean {
    private static final String DEFAULT_SEPARATOR = System.getProperty("line.separator");
    private static final String ERROR_USE_OF_DEBUG_MSG = "write() method shoud be called after using isXXX() debug-level check function.";
    private static final int DEFAULT_NESTED_LEVEL = 2;
    private static final char ATMARK_REPLACE_CHAR = '$';
    static final String ENTRY_STATE_START = "1";
    static ThreadLocal mThreadLocal = new ThreadLocal();
    private int mDebugLevel = 81;
    private int mNestedLevel = 2;
    private ServiceName logServiceName;
    private ServiceName editorFinderServiceName;
    private Logger mLogService;
    private EditorFinder mEditorFinder;
    private String separator = DEFAULT_SEPARATOR;

    public void write(String str, Throwable e) {
        if (!this.isFlagSetted()) {
            throw new ServiceException("Tracer00001", ERROR_USE_OF_DEBUG_MSG);
        }
        this.clearFlag();
        String stackTrace = this.getCallerInfo();
        this.mLogService.write("DEBUG00001", new String[]{stackTrace, str}, e);
    }

    public void write(String str) {
        if (!this.isFlagSetted()) {
            throw new ServiceException("Debug00002", ERROR_USE_OF_DEBUG_MSG);
        }
        this.clearFlag();
        String stackTrace = this.getCallerInfo();
        this.mLogService.write("DEBUG00002", new String[]{stackTrace, str});
    }

    public boolean isDebug() {
        boolean b;
        boolean bl = b = this.mDebugLevel <= 0;
        if (b) {
            this.setFlag();
        }
        return b;
    }

    public boolean isInfo() {
        boolean b;
        boolean bl = b = this.mDebugLevel <= 20;
        if (b) {
            this.setFlag();
        }
        return b;
    }

    public boolean isWarn() {
        boolean b;
        boolean bl = b = this.mDebugLevel <= 40;
        if (b) {
            this.setFlag();
        }
        return b;
    }

    public boolean isError() {
        boolean b;
        boolean bl = b = this.mDebugLevel <= 60;
        if (b) {
            this.setFlag();
        }
        return b;
    }

    public boolean isFatalError() {
        boolean b;
        boolean bl = b = this.mDebugLevel <= 80;
        if (b) {
            this.setFlag();
        }
        return b;
    }

    public void setEditorFinder(EditorFinder editorFinder) {
        this.mEditorFinder = editorFinder;
    }

    public void setLogger(Logger logService) {
        this.mLogService = logService;
    }

    public int getDebugLevel() {
        return this.mDebugLevel;
    }

    public void setDebugLevel(int level) {
        this.mDebugLevel = level;
    }

    public ServiceName getLogServiceName() {
        return this.logServiceName;
    }

    public void setLogServiceName(ServiceName svn) {
        this.logServiceName = svn;
    }

    private void setFlag() {
        mThreadLocal.set(ENTRY_STATE_START);
    }

    private void clearFlag() {
        mThreadLocal.set(null);
    }

    private boolean isFlagSetted() {
        return mThreadLocal.get() != null;
    }

    public void createService() throws Exception {
    }

    public void startService() throws Exception {
        if (this.logServiceName != null) {
            this.mLogService = (Logger)ServiceManagerFactory.getServiceObject(this.logServiceName);
        } else if (this.mLogService == null) {
            throw new IllegalArgumentException("LogServiceName or LogService must not null.");
        }
        if (this.editorFinderServiceName != null) {
            this.mEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.editorFinderServiceName);
        } else if (this.mEditorFinder == null) {
            throw new IllegalArgumentException("EditorFinderServiceName or EditorFinderService must not null.");
        }
    }

    public void stopService() throws Exception {
    }

    public void destroyService() throws Exception {
        this.mLogService = null;
        this.logServiceName = null;
        this.mEditorFinder = null;
        this.editorFinderServiceName = null;
    }

    public void setNestedLevel(int level) {
        this.mNestedLevel = level;
    }

    private String getCallerInfo() {
        String callerClass = null;
        Exception e = new Exception();
        StackTraceElement[] elms = e.getStackTrace();
        if (elms.length < this.mNestedLevel) {
            this.mLogService.write("DEBUG00007", this.mNestedLevel);
        } else {
            StackTraceElement elm = elms[this.mNestedLevel];
            callerClass = elm.toString();
        }
        return callerClass;
    }

    public void dump(Object object) {
        if (!this.isFlagSetted()) {
            throw new ServiceException("Debug00002", ERROR_USE_OF_DEBUG_MSG);
        }
        this.clearFlag();
        String param = this.getParameterString(object);
        String callerInfo = this.getCallerInfo();
        this.mLogService.write("DEBUG00003", new String[]{callerInfo, param});
    }

    public void dump(Object[] objects) {
        if (!this.isFlagSetted()) {
            throw new ServiceException("Debug00003", ERROR_USE_OF_DEBUG_MSG);
        }
        this.clearFlag();
        String param = this.getParameterStrings(objects);
        String callerInfo = this.getCallerInfo();
        this.mLogService.write("DEBUG00004", new String[]{callerInfo, param});
    }

    public void dump(String msg, Object object) {
        if (!this.isFlagSetted()) {
            throw new ServiceException("Debug00004", ERROR_USE_OF_DEBUG_MSG);
        }
        this.clearFlag();
        String param = this.getParameterString(object);
        String callerInfo = this.getCallerInfo();
        this.mLogService.write("DEBUG00005", new String[]{callerInfo, msg, param});
    }

    public void dump(String msg, Object[] objects) {
        if (!this.isFlagSetted()) {
            throw new ServiceException("Debug00005", ERROR_USE_OF_DEBUG_MSG);
        }
        this.clearFlag();
        String param = this.getParameterStrings(objects);
        String callerInfo = this.getCallerInfo();
        this.mLogService.write("DEBUG00006", new String[]{callerInfo, msg, param});
    }

    public void setEditorFinderServiceName(ServiceName name) {
        this.editorFinderServiceName = name;
    }

    public ServiceName getEditorFinderServiceName() {
        return this.editorFinderServiceName;
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public String getSeparator() {
        return this.separator;
    }

    private String getParameterStrings(Object[] params) {
        StringBuffer buff = new StringBuffer();
        if (params == null) {
            buff.append(params);
            return buff.toString();
        }
        for (int i = 0; i < params.length; ++i) {
            buff.append(this.getParameterString(params[i]));
            if (i == params.length - 1) continue;
            buff.append(this.separator);
        }
        return buff.toString();
    }

    private String getParameterString(Object param) {
        if (param != null) {
            JournalEditor editor = this.mEditorFinder.findEditor(param.getClass());
            String str = (String)editor.toObject(this.mEditorFinder, null, param);
            if (str != null) {
                str.replace('@', '$');
            }
            return str;
        }
        return "null";
    }
}

