/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameRef;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ThreadContextInitializeInterceptorServiceMBean;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.sequence.Sequence;

public class ThreadContextInitializeInterceptorService
extends ServletFilterInterceptorService
implements ThreadContextInitializeInterceptorServiceMBean {
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected ServiceName codeMasterFinderServiceName;
    protected CodeMasterFinder codeMasterFinder;
    protected ServiceNameRef[] contextValueServiceNames;
    protected boolean isOutputContextPath = true;
    protected boolean isOutputServletPath = true;
    protected boolean isOutputSessionID = true;
    protected boolean isNewSession = false;
    protected boolean isOutputThreadName = true;
    protected boolean isOutputThreadGroupName = true;

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setCodeMasterFinderServiceName(ServiceName name) {
        this.codeMasterFinderServiceName = name;
    }

    public ServiceName getCodeMasterFinderServiceName() {
        return this.codeMasterFinderServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setContextValueServiceNames(ServiceNameRef[] names) {
        this.contextValueServiceNames = names;
    }

    public ServiceNameRef[] getContextValueServiceNames() {
        return this.contextValueServiceNames;
    }

    public void setOutputContextPath(boolean isOutput) {
        this.isOutputContextPath = isOutput;
    }

    public boolean isOutputContextPath() {
        return this.isOutputContextPath;
    }

    public void setOutputServletPath(boolean isOutput) {
        this.isOutputServletPath = isOutput;
    }

    public boolean isOutputServletPath() {
        return this.isOutputServletPath;
    }

    public void setOutputSessionID(boolean isOutput) {
        this.isOutputSessionID = isOutput;
    }

    public boolean isOutputSessionID() {
        return this.isOutputSessionID;
    }

    public void setOutputThreadName(boolean isOutput) {
        this.isOutputThreadName = isOutput;
    }

    public boolean isOutputThreadName() {
        return this.isOutputThreadName;
    }

    public void setOutputThreadGroupName(boolean isOutput) {
        this.isOutputThreadGroupName = isOutput;
    }

    public boolean isOutputThreadGroupName() {
        return this.isOutputThreadGroupName;
    }

    public void setNewSession(boolean isNew) {
        this.isNewSession = isNew;
    }

    public boolean isNewSession() {
        return this.isNewSession;
    }

    public void startService() throws Exception {
        if (this.threadContextServiceName == null) {
            throw new IllegalArgumentException("threadContextServiceName must be specified.");
        }
        this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.codeMasterFinderServiceName != null) {
            this.codeMasterFinder = (CodeMasterFinder)ServiceManagerFactory.getServiceObject(this.codeMasterFinderServiceName);
        }
    }

    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            ServletRequest request = context.getServletRequest();
            this.threadContext.clear();
            if (this.sequence != null) {
                String requestId = this.sequence.increment();
                this.threadContext.put("REQUEST_ID", requestId);
            }
            if (this.contextValueServiceNames != null) {
                for (int i = 0; i < this.contextValueServiceNames.length; ++i) {
                    this.threadContext.put(this.contextValueServiceNames[i].getReferenceServiceName(), ServiceManagerFactory.getServiceObject(this.contextValueServiceNames[i].getServiceName()));
                }
            }
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpReq = (HttpServletRequest)request;
                if (this.isOutputContextPath) {
                    this.threadContext.put("CONTEXT_PATH", httpReq.getContextPath());
                }
                if (this.isOutputServletPath) {
                    this.threadContext.put("SERVLET_PATH", httpReq.getServletPath());
                }
                HttpSession session = httpReq.getSession(this.isNewSession);
                if (this.isOutputSessionID && session != null) {
                    this.threadContext.put("SESSION_ID", session.getId());
                }
            }
            Thread thread = Thread.currentThread();
            if (this.isOutputThreadName) {
                this.threadContext.put("THREAD_NAME", thread.getName());
            }
            if (this.isOutputThreadGroupName) {
                ThreadGroup threadGroup = thread.getThreadGroup();
                this.threadContext.put("THREAD_GROUP_NAME", threadGroup.getName());
            }
            if (this.codeMasterFinder != null) {
                Map codeMasters = this.codeMasterFinder.getCodeMasters();
                this.threadContext.put("CODE_MASTER", codeMasters);
            }
        }
        return chain.invokeNext(context);
    }
}

