/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MetricsInfo
implements Serializable {
    protected String key;
    protected boolean isCalculateOnlyNormal;
    protected long count;
    protected long lastTime;
    protected long exceptionCount;
    protected long lastExceptionTime;
    protected long errorCount;
    protected long lastErrorTime;
    protected long worstPerformance = Long.MIN_VALUE;
    protected long worstPerformanceTime;
    protected long bestPerformance = Long.MAX_VALUE;
    protected long bestPerformanceTime;
    protected long averagePerformance;

    public MetricsInfo(String key, boolean isCalc) {
        this.key = key;
        this.isCalculateOnlyNormal = isCalc;
    }

    public synchronized void calculate(long performance, boolean isException, boolean isError) {
        this.lastTime = System.currentTimeMillis();
        if (!this.isCalculateOnlyNormal || !isException && !isError) {
            if (this.worstPerformance <= performance) {
                this.worstPerformance = performance;
                this.worstPerformanceTime = this.lastTime;
            }
            if (this.bestPerformance >= performance) {
                this.bestPerformance = performance;
                this.bestPerformanceTime = this.lastTime;
            }
            if (this.isCalculateOnlyNormal) {
                this.averagePerformance = (this.averagePerformance * this.count + performance) / (this.count + 1L);
            } else {
                long totalCount = this.count + this.exceptionCount + this.errorCount;
                this.averagePerformance = (this.averagePerformance * totalCount + performance) / (totalCount + 1L);
            }
        }
        if (isException) {
            ++this.exceptionCount;
            this.lastExceptionTime = this.lastTime;
        } else if (isError) {
            ++this.errorCount;
            this.lastErrorTime = this.lastTime;
        } else {
            ++this.count;
        }
    }

    public String getKey() {
        return this.key;
    }

    public long getTotalCount() {
        return this.count + this.exceptionCount + this.errorCount;
    }

    public long getCount() {
        return this.count;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public long getExceptionCount() {
        return this.exceptionCount;
    }

    public long getLastExceptionTime() {
        return this.lastExceptionTime;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getLastErrorTime() {
        return this.lastErrorTime;
    }

    public long getBestPerformance() {
        return this.bestPerformance;
    }

    public long getBestPerformanceTime() {
        return this.bestPerformanceTime;
    }

    public long getWorstPerformance() {
        return this.worstPerformance;
    }

    public long getWorstPerformanceTime() {
        return this.worstPerformanceTime;
    }

    public long getAveragePerformance() {
        return this.averagePerformance;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");
        buf.append('{');
        buf.append("key=").append(this.key);
        buf.append(", count=").append(this.count);
        buf.append(", exceptionCount=").append(this.exceptionCount);
        buf.append(", errorCount=").append(this.errorCount);
        buf.append(", lastTime=").append(this.lastTime == 0L ? "" : format.format(new Date(this.lastTime)));
        buf.append(", lastExceptionTime=").append(this.lastExceptionTime == 0L ? "" : format.format(new Date(this.lastExceptionTime)));
        buf.append(", lastErrorTime=").append(this.lastErrorTime == 0L ? "" : format.format(new Date(this.lastErrorTime)));
        buf.append(", worstPerformance=").append(this.count == 0L ? 0L : this.worstPerformance).append("[ms]");
        buf.append(", worstPerformanceTime=").append(this.worstPerformanceTime == 0L ? "" : format.format(new Date(this.worstPerformanceTime)));
        buf.append(", bestPerformance=").append(this.count == 0L ? 0L : this.bestPerformance).append("[ms]");
        buf.append(", bestPerformanceTime=").append(this.bestPerformanceTime == 0L ? "" : format.format(new Date(this.bestPerformanceTime)));
        buf.append(", averagePerformance=").append(this.averagePerformance).append("[ms]");
        buf.append('}');
        return buf.toString();
    }
}

