/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.MessageWriter;
import jp.ossc.nimbus.service.writer.OneWriteFileMessageWriterServiceMBean;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.service.writer.WritableRecord;

public class OneWriteFileMessageWriterService
extends ServiceBase
implements OneWriteFileMessageWriterServiceMBean,
MessageWriter {
    private String encoding;
    private String file;
    private boolean isEveryTimeCloseStream = true;
    private FileName fileName;
    private FileOutputStream fos;
    private String filePrefix;
    private String filePostfix;
    private ServiceName contextServiceName;
    private Context context;
    private boolean isOutputKey = true;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void setEveryTimeCloseStream(boolean isClose) {
        this.isEveryTimeCloseStream = isClose;
    }

    public boolean isEveryTimeCloseStream() {
        return this.isEveryTimeCloseStream;
    }

    public void setFilePrefix(String prefix) {
        this.filePrefix = prefix;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePostfix(String postfix) {
        this.filePostfix = postfix;
    }

    public String getFilePostfix() {
        return this.filePostfix;
    }

    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    public void setOutputKey(boolean isOutput) {
        this.isOutputKey = isOutput;
    }

    public boolean isOutputKey() {
        return this.isOutputKey;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void startService() throws Exception {
        if (this.encoding != null) {
            new String().getBytes(this.encoding);
        }
        if (this.file == null || this.file.length() == 0) {
            throw new IllegalArgumentException("file must be specified.");
        }
        File f = new File(this.file);
        if (f.getParentFile() != null && !f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("file is illegal path." + this.file);
        }
        this.fileName = new FileName(this.file, this.filePrefix, this.filePostfix);
        if (!this.isEveryTimeCloseStream) {
            if (!this.fileName.isStatic()) {
                throw new IllegalArgumentException("Dynamic filename!");
            }
            this.fos = new FileOutputStream(this.fileName.toString(null));
        }
        if (this.contextServiceName != null) {
            this.context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
        }
    }

    public void stopService() throws Exception {
        if (this.fos != null) {
            this.fos.close();
            this.fos = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(WritableRecord rec) throws MessageWriteException {
        FileOutputStream tmpFos = null;
        try {
            try {
                tmpFos = this.isEveryTimeCloseStream ? new FileOutputStream(this.fileName.toString(rec)) : this.fos;
                if (this.encoding == null) {
                    tmpFos.write(rec.toString().getBytes());
                } else {
                    tmpFos.write(rec.toString().getBytes(this.encoding));
                }
            }
            catch (IOException e) {
                throw new MessageWriteException(e);
            }
            Object var5_3 = null;
            if (!this.isEveryTimeCloseStream) return;
            if (tmpFos == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!this.isEveryTimeCloseStream) throw throwable;
            if (tmpFos == null) throw throwable;
            try {
                tmpFos.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        tmpFos.close();
        return;
    }

    private class DynamicFileNameElement
    implements FileNameElement,
    Serializable {
        private String elementKey;

        DynamicFileNameElement(String key) {
            this.elementKey = key;
        }

        public String toString(WritableRecord rec) {
            Object val;
            if (rec != null) {
                WritableElement element = null;
                element = OneWriteFileMessageWriterService.this.isOutputKey ? (WritableElement)rec.getElementMap().get(this.elementKey) : (WritableElement)rec.getElementMap().remove(this.elementKey);
                if (element != null) {
                    return ((Object)element).toString();
                }
            }
            if (OneWriteFileMessageWriterService.this.context != null && (val = OneWriteFileMessageWriterService.this.context.get(this.elementKey)) != null) {
                return val.toString();
            }
            return this.elementKey;
        }
    }

    private class StaticFileNameElement
    implements FileNameElement,
    Serializable {
        private String value;

        StaticFileNameElement(String val) {
            this.value = val;
        }

        public String toString(WritableRecord rec) {
            return this.value;
        }
    }

    private static interface FileNameElement {
        public String toString(WritableRecord var1);
    }

    private class FileName
    implements Serializable,
    FileNameElement {
        private List fileNameElements = new ArrayList();
        private boolean isStatic = true;

        FileName(String path, String prefix, String postfix) throws IOException {
            File file = new File(path);
            if (file.getParentFile() != null) {
                String dir = file.getParentFile().getAbsolutePath();
                if (dir.charAt(dir.length() - 1) != '/') {
                    dir = dir + '/';
                }
                this.fileNameElements.add(new StaticFileNameElement(dir));
            }
            this.parse(prefix);
            this.fileNameElements.add(new StaticFileNameElement(file.getName()));
            this.parse(postfix);
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        private void parse(String val) {
            if (val == null || val.length() == 0) {
                return;
            }
            boolean isEscape = false;
            boolean isKey = false;
            StringBuffer buf = new StringBuffer();
            int max = val.length();
            block4: for (int i = 0; i < max; ++i) {
                char c = val.charAt(i);
                switch (c) {
                    case '%': {
                        if (isEscape) {
                            buf.append(c);
                        } else if (isKey) {
                            this.fileNameElements.add(new DynamicFileNameElement(buf.toString()));
                            this.isStatic = false;
                            buf.setLength(0);
                            isKey = false;
                        } else {
                            if (buf.length() != 0) {
                                this.fileNameElements.add(new StaticFileNameElement(buf.toString()));
                                buf.setLength(0);
                            }
                            isKey = true;
                        }
                        isEscape = false;
                        continue block4;
                    }
                    case '\\': {
                        if (isEscape) {
                            buf.append(c);
                            isEscape = false;
                            continue block4;
                        }
                        isEscape = true;
                        continue block4;
                    }
                    default: {
                        buf.append(c);
                        isEscape = false;
                    }
                }
            }
            if (isKey || isEscape) {
                throw new IllegalArgumentException("Illegal format : " + val);
            }
            if (buf.length() != 0) {
                this.fileNameElements.add(new StaticFileNameElement(buf.toString()));
                buf.setLength(0);
            }
        }

        public String toString(WritableRecord rec) {
            StringBuffer buf = new StringBuffer();
            Iterator elements = this.fileNameElements.iterator();
            while (elements.hasNext()) {
                buf.append(((FileNameElement)elements.next()).toString(rec));
            }
            return buf.toString();
        }
    }
}

