/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.service.publish.DefaultPublishContainerFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.DefaultPublishContainerService;
import jp.ossc.nimbus.service.publish.PublishContainer;
import jp.ossc.nimbus.service.publish.PublishContainerFactory;

public class DefaultPublishContainerFactoryService
extends ServiceBase
implements PublishContainerFactory,
DefaultPublishContainerFactoryServiceMBean,
ServiceStateListener {
    private boolean isRegisterContainer;
    private int maxServantNum;
    private Set containers;
    private ServiceName queueServiceName;

    public void setRegisterContainer(boolean isRegistered) {
        this.isRegisterContainer = isRegistered;
    }

    public boolean isRegisterContainer() {
        return this.isRegisterContainer;
    }

    public void setMaxServantNum(int maxServant) {
        this.maxServantNum = maxServant;
    }

    public int getMaxServantNum() {
        return this.maxServantNum;
    }

    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    public void createService() throws Exception {
        this.containers = new HashSet();
    }

    public void startService() throws Exception {
        Iterator itr = this.containers.iterator();
        while (itr.hasNext()) {
            ServiceBase container = (ServiceBase)itr.next();
            container.start();
            container.addServiceStateListener(this);
        }
    }

    public void stopService() throws Exception {
        Iterator itr = this.containers.iterator();
        while (itr.hasNext()) {
            ServiceBase container = (ServiceBase)itr.next();
            container.removeServiceStateListener(this);
            container.stop();
        }
    }

    public void destroyService() throws Exception {
        Iterator itr = this.containers.iterator();
        while (itr.hasNext()) {
            Service container = (Service)itr.next();
            container.destroy();
        }
        this.containers.clear();
        this.containers = null;
    }

    public synchronized PublishContainer createContainer() throws Exception {
        DefaultPublishContainerService container = new DefaultPublishContainerService();
        if (this.isRegisterContainer) {
            container.setServiceManagerName(this.getServiceManagerName());
            container.setServiceName(container.getClass().getName() + this.containers.size());
        } else {
            if (this.getSystemLoggerServiceName() != null) {
                container.setSystemLoggerServiceName(this.getSystemLoggerServiceName());
            }
            if (this.getSystemMessageRecordFactoryServiceName() != null) {
                container.setSystemMessageRecordFactoryServiceName(this.getSystemMessageRecordFactoryServiceName());
            }
        }
        container.create();
        container.setMaxServantNum(this.maxServantNum);
        container.setQueueServiceName(this.queueServiceName);
        container.start();
        container.addServiceStateListener(this);
        this.containers.add(container);
        return container;
    }

    public void stateChanged(ServiceStateChangeEvent e) throws Exception {
        if (this.containers == null) {
            return;
        }
        this.containers.remove(e.getService());
    }

    public boolean isEnabledState(int state) {
        return state == 7;
    }
}

