/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.log;

import java.io.Serializable;
import java.util.List;
import jp.ossc.nimbus.service.log.LogMessageRecord;
import jp.ossc.nimbus.service.message.MessageRecordImpl;
import jp.ossc.nimbus.service.message.MessageRecordOperator;
import jp.ossc.nimbus.service.message.MessageRecordParseException;
import jp.ossc.nimbus.util.CsvArrayList;
import jp.ossc.nimbus.util.StringOperator;

public class LogMessageRecordImpl
extends MessageRecordImpl
implements LogMessageRecord,
MessageRecordOperator,
Serializable {
    protected int mMessagePriority = 0;
    protected CsvArrayList mCategory = null;
    protected boolean isPrintStackTrace = true;
    private static final String C_DFAUTL_CATEGORY = "debug";
    private static final String C_DFAUTL_LOCALE = "default";

    public void rec2Obj(String defString) throws MessageRecordParseException {
        if (!this.mIsInitialized) {
            CsvArrayList parser = new CsvArrayList();
            parser.split(defString, ",");
            if (parser.size() < 2) {
                throw new MessageRecordParseException("Message define error message is " + defString);
            }
            this.mMessageCode = parser.getStr(0);
            this.mMessageHash.put(C_DFAUTL_LOCALE, parser.getStr(1));
            if (parser.size() > 2) {
                this.mMessagePriority = StringOperator.convertInt(parser.getStr(2));
            }
            if (this.mCategory == null) {
                this.mCategory = new CsvArrayList();
            }
            if (parser.size() > 3) {
                this.mCategory.split(parser.getStr(3), ":");
            } else {
                this.mCategory.add(C_DFAUTL_CATEGORY);
            }
            if (parser.size() > 4) {
                this.isPrintStackTrace = Boolean.valueOf(parser.getStr(4));
            }
        }
    }

    public boolean isPrintStackTrace() {
        return this.isPrintStackTrace;
    }

    public int getPriority() {
        return this.mMessagePriority;
    }

    public void setPriority(int priority) {
        this.mMessagePriority = priority;
    }

    public List getCategories() {
        if (this.mCategory == null) {
            this.mCategory = new CsvArrayList();
        }
        return this.mCategory;
    }

    public void setCategories(List categories) {
        if (this.mCategory == null) {
            this.mCategory = new CsvArrayList();
        }
        this.mCategory.clear();
        this.mCategory.addAll(categories);
    }

    public void addCategory(String category) {
        if (this.mCategory == null) {
            this.mCategory = new CsvArrayList();
        }
        if (!this.mCategory.contains(category)) {
            this.mCategory.add(category);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        ret.append(";");
        ret.append(this.mMessagePriority).append(";");
        if (this.mCategory != null) {
            ret.append(this.mCategory.join("#"));
        }
        return ret.toString();
    }
}

