/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.service.journal.editor.HttpServletRequestCSVJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ServletRequestCSVJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpServletRequestCSVJournalEditorService
extends ServletRequestCSVJournalEditorService
implements HttpServletRequestCSVJournalEditorServiceMBean,
Serializable {
    private static final String FROM_COOKIE = "From Cookie";
    private static final String FROM_URL = "From URL";
    private static final String HEADER_VALUE_SEPARATOR = "=";
    private static final String HEADER_SEPARATOR = ",";
    private static final String COOKIE_VALUE_SEPARATOR = "=";
    private static final String COOKIE_SEPARATOR = ",";
    private static final String OPEN_BRACKET = "( ";
    private static final String CLOSE_BRACKET = " )";
    private String[] secretHeaders;
    protected Set secretHeaderSet;
    private String[] enabledHeaders;
    protected Set enabledHeaderSet;
    private String[] secretCookies;
    protected Set secretCookieSet;
    private String[] enabledCookies;
    protected Set enabledCookieSet;
    private static final String[] DEFAULT_OUTPUT_ELEMENT_KEYS = new String[]{"REQUEST_URL", "REQUEST_URI", "SERVLET_PATH", "CONTEXT_PATH", "PATH_INFO", "PATH_TRAN", "QUERY_STRING", "SESSION_ID", "HTTP_METHOD", "AUTH_TYPE", "REMOTE_USER", "USER_PRINCIPAL", "HTTP_HEADER", "COOKIE"};

    public HttpServletRequestCSVJournalEditorService() {
        String[] tmpKeys = new String[DEFAULT_OUTPUT_ELEMENT_KEYS.length + this.outputElementKeys.length];
        System.arraycopy(DEFAULT_OUTPUT_ELEMENT_KEYS, 0, tmpKeys, 0, DEFAULT_OUTPUT_ELEMENT_KEYS.length);
        System.arraycopy(this.outputElementKeys, 0, tmpKeys, DEFAULT_OUTPUT_ELEMENT_KEYS.length, this.outputElementKeys.length);
        this.outputElementKeys = tmpKeys;
    }

    protected void defineElements() {
        super.defineElements();
        this.defineElementEditor("REQUEST_URL", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeRequestURLFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("REQUEST_URI", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeRequestURIFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("SERVLET_PATH", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeServletPathFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("CONTEXT_PATH", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeContextPathFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("PATH_INFO", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makePathInfoFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("PATH_TRAN", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makePathTranslatedFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("QUERY_STRING", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeQueryStringFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("SESSION_ID", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeSessionIDFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("HTTP_METHOD", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeMethodFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("AUTH_TYPE", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeAuthTypeFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("REMOTE_USER", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeRemoteUserFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("USER_PRINCIPAL", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeUserPrincipalFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("HTTP_HEADER", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeHeadersFormat(finder, key, request, buf);
            }
        });
        this.defineElementEditor("COOKIE", new ElementEditor(){

            public StringBuffer toString(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
                return HttpServletRequestCSVJournalEditorService.this.makeCookiesFormat(finder, key, request, buf);
            }
        });
    }

    public void setSecretHeaders(String[] names) {
        this.secretHeaders = names;
    }

    public String[] getSecretHeaders() {
        return this.secretHeaders;
    }

    public void setEnabledHeaders(String[] names) {
        this.enabledHeaders = names;
    }

    public String[] getEnabledHeaders() {
        return this.enabledHeaders;
    }

    public void setSecretCookies(String[] names) {
        this.secretCookies = names;
    }

    public String[] getSecretCookies() {
        return this.secretCookies;
    }

    public void setEnabledCookies(String[] names) {
        this.enabledCookies = names;
    }

    public String[] getEnabledCookies() {
        return this.enabledCookies;
    }

    public void createService() {
        super.createService();
        this.secretHeaderSet = new HashSet();
        this.enabledHeaderSet = new HashSet();
        this.secretCookieSet = new HashSet();
        this.enabledCookieSet = new HashSet();
    }

    public void startService() {
        int i;
        super.startService();
        if (this.secretHeaders != null) {
            for (i = 0; i < this.secretHeaders.length; ++i) {
                this.secretHeaderSet.add(this.secretHeaders[i]);
            }
        }
        if (this.enabledHeaders != null) {
            for (i = 0; i < this.enabledHeaders.length; ++i) {
                this.enabledHeaderSet.add(this.enabledHeaders[i]);
            }
        }
        if (this.secretCookies != null) {
            for (i = 0; i < this.secretCookies.length; ++i) {
                this.secretCookieSet.add(this.secretCookies[i]);
            }
        }
        if (this.enabledCookies != null) {
            for (i = 0; i < this.enabledCookies.length; ++i) {
                this.enabledCookieSet.add(this.enabledCookies[i]);
            }
        }
    }

    public void stopService() {
        super.stopService();
        this.secretHeaderSet.clear();
        this.enabledHeaderSet.clear();
        this.secretCookieSet.clear();
        this.enabledCookieSet.clear();
    }

    public void destroyService() {
        super.destroyService();
        this.secretHeaderSet = null;
        this.enabledHeaderSet = null;
        this.secretCookieSet = null;
        this.enabledCookieSet = null;
    }

    protected StringBuffer makeAuthTypeFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getAuthType());
    }

    protected StringBuffer makeRemoteUserFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getRemoteUser());
    }

    protected StringBuffer makeUserPrincipalFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getUserPrincipal());
    }

    protected StringBuffer makeRequestURLFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getRequestURL());
    }

    protected StringBuffer makeRequestURIFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getRequestURI());
    }

    protected StringBuffer makeServletPathFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getServletPath());
    }

    protected StringBuffer makeContextPathFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getContextPath());
    }

    protected StringBuffer makePathInfoFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getPathInfo());
    }

    protected StringBuffer makePathTranslatedFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getPathTranslated());
    }

    protected StringBuffer makeQueryStringFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getQueryString());
    }

    protected StringBuffer makeSessionIDFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        buf.append(request.getRequestedSessionId());
        if (request.isRequestedSessionIdFromCookie()) {
            buf.append(OPEN_BRACKET).append(FROM_COOKIE).append(CLOSE_BRACKET);
        } else if (request.isRequestedSessionIdFromURL()) {
            buf.append(OPEN_BRACKET).append(FROM_URL).append(CLOSE_BRACKET);
        }
        return buf;
    }

    protected StringBuffer makeMethodFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(request.getMethod());
    }

    protected StringBuffer makeHeadersFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        Enumeration headerNames = request.getHeaderNames();
        if (!headerNames.hasMoreElements()) {
            buf.append("null");
            return buf;
        }
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (!this.enabledHeaderSet.isEmpty() && !this.enabledHeaderSet.contains(name)) continue;
            buf.append(name);
            buf.append("=");
            if (this.secretHeaderSet.contains(name)) {
                buf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, request.getHeaders(name), buf);
            }
            if (!headerNames.hasMoreElements()) continue;
            buf.append(",");
        }
        return buf;
    }

    protected StringBuffer makeCookiesFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            buf.append("null");
            return buf;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!this.enabledCookieSet.isEmpty() && !this.enabledCookieSet.contains(this.name)) continue;
            buf.append(cookies[i].getName());
            buf.append("=");
            if (this.secretCookieSet.contains(cookies[i].getName())) {
                buf.append(this.getSecretString());
            } else {
                buf.append(cookies[i].getValue());
            }
            if (i == cookies.length - 1) continue;
            buf.append(",");
        }
        return buf;
    }

    protected abstract class ElementEditor
    extends ServletRequestCSVJournalEditorService.ElementEditor
    implements Serializable {
        protected ElementEditor() {
            super(HttpServletRequestCSVJournalEditorService.this);
        }

        protected StringBuffer toString(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
            return this.toString(finder, key, (HttpServletRequest)request, buf);
        }

        protected abstract StringBuffer toString(EditorFinder var1, Object var2, HttpServletRequest var3, StringBuffer var4);
    }
}

