/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import jp.ossc.nimbus.service.jms.JMSConnectionCreateException;
import jp.ossc.nimbus.service.jms.JMSConnectionFactoryService;

public class JMSQueueConnectionFactoryService
extends JMSConnectionFactoryService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection getConnection(String user, String pwd) throws JMSConnectionCreateException {
        if (this.connectionFactory == null) {
            throw new JMSConnectionCreateException("ConnectionFactory is null.");
        }
        if (!(this.connectionFactory instanceof QueueConnectionFactory)) {
            throw new JMSConnectionCreateException("ConnectionFactory is not QueueConnectionFactory.");
        }
        Connection con = null;
        if (this.isSingleConnection) {
            if (this.connectionCache != null) {
                con = (Connection)this.connectionCache.get(this.connectionKey);
                if (con != null) {
                    return con;
                }
            } else if (this.connection != null) {
                return this.connection;
            }
        }
        try {
            if (this.isSingleConnection) {
                ConnectionFactory connectionFactory = this.connectionFactory;
                synchronized (connectionFactory) {
                    if (this.connectionCache != null) {
                        con = (Connection)this.connectionCache.get(this.connectionKey);
                        if (con != null) {
                            return con;
                        }
                    } else if (this.connection != null) {
                        return this.connection;
                    }
                    if ((con = user != null ? ((QueueConnectionFactory)this.connectionFactory).createQueueConnection(user, pwd) : ((QueueConnectionFactory)this.connectionFactory).createQueueConnection()) != null) {
                        if (this.connectionCache != null) {
                            this.connectionCache.put(this.connectionKey, con);
                            this.connectionCache.getCachedReference(this.connectionKey).addCacheRemoveListener(this);
                        } else {
                            this.connection = con;
                        }
                    }
                }
            } else {
                con = user != null ? ((QueueConnectionFactory)this.connectionFactory).createQueueConnection(user, pwd) : ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
            }
            if (this.isConnectionManagement) {
                this.connections.add(con);
            }
        }
        catch (JMSException e) {
            throw new JMSConnectionCreateException(e);
        }
        return con;
    }
}

