/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import jp.ossc.nimbus.service.graph.AbstractTickUnitAdjusterService;
import jp.ossc.nimbus.service.graph.DateAxisTickUnitAdjusterServiceMBean;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.ValueAxis;

public class DateAxisTickUnitAdjusterService
extends AbstractTickUnitAdjusterService
implements DateAxisTickUnitAdjusterServiceMBean {
    private DateFormat format;

    protected void adjust(ValueAxis axis) {
        if (!(axis instanceof DateAxis)) {
            throw new IllegalArgumentException("axis is not DateAxis.");
        }
        DateAxis dateAxis = (DateAxis)axis;
        DateTickUnit orgTickUnit = dateAxis.getTickUnit();
        int unit = orgTickUnit.getUnit();
        double length = dateAxis.getRange().getLength();
        if (5 == unit) {
            length /= 1000.0;
        } else if (4 == unit) {
            length /= 60000.0;
        } else if (3 == unit) {
            length /= 3600000.0;
        } else if (2 == unit) {
            length /= 8.64E7;
        } else if (1 == unit) {
            length /= 2.4192E9;
        } else if (0 == unit) {
            length /= 3.1536E10;
        }
        double unitCount = length / (double)this.displayGraduationCount;
        unitCount = unitCount <= 0.0 ? 1.0 : this.adjustUnitCountByCommonDivisor(axis, unitCount);
        DateFormat newFormat = null;
        newFormat = this.format != null ? this.format : new SimpleDateFormat();
        dateAxis.setTickUnit(new DateTickUnit(orgTickUnit.getUnit(), (int)Math.ceil(unitCount), newFormat));
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public DateFormat getFormat() {
        return this.format;
    }
}

