/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.graph.CombinedDomainXYPlotFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.PlotCondition;
import jp.ossc.nimbus.service.graph.PlotCreateException;
import jp.ossc.nimbus.service.graph.PlotFactory;
import jp.ossc.nimbus.service.graph.TickUnitAdjuster;
import jp.ossc.nimbus.service.graph.XYPlotConditionImpl;
import jp.ossc.nimbus.service.graph.XYPlotFactoryService;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

public class CombinedDomainXYPlotFactoryService
extends XYPlotFactoryService
implements CombinedDomainXYPlotFactoryServiceMBean,
PlotFactory {
    private String name;
    private CombinedDomainXYPlot tmpPlot;
    private ServiceName[] subPlotFactoryServiceNames;
    private ServiceName[] domainAxisServiceNames;
    private List subPlotFactoryServices;

    public void setSubPlotFactoryServiceNames(ServiceName[] serviceNames) {
        this.subPlotFactoryServiceNames = serviceNames;
    }

    public ServiceName[] getSubPlotFactoryServiceNames() {
        return this.subPlotFactoryServiceNames;
    }

    public void setDomainAxisServiceNames(ServiceName[] serviceNames) {
        this.domainAxisServiceNames = serviceNames;
    }

    public ServiceName[] getDomainAxisServiceNames() {
        return this.domainAxisServiceNames;
    }

    public void createService() throws Exception {
        this.tmpPlot = new CombinedDomainXYPlot();
        this.subPlotFactoryServices = new ArrayList();
    }

    public void startService() throws Exception {
        int i;
        if (this.name == null) {
            this.name = this.getServiceName();
        }
        if (this.subPlotFactoryServiceNames == null || this.subPlotFactoryServiceNames.length == 0) {
            throw new IllegalArgumentException("SubPlotServiceNames must be specified.");
        }
        for (i = 0; i < this.subPlotFactoryServiceNames.length; ++i) {
            PlotFactory plotFactory = (PlotFactory)ServiceManagerFactory.getServiceObject(this.subPlotFactoryServiceNames[i]);
            this.subPlotFactoryServices.add(plotFactory);
        }
        if (this.tickUnitAdjusterServiceNames != null && this.tickUnitAdjusterServiceNames.length != 0) {
            this.adjusters = new TickUnitAdjuster[this.tickUnitAdjusterServiceNames.length];
            for (i = 0; i < this.adjusters.length; ++i) {
                this.adjusters[i] = (TickUnitAdjuster)ServiceManagerFactory.getServiceObject(this.tickUnitAdjusterServiceNames[i]);
            }
        }
    }

    public void stopService() throws Exception {
        this.subPlotFactoryServices.clear();
    }

    public void destroyService() throws Exception {
        this.tmpPlot = null;
        this.subPlotFactoryServices = null;
    }

    public Plot getPlot() {
        return this.tmpPlot;
    }

    public Plot createPlot(PlotCondition[] plotConditions) throws PlotCreateException {
        CombinedDomainXYPlot combinedPlot = new CombinedDomainXYPlot();
        if (plotConditions == null || plotConditions.length == 0) {
            return combinedPlot;
        }
        for (int i = 0; i < this.subPlotFactoryServices.size(); ++i) {
            PlotFactory plotFactory = (PlotFactory)this.subPlotFactoryServices.get(i);
            Plot plot = plotFactory.createPlot(plotConditions);
            if (plot == null || !(plot instanceof XYPlot)) continue;
            XYPlot xyPlot = (XYPlot)plot;
            combinedPlot.add(xyPlot, xyPlot.getWeight());
        }
        XYPlotConditionImpl xyPlotCondition = this.mergeXYPlotCondition(plotConditions);
        if (this.domainAxisServiceNames != null && this.domainAxisServiceNames.length > 0) {
            for (int i = 0; i < this.domainAxisServiceNames.length; ++i) {
                ValueAxis domainAxis = (ValueAxis)ServiceManagerFactory.getServiceObject(this.domainAxisServiceNames[i]);
                if (xyPlotCondition != null) {
                    if (xyPlotCondition.getDefaultDomainAxisLabelFontName() != null || xyPlotCondition.getDefaultDomainAxisLabelFontStyle() != Integer.MIN_VALUE || xyPlotCondition.getDefaultDomainAxisLabelFontSize() != Integer.MIN_VALUE) {
                        domainAxis.setLabelFont(this.mergeFont(domainAxis.getLabelFont(), xyPlotCondition.getDefaultDomainAxisLabelFontName(), xyPlotCondition.getDefaultDomainAxisLabelFontStyle(), xyPlotCondition.getDefaultDomainAxisLabelFontSize()));
                    } else if (xyPlotCondition.getDomainAxisLabelFontName(i) != null || xyPlotCondition.getDomainAxisLabelFontStyle(i) != Integer.MIN_VALUE || xyPlotCondition.getDomainAxisLabelFontSize(i) != Integer.MIN_VALUE) {
                        domainAxis.setLabelFont(this.mergeFont(domainAxis.getLabelFont(), xyPlotCondition.getDomainAxisLabelFontName(i), xyPlotCondition.getDomainAxisLabelFontStyle(i), xyPlotCondition.getDomainAxisLabelFontSize(i)));
                    }
                    if (xyPlotCondition.getDefaultDomainAxisTickLabelFontName() != null || xyPlotCondition.getDefaultDomainAxisTickLabelFontStyle() != Integer.MIN_VALUE || xyPlotCondition.getDefaultDomainAxisTickLabelFontSize() != Integer.MIN_VALUE) {
                        domainAxis.setTickLabelFont(this.mergeFont(domainAxis.getTickLabelFont(), xyPlotCondition.getDefaultDomainAxisTickLabelFontName(), xyPlotCondition.getDefaultDomainAxisTickLabelFontStyle(), xyPlotCondition.getDefaultDomainAxisTickLabelFontSize()));
                    } else if (xyPlotCondition.getDomainAxisTickLabelFontName(i) != null || xyPlotCondition.getDomainAxisTickLabelFontStyle(i) != Integer.MIN_VALUE || xyPlotCondition.getDomainAxisTickLabelFontSize(i) != Integer.MIN_VALUE) {
                        domainAxis.setTickLabelFont(this.mergeFont(domainAxis.getTickLabelFont(), xyPlotCondition.getDomainAxisTickLabelFontName(i), xyPlotCondition.getDomainAxisTickLabelFontStyle(i), xyPlotCondition.getDomainAxisTickLabelFontSize(i)));
                    }
                }
                combinedPlot.setDomainAxis(i, domainAxis);
            }
        }
        if (this.getTickUnitAdjusters() != null) {
            TickUnitAdjuster[] adjusters = this.getTickUnitAdjusters();
            for (int i = 0; i < adjusters.length; ++i) {
                adjusters[i].adjust((XYPlot)combinedPlot);
            }
        }
        return combinedPlot;
    }

    public void setDatasetFactoryServiceNames(ServiceName[] names) {
        throw new UnsupportedOperationException();
    }

    public ServiceName[] getDatasetFactoryServiceNames() {
        throw new UnsupportedOperationException();
    }

    public void setDatasetRendererServiceNames(Properties names) {
        throw new UnsupportedOperationException();
    }

    public Properties getDatasetRendererServiceNames() {
        throw new UnsupportedOperationException();
    }

    public void setDatasetDomainAxisNames(Properties names) {
        throw new UnsupportedOperationException();
    }

    public Properties getDatasetDomainAxisNames() {
        throw new UnsupportedOperationException();
    }

    public void setDatasetRangeAxisNames(Properties names) {
        throw new UnsupportedOperationException();
    }

    public Properties getDatasetRangeAxisNames() {
        throw new UnsupportedOperationException();
    }

    public void setRangeAxisServiceNames(ServiceName[] serviceNames) {
        throw new UnsupportedOperationException();
    }

    public ServiceName[] getRangeAxisServiceNames() {
        throw new UnsupportedOperationException();
    }
}

