/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ejb.transaction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.ejb.transaction.TransactionControl;
import jp.ossc.nimbus.service.ejb.transaction.TransactionControlServiceMBean;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class TransactionControlService
extends ServiceBase
implements TransactionControl,
TransactionControlServiceMBean {
    private boolean mIsJNDIMode = true;
    private ServiceName mJNDIServiceName = null;
    private JndiFinder mJNDIFinder = null;
    private String mTransactionManagerFactoryClassName = null;
    private Class mTmFactoryClass = null;
    private String mGetTransactionManagerMethodName = null;
    private Method mGetTmFactoryMethod = null;
    private ThreadLocal mTransactionLocal = null;
    private ThreadLocal mTransactionManagerLocal = null;

    public void createService() {
        this.mTransactionLocal = new ThreadLocal();
        this.mTransactionManagerLocal = new ThreadLocal();
    }

    public void startService() {
        if (this.mIsJNDIMode) {
            if (this.mJNDIServiceName == null) {
                throw new ServiceException("TransactionControl001", "JNDIServiceName is not set");
            }
            this.mJNDIFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.mJNDIServiceName);
            if (this.mJNDIFinder == null) {
                throw new ServiceException("TransactionControl002", "JNDIFinderService not exist");
            }
        } else {
            if (this.mTransactionManagerFactoryClassName == null) {
                throw new ServiceException("TransactionControl003", "TransactionManagerFactoryClassName is not set");
            }
            try {
                this.mTmFactoryClass = Class.forName(this.mTransactionManagerFactoryClassName, true, NimbusClassLoader.getInstance());
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException("TransactionControl004", "TransactionManagerFactoryClass not found", e);
            }
            if (this.mGetTransactionManagerMethodName == null) {
                throw new ServiceException("TransactionControl005", "GetTransactionManagerMethodName is not set");
            }
            try {
                this.mGetTmFactoryMethod = this.mTmFactoryClass.getMethod(this.mGetTransactionManagerMethodName, null);
            }
            catch (SecurityException e1) {
                throw new ServiceException("TransactionControl006", "SecurityException methodname is " + this.mGetTransactionManagerMethodName, e1);
            }
            catch (NoSuchMethodException e1) {
                throw new ServiceException("TransactionControl007", "TransactionManagerFactoryClass not found", e1);
            }
        }
    }

    public int getState() {
        TransactionState state = (TransactionState)this.mTransactionLocal.get();
        if (state == null) {
            return 0;
        }
        state = this.getCurrentTransactionState(state);
        return state.getState();
    }

    public void suspend() {
        TransactionState state = (TransactionState)this.mTransactionLocal.get();
        TransactionManager tm = null;
        if (state == null) {
            state = new TransactionState();
            tm = this.getTransactionManager();
            try {
                this.changeSuspend(state, tm);
            }
            catch (SystemException e) {
                throw new ServiceException("TransactionControl700", "Transaction suspend error", e);
            }
            this.mTransactionLocal.set(state);
            this.mTransactionManagerLocal.set(tm);
        } else {
            TransactionState addState = new TransactionState();
            addState.setParentState(state);
            tm = (TransactionManager)this.mTransactionManagerLocal.get();
            state = this.getCurrentTransactionState(state);
            if (state.getState() == 0) {
                try {
                    this.changeSuspend(addState, tm);
                }
                catch (SystemException e) {
                    throw new ServiceException("TransactionControl702", "Transaction suspend error", e);
                }
                state.setChildState(addState);
            } else {
                throw new ServiceException("TransactionControl703", "Transaction suspend state invalid");
            }
        }
    }

    public void terminateTransactioinControl() {
        this.mTransactionLocal.set(null);
        this.mTransactionManagerLocal.set(null);
    }

    protected void changeSuspend(TransactionState state, TransactionManager tm) throws SystemException {
        Transaction old = null;
        old = tm.suspend();
        state.setCurrentTransaction(old);
        state.setState(1);
    }

    protected TransactionState getCurrentTransactionState(TransactionState state) {
        TransactionState ret = null;
        ret = state;
        while (ret.getChildState() != null) {
        }
        return ret;
    }

    protected TransactionManager getTransactionManager() {
        TransactionManager tm = null;
        if (this.mIsJNDIMode) {
            try {
                tm = (TransactionManager)this.mJNDIFinder.lookup();
            }
            catch (NamingException e) {
                throw new ServiceException("TransactionControl100", "TransactionManager get Error NamingException", e);
            }
        }
        try {
            tm = (TransactionManager)this.mGetTmFactoryMethod.invoke((Object)this.mTmFactoryClass, null);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("TransactionControl101", "TransactionManager get Error IllegalArgumentException", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("TransactionControl102", "TransactionManager get Error IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("TransactionControl103", "TransactionManager get Error InvocationTargetException", e);
        }
        return tm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resume() {
        TransactionState state = (TransactionState)this.mTransactionLocal.get();
        if (state == null) throw new ServiceException("TransactionControl304", "Transaction state none");
        if ((state = this.getCurrentTransactionState(state)).getState() != 1) throw new ServiceException("TransactionControl303", "Transaction state invalid");
        TransactionManager tm = (TransactionManager)this.mTransactionManagerLocal.get();
        Transaction tran = state.getCurrentTransaction();
        try {
            tm.resume(tran);
        }
        catch (InvalidTransactionException e) {
            throw new ServiceException("TransactionControl300", "TransactionManager resume Error InvalidTransactionException", e);
        }
        catch (IllegalStateException e) {
            throw new ServiceException("TransactionControl301", "TransactionManager resume Error IllegalStateException", e);
        }
        catch (SystemException e) {
            throw new ServiceException("TransactionControl302", "TransactionManager resume Error SystemException", e);
        }
        TransactionState parentState = state.getParentState();
        if (parentState == null) {
            this.terminateTransactioinControl();
            return;
        } else {
            parentState.setChildState(null);
        }
    }

    public void beginNewTransaction() {
        Transaction newTran;
        TransactionState state = (TransactionState)this.mTransactionLocal.get();
        if (state != null) {
            if ((state = this.getCurrentTransactionState(state)).getState() == 1) {
                TransactionManager tm = (TransactionManager)this.mTransactionManagerLocal.get();
                try {
                    tm.begin();
                }
                catch (NotSupportedException e) {
                    throw new ServiceException("TransactionControl400", "TransactionManager begin Error NotSupportedException", e);
                }
                catch (SystemException e) {
                    throw new ServiceException("TransactionControl401", "TransactionManager begin Error SystemException", e);
                }
                newTran = null;
                try {
                    newTran = tm.getTransaction();
                }
                catch (SystemException e1) {
                    try {
                        tm.rollback();
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                    throw new ServiceException("TransactionControl402", "New Transaction get Error SystemException", e1);
                }
            }
            throw new ServiceException("TransactionControl403", "New Transaction state invalid");
        }
        throw new ServiceException("TransactionControl404", "New Transaction state invalid");
        TransactionState newState = new TransactionState();
        newState.setParentState(state);
        newState.setCurrentTransaction(newTran);
        newState.setState(0);
        state.setChildState(newState);
    }

    public void commitNewTransaction() {
        TransactionState state = (TransactionState)this.mTransactionLocal.get();
        if (state != null) {
            if ((state = this.getCurrentTransactionState(state)).getState() == 0) {
                TransactionManager tm = (TransactionManager)this.mTransactionManagerLocal.get();
                Transaction tran = state.getCurrentTransaction();
                try {
                    tran.commit();
                }
                catch (SecurityException e) {
                    throw new ServiceException("TransactionControl500", "Transaction Commit Error SecurityException", e);
                }
                catch (RollbackException e) {
                    throw new ServiceException("TransactionControl501", "Transaction Commit Error RollbackException", e);
                }
                catch (HeuristicMixedException e) {
                    throw new ServiceException("TransactionControl502", "Transaction Commit Error HeuristicMixedException", e);
                }
                catch (HeuristicRollbackException e) {
                    throw new ServiceException("TransactionControl503", "Transaction Commit Error HeuristicRollbackException ", e);
                }
                catch (SystemException e) {
                    throw new ServiceException("TransactionControl504", "Transaction Commit Error SystemException", e);
                }
                try {
                    tm.commit();
                }
                catch (SecurityException e1) {
                    throw new ServiceException("TransactionControl510", "TransactionManager Commit Error SecurityException", e1);
                }
                catch (IllegalStateException e1) {
                    throw new ServiceException("TransactionControl511", "TransactionManager Commit Error IllegalStateException", e1);
                }
                catch (RollbackException e1) {
                    throw new ServiceException("TransactionControl512", "TransactionManager Commit Error RollbackException", e1);
                }
                catch (HeuristicMixedException e1) {
                    throw new ServiceException("TransactionControl513", "TransactionManager Commit Error HeuristicMixedException", e1);
                }
                catch (HeuristicRollbackException e1) {
                    throw new ServiceException("TransactionControl514", "TransactionManager Commit Error HeuristicRollbackException", e1);
                }
                catch (SystemException e1) {
                    throw new ServiceException("TransactionControl515", "TransactionManager Commit Error SystemException", e1);
                }
            }
            throw new ServiceException("TransactionControl516", "TransactionManager Commit Error state invalid");
        }
        throw new ServiceException("TransactionControl517", "TransactionManager Commit Error state invalid");
        TransactionState parent = state.getParentState();
        parent.setChildState(null);
    }

    public void rollBackNewTransaction() {
        TransactionState state = (TransactionState)this.mTransactionLocal.get();
        if (state != null) {
            if ((state = this.getCurrentTransactionState(state)).getState() == 0) {
                Transaction tran = state.getCurrentTransaction();
                TransactionManager tm = (TransactionManager)this.mTransactionManagerLocal.get();
                try {
                    tran.rollback();
                }
                catch (SecurityException e) {
                    throw new ServiceException("TransactionControl600", "Transaction RollBack Error SecurityException", e);
                }
                catch (SystemException e) {
                    throw new ServiceException("TransactionControl601", "Transaction RollBack Error SecurityException", e);
                }
                try {
                    tm.commit();
                }
                catch (RollbackException e2) {
                    throw new ServiceException("TransactionControl610", "TransactionManager Commit Error RollbackException", e2);
                }
                catch (HeuristicMixedException e2) {
                    throw new ServiceException("TransactionControl611", "TransactionManager Commit Error HeuristicMixedException", e2);
                }
                catch (HeuristicRollbackException e2) {
                    throw new ServiceException("TransactionControl612", "TransactionManager Commit Error HeuristicRollbackException", e2);
                }
                catch (SystemException e2) {
                    throw new ServiceException("TransactionControl613", "TransactionManager Commit Error SystemException", e2);
                }
            }
            throw new ServiceException("TransactionControl614", "Transaction eollbacl Error State Invalid");
        }
        throw new ServiceException("TransactionControl615", "Transaction eollbacl Error State Invalid");
        TransactionState parent = state.getParentState();
        parent.setChildState(null);
    }

    public void setJNDIMode(boolean isJNDIMode) {
        this.mIsJNDIMode = isJNDIMode;
    }

    public void setJNDIServiceName(ServiceName name) {
        this.mJNDIServiceName = name;
    }

    public void setTransactionManagerFactoryClassName(String clsName) {
        this.mTransactionManagerFactoryClassName = clsName;
    }

    public void setGetTransactinManagerMethodName(String methodName) {
        this.mGetTransactionManagerMethodName = methodName;
    }

    public void setJndiFinder(JndiFinder finder) {
        this.mJNDIFinder = finder;
    }

    private class TransactionState {
        private int mState = 1;
        private Transaction mCurrentTransaction = null;
        private TransactionState mChildState = null;
        private TransactionState mParentState = null;

        private TransactionState() {
        }

        public TransactionState getChildState() {
            return this.mChildState;
        }

        public Transaction getCurrentTransaction() {
            return this.mCurrentTransaction;
        }

        public int getState() {
            return this.mState;
        }

        public void setChildState(TransactionState state) {
            this.mChildState = state;
        }

        public void setCurrentTransaction(Transaction transaction) {
            this.mCurrentTransaction = transaction;
        }

        public void setState(int i) {
            this.mState = i;
        }

        public TransactionState getParentState() {
            return this.mParentState;
        }

        public void setParentState(TransactionState state) {
            this.mParentState = state;
        }
    }
}

