/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.context.DefaultContextServiceMBean;

public class DefaultContextService
extends ServiceBase
implements Context,
DefaultContextServiceMBean,
Serializable {
    protected Map context;

    public void createService() throws Exception {
        this.context = Collections.synchronizedMap(new HashMap());
    }

    public void stopService() throws Exception {
        this.context.clear();
    }

    public void destroyService() throws Exception {
        this.context = null;
    }

    public Object get(Object key) {
        Object val = this.context.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof ServiceName) {
            ServiceName name = (ServiceName)val;
            try {
                val = ServiceManagerFactory.getServiceObject(name);
            }
            catch (ServiceNotFoundException e) {
                val = null;
            }
        }
        return val;
    }

    public Object put(Object key, Object value) {
        return this.context.put(key, value);
    }

    public Set keySet() {
        return this.context.keySet();
    }

    public Collection values() {
        return this.context.values();
    }

    public Object remove(Object key) {
        return this.context.remove(key);
    }

    public void clear() {
        this.context.clear();
    }

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.context.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.context.containsValue(value);
    }

    public Set entrySet() {
        return this.context.entrySet();
    }

    public boolean equals(Object o) {
        if (this.context == null) {
            return super.equals(o);
        }
        return ((Object)this.context).equals(o);
    }

    public int hashCode() {
        if (this.context == null) {
            return super.hashCode();
        }
        return ((Object)this.context).hashCode();
    }

    public int size() {
        return this.context.size();
    }

    public void putAll(Map t) {
        this.context.putAll(t);
    }

    public Hashtable cloneHash() {
        return new Hashtable(this.context);
    }

    public Object get(String key) {
        return this.get((Object)key);
    }

    public Object put(String key, String value) {
        return this.put((Object)key, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String list() {
        StringBuffer buf = new StringBuffer();
        Map map = this.context;
        synchronized (map) {
            Iterator ite = this.context.keySet().iterator();
            while (ite.hasNext()) {
                Object key = ite.next();
                buf.append(key);
                buf.append(" : ");
                buf.append(this.context.get(key));
                buf.append('\n');
            }
        }
        return buf.toString();
    }
}

