/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheAccessListener;
import jp.ossc.nimbus.service.cache.CacheChangeListener;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;
import jp.ossc.nimbus.service.cache.LinkedReference;

public class DefaultCachedReference
implements CachedReference,
Serializable {
    protected Object cacheObj;
    protected transient Set linkedReferences;
    protected transient Set removeListeners;
    protected transient Set accessListeners;
    protected transient Set changeListeners;
    protected boolean isRemoved;

    public DefaultCachedReference(Object obj) {
        this.cacheObj = obj;
    }

    public Object get() {
        return this.get(null, true);
    }

    public Object get(Object source) {
        return this.get(source, true);
    }

    public Object get(Object source, boolean notify) {
        if (notify) {
            this.notifyAccessed(source);
        }
        if (this.cacheObj == null) {
            this.cacheObj = this.getLinkedObject();
        }
        return this.cacheObj;
    }

    public void set(Object obj) throws IllegalCachedReferenceException {
        this.set(null, obj);
    }

    public void set(Object source, Object obj) throws IllegalCachedReferenceException {
        this.notifyChange(source, obj);
        this.cacheObj = obj;
    }

    protected Object getLinkedObject() {
        if (this.linkedReferences == null || this.linkedReferences.size() == 0) {
            return null;
        }
        Object[] links = this.linkedReferences.toArray();
        for (int i = 0; i < links.length; ++i) {
            Object obj = ((LinkedReference)links[i]).get(this);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public void remove() {
        this.remove(null);
    }

    public void remove(Object source) {
        this.notifyRemoved(source);
        this.cacheObj = null;
        if (this.linkedReferences != null) {
            this.linkedReferences.clear();
        }
        this.isRemoved = true;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    protected void notifyRemoved(Object source) {
        if (this.removeListeners == null || this.removeListeners.size() == 0) {
            return;
        }
        Object[] listeners = this.removeListeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            CacheRemoveListener listener = (CacheRemoveListener)listeners[i];
            if (source == listener) continue;
            listener.removed(this);
        }
    }

    protected void notifyAccessed(Object source) {
        if (this.accessListeners == null || this.accessListeners.size() == 0) {
            return;
        }
        Object[] listeners = this.accessListeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            CacheAccessListener listener = (CacheAccessListener)listeners[i];
            if (source == listener) continue;
            listener.accessed(this);
        }
    }

    protected void notifyChange(Object source, Object obj) {
        if (this.changeListeners == null || this.changeListeners.size() == 0) {
            return;
        }
        Object[] listeners = this.changeListeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            CacheChangeListener listener = (CacheChangeListener)listeners[i];
            if (source == listener) continue;
            listener.changed(this, obj);
        }
    }

    public void addLinkedReference(LinkedReference ref) {
        if (this.linkedReferences == null) {
            this.linkedReferences = Collections.synchronizedSet(new HashSet());
        }
        this.linkedReferences.add(ref);
    }

    public void removeLinkedReference(LinkedReference ref) {
        if (this.linkedReferences == null) {
            return;
        }
        this.linkedReferences.remove(ref);
    }

    public void addCacheRemoveListener(CacheRemoveListener listener) {
        if (this.removeListeners == null) {
            this.removeListeners = Collections.synchronizedSet(new HashSet());
        }
        this.removeListeners.add(listener);
    }

    public void removeCacheRemoveListener(CacheRemoveListener listener) {
        if (this.removeListeners == null) {
            return;
        }
        this.removeListeners.remove(listener);
    }

    public void addCacheAccessListener(CacheAccessListener listener) {
        if (this.accessListeners == null) {
            this.accessListeners = Collections.synchronizedSet(new HashSet());
        }
        this.accessListeners.add(listener);
    }

    public void removeCacheAccessListener(CacheAccessListener listener) {
        if (this.accessListeners == null) {
            return;
        }
        this.accessListeners.remove(listener);
    }

    public void addCacheChangeListener(CacheChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = Collections.synchronizedSet(new HashSet());
        }
        this.changeListeners.add(listener);
    }

    public void removeCacheChangeListener(CacheChangeListener listener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(listener);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeSet(out, this.linkedReferences);
        this.writeSet(out, this.removeListeners);
        this.writeSet(out, this.accessListeners);
        this.writeSet(out, this.changeListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSet(ObjectOutputStream out, Set set) throws IOException {
        if (set != null && set.size() != 0) {
            Set set2 = set;
            synchronized (set2) {
                Object[] objs = set.toArray();
                HashSet<Object> outSet = new HashSet<Object>();
                for (int i = 0; i < objs.length; ++i) {
                    Object obj = objs[i];
                    ServiceName name = this.getServiceName(obj);
                    if (name != null) {
                        outSet.add(name);
                        continue;
                    }
                    outSet.add(obj);
                }
                out.writeObject(outSet);
            }
        } else {
            out.writeObject(null);
        }
    }

    private ServiceName getServiceName(Object obj) {
        if (obj instanceof ServiceBase) {
            return ((ServiceBase)obj).getServiceNameObject();
        }
        if (obj instanceof Service) {
            Service service = (Service)obj;
            if (service.getServiceManagerName() != null && service.getServiceName() != null) {
                return new ServiceName(service.getServiceManagerName(), service.getServiceName());
            }
            return null;
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.linkedReferences = this.readSet(in);
        this.removeListeners = this.readSet(in);
        this.accessListeners = this.readSet(in);
        this.changeListeners = this.readSet(in);
    }

    private Set readSet(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        Set set = (Set)o;
        Set<Object> result = null;
        if (set != null) {
            if (result == null) {
                result = Collections.synchronizedSet(new HashSet());
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj instanceof ServiceName) {
                    result.add(ServiceManagerFactory.getServiceObject((ServiceName)obj));
                    continue;
                }
                result.add(obj);
            }
        }
        return result;
    }
}

