/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import org.w3c.dom.Element;

public class DefaultLogMetaData
extends MetaData
implements Serializable {
    public static final String DEFAULT_LOG_TAG_NAME = "default-log";
    private static final String DEBUG_TAG_NAME = "debug";
    private static final String INFORMATION_TAG_NAME = "information";
    private static final String WARNING_TAG_NAME = "warning";
    private static final String ERROR_TAG_NAME = "error";
    private static final String FATAL_TAG_NAME = "fatal";
    private static final String OUTPUT_ATTRIBUTE_NAME = "output";
    private LogCategoryMetaData debug;
    private LogCategoryMetaData information;
    private LogCategoryMetaData warning;
    private LogCategoryMetaData error;
    private LogCategoryMetaData fatal;

    public DefaultLogMetaData(MetaData parent) {
        super(parent);
    }

    public LogCategoryMetaData getDebug() {
        return this.debug;
    }

    public void setDebug(LogCategoryMetaData data) {
        this.debug = data;
    }

    public LogCategoryMetaData getInformation() {
        return this.information;
    }

    public void setInformation(LogCategoryMetaData data) {
        this.information = data;
    }

    public LogCategoryMetaData getWarning() {
        return this.warning;
    }

    public void setWarning(LogCategoryMetaData data) {
        this.warning = data;
    }

    public LogCategoryMetaData getError() {
        return this.error;
    }

    public void setError(LogCategoryMetaData data) {
        this.error = data;
    }

    public LogCategoryMetaData getFatal() {
        return this.fatal;
    }

    public void setFatal(LogCategoryMetaData data) {
        this.fatal = data;
    }

    public void importXML(Element element) throws DeploymentException {
        Element fatalElement;
        Element errorElement;
        Element warningElement;
        Element informationElement;
        super.importXML(element);
        if (!element.getTagName().equals(DEFAULT_LOG_TAG_NAME)) {
            throw new DeploymentException("Tag must be default-log : " + element.getTagName());
        }
        Element debugElement = DefaultLogMetaData.getOptionalChild(element, DEBUG_TAG_NAME);
        if (debugElement != null) {
            this.debug = new LogCategoryMetaData(this);
            this.debug.importXML(debugElement);
        }
        if ((informationElement = DefaultLogMetaData.getOptionalChild(element, INFORMATION_TAG_NAME)) != null) {
            this.information = new LogCategoryMetaData(this);
            this.information.importXML(informationElement);
        }
        if ((warningElement = DefaultLogMetaData.getOptionalChild(element, WARNING_TAG_NAME)) != null) {
            this.warning = new LogCategoryMetaData(this);
            this.warning.importXML(warningElement);
        }
        if ((errorElement = DefaultLogMetaData.getOptionalChild(element, ERROR_TAG_NAME)) != null) {
            this.error = new LogCategoryMetaData(this);
            this.error.importXML(errorElement);
        }
        if ((fatalElement = DefaultLogMetaData.getOptionalChild(element, FATAL_TAG_NAME)) != null) {
            this.fatal = new LogCategoryMetaData(this);
            this.fatal.importXML(fatalElement);
        }
    }

    public static class LogCategoryMetaData
    extends MetaData
    implements Serializable {
        private boolean isOutput;

        public LogCategoryMetaData(MetaData parent) {
            super(parent);
        }

        public boolean isOutput() {
            return this.isOutput;
        }

        public void setOutput(boolean isOutput) {
            this.isOutput = isOutput;
        }

        public void importXML(Element element) throws DeploymentException {
            super.importXML(element);
            String output = LogCategoryMetaData.getOptionalAttribute(element, DefaultLogMetaData.OUTPUT_ATTRIBUTE_NAME);
            if (output != null) {
                this.isOutput = Boolean.valueOf(output);
            }
        }
    }
}

