/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import jp.ossc.nimbus.beans.Utility;

public class CharacterEditor
extends PropertyEditorSupport
implements Serializable {
    private static final String HEX_PREFIX = "0x";
    private static final String UNICODE_PREFIX = "\\u";

    public void setAsText(String text) {
        String charStr = Utility.replaceSystemProperty(text);
        if (charStr.length() == 1) {
            this.setValue(new Character(charStr.charAt(0)));
        } else if (charStr.startsWith(HEX_PREFIX) && charStr.length() > 2) {
            this.setValue(new Character((char)Integer.parseInt(charStr.substring(2), 16)));
        } else if (charStr.startsWith(UNICODE_PREFIX) && charStr.length() > 2) {
            if ((charStr = Utility.unicodeConvert(charStr)).length() != 1) {
                throw new IllegalArgumentException("Not a character. : " + charStr);
            }
            this.setValue(new Character(charStr.charAt(0)));
        } else {
            throw new IllegalArgumentException("Not a character. : " + charStr);
        }
    }

    public String getAsText() {
        return String.valueOf(((Character)this.getValue()).charValue());
    }
}

