/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.writer.PropertyWritableRecordFactoryServiceMBean;
import jp.ossc.nimbus.service.writer.WritableRecordFactoryService;

public class PropertyWritableRecordFactoryService
extends WritableRecordFactoryService
implements PropertyWritableRecordFactoryServiceMBean,
Serializable {
    private static final String PWRF_ = "PWRF_";
    private static final String PWRF_0 = "PWRF_0";
    private static final String PWRF_00 = "PWRF_00";
    private static final String PWRF_000 = "PWRF_000";
    private static final String PWRF_0000 = "PWRF_0000";
    private static final String PWRF_00001 = "PWRF_00001";
    private Properties formatKeyMapping;
    private Map writableRecordPropertyMapping;

    public void createService() throws Exception {
        super.createService();
        this.writableRecordPropertyMapping = new HashMap();
    }

    public void startService() throws Exception {
        super.startService();
        if (this.formatKeyMapping != null) {
            Iterator<Object> keys = this.formatKeyMapping.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String prop = this.formatKeyMapping.getProperty(key);
                if (prop == null || prop.length() == 0) continue;
                this.writableRecordPropertyMapping.put(key, PropertyFactory.createProperty(prop));
            }
        }
    }

    public void stopService() throws Exception {
        this.writableRecordPropertyMapping.clear();
        super.stopService();
    }

    public void destroyService() throws Exception {
        this.writableRecordPropertyMapping = null;
        super.destroyService();
    }

    public void setFormatKeyMapping(Properties mapping) {
        this.formatKeyMapping = mapping;
    }

    public Properties getFormatKeyMapping() {
        return this.formatKeyMapping;
    }

    protected Object getElementValue(String key, Map elements) {
        if (this.writableRecordPropertyMapping.containsKey(key)) {
            Logger logger = this.getLogger();
            Property property = (Property)this.writableRecordPropertyMapping.get(key);
            try {
                return property.getProperty(elements);
            }
            catch (NoSuchPropertyException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                logger.write(PWRF_00001, (Object)key, (Throwable)e);
                return null;
            }
        }
        return super.getElementValue(key, elements);
    }
}

