/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.io.PrintStream;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.writer.ConsoleWriterServiceMBean;
import jp.ossc.nimbus.service.writer.MessageWriter;
import jp.ossc.nimbus.service.writer.WritableRecord;

public class ConsoleWriterService
extends ServiceBase
implements ConsoleWriterServiceMBean,
MessageWriter {
    private String mOutputKind = "STDOUT";
    private PrintStream mOutputStream;

    public void setOutput(String kind) {
        if (!"STDOUT".equals(kind) && !"STDERR".equals(kind)) {
            throw new IllegalArgumentException(kind);
        }
        this.mOutputKind = kind;
    }

    public String getOutput() {
        return this.mOutputKind;
    }

    public void startService() {
        this.mOutputStream = this.mOutputKind.equals("STDERR") ? System.err : System.out;
    }

    public void stopService() {
        this.mOutputStream = null;
    }

    public void write(WritableRecord rec) {
        this.mOutputStream.println(rec.toString());
    }
}

