/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.jmstopic;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.jmstopic.JmsTopicSession;
import jp.ossc.nimbus.service.resource.jmstopic.JmsTopicSessionServiceMBean;
import jp.ossc.nimbus.service.resource.jmstopic.TopicTransanctionResource;

public class JmsTopicSessionService
extends ServiceBase
implements JmsTopicSession,
JmsTopicSessionServiceMBean,
CacheRemoveListener {
    private ServiceName mJndiFinderServiceName = null;
    private JndiFinder mJndiFinderService = null;
    private int mAckMode = 1;
    private TopicConnectionFactory mtFactory = null;
    private TopicConnection mtConn = null;
    private boolean mTransanctionMode = false;
    private String connectionFactoryName = "";
    private String connectionKey = "TopicConnection";
    private ServiceName connectionCacheMapServiceName;
    private CacheMap connectionCache;
    private String mUserName = null;
    private String mPassword = null;

    public void setJndiFinderServiceName(ServiceName name) {
        this.mJndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.mJndiFinderServiceName;
    }

    public void setConnectionFactoryName(String name) {
        this.connectionFactoryName = name;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionCacheKey(String key) {
        this.connectionKey = key;
    }

    public String getConnectionCacheKey() {
        return this.connectionKey;
    }

    public void setConnectionCacheMapServiceName(ServiceName name) {
        this.connectionCacheMapServiceName = name;
    }

    public ServiceName getConnectionCacheMapServiceName() {
        return this.connectionCacheMapServiceName;
    }

    public void createService() {
    }

    public void startService() throws Exception {
        this.mJndiFinderService = (JndiFinder)((Object)ServiceManagerFactory.getService(this.mJndiFinderServiceName));
        try {
            this.mtFactory = (TopicConnectionFactory)this.mJndiFinderService.lookup(this.connectionFactoryName);
        }
        catch (NamingException e) {
            throw new ServiceException("00013", "Fail to lookup.", e);
        }
        if (this.connectionCacheMapServiceName == null) {
            this.mtConn = this.mtFactory.createTopicConnection();
        } else {
            this.connectionCache = (CacheMap)ServiceManagerFactory.getServiceObject(this.connectionCacheMapServiceName);
            this.connectionCache.put(this.connectionKey, this.mtFactory.createTopicConnection());
        }
    }

    public void stopService() {
        if (this.connectionCache != null) {
            this.connectionCache.remove(this.connectionKey);
            this.connectionCache = null;
        }
    }

    public void destory() {
        this.mJndiFinderService = null;
    }

    public TransactionResource makeResource(String key) throws JMSException {
        TopicSession tSession = null;
        TopicConnection con = null;
        try {
            if (this.mtConn == null && this.connectionCache != null) {
                con = (TopicConnection)this.connectionCache.get(this.connectionKey);
                if (con == null) {
                    con = this.mUserName != null ? this.mtFactory.createTopicConnection(this.mUserName, this.mPassword) : this.mtFactory.createTopicConnection();
                    this.connectionCache.put(this.connectionKey, con);
                }
            } else {
                con = this.mtConn;
            }
            tSession = con.createTopicSession(this.mTransanctionMode, this.mAckMode);
        }
        catch (JMSException e) {
            try {
                this.mtFactory = (TopicConnectionFactory)this.mJndiFinderService.lookup(this.connectionFactoryName);
            }
            catch (NamingException e2) {
                throw new ServiceException("00013", "Fail to lookup key = " + this.connectionFactoryName, e2);
            }
            if (this.mtConn == null && this.connectionCache != null) {
                con = (TopicConnection)this.connectionCache.get(this.connectionKey);
                if (con == null) {
                    con = this.mUserName != null ? this.mtFactory.createTopicConnection(this.mUserName, this.mPassword) : this.mtFactory.createTopicConnection();
                    this.connectionCache.put(this.connectionKey, con);
                    this.connectionCache.getCachedReference(this.connectionKey).addCacheRemoveListener(this);
                }
            } else {
                con = this.mtConn;
            }
            tSession = con.createTopicSession(this.mTransanctionMode, this.mAckMode);
        }
        TopicTransanctionResource tranObj = new TopicTransanctionResource(con, tSession);
        return tranObj;
    }

    public void setAcknowledgeMode(int mode) {
        if (mode == 1 || mode == 2 || mode == 3) {
            this.mAckMode = mode;
        }
    }

    public int getAcknowledgeMode() {
        return this.mAckMode;
    }

    public void setTransanctionMode(boolean mode) {
        this.mTransanctionMode = mode;
    }

    public boolean getTransanctionMode() {
        return this.mTransanctionMode;
    }

    public void removed(CachedReference ref) {
        Connection con = (Connection)ref.get();
        if (con != null) {
            try {
                con.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public void setUserName(String userName) {
        this.mUserName = userName;
    }
}

