/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.keepalive.QueryKeepAlive;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.mail.MailSender;
import jp.ossc.nimbus.service.mail.MailSenderFactory;
import jp.ossc.nimbus.service.mail.MailSenderOperator;
import jp.ossc.nimbus.service.mail.SenderFactoryCallBack;
import jp.ossc.nimbus.service.mail.SimpleMailSenderFactoryServiceMBean;
import jp.ossc.nimbus.service.smtpchecker.SmtpKeepAliveChecker;
import jp.ossc.nimbus.util.CsvArrayList;
import jp.ossc.nimbus.util.StringOperator;

public class SimpleMailSenderFactoryService
extends ServiceBase
implements MailSenderFactory,
SimpleMailSenderFactoryServiceMBean,
SenderFactoryCallBack {
    protected boolean mIsRoundrobin = false;
    protected Hashtable mCheckerNameHash = new Hashtable();
    protected String mReturnPath = null;
    protected String mReplyTo = null;
    protected String mMailer = null;
    protected String mMimeVersion = null;
    protected String mTransferEncoding = null;
    protected String mContentType = null;
    protected String mEncoding = null;
    protected boolean mNotSendAnywhere = false;
    protected String mSendingTo = null;
    protected volatile int mRetryMax = 10;
    protected volatile long mRetryInterval = 500L;
    protected String mConnectionTimeOut = null;
    protected String mSendTimeOut = null;
    protected ServiceName mKeepAliveServiceName = null;
    protected String mClassName = null;
    protected String mConvertString = null;
    protected List mConvertStringList = null;
    protected ServiceName mLoggerName = null;
    protected Logger mLogger = null;
    QueryKeepAlive mKeepAlive = null;
    protected static final String C_HOST_PROP_KRY = "mail.smtp.host";
    protected static final String C_CAMMA = ",";
    protected static final String C_SEMICOLON = ";";
    protected static final String C_CONNECTIONTIMEOUT_PROP_KEY = "mail.smtp.connectiontimeout";
    protected static final String C_SENDTIMEOUT_PROP_KEY = "mail.smtp.timeout";
    protected static final String C_HEADER_RETURN_PATH = "Return-Path";
    protected static final String C_HEADER_XMAILER = "X-Mailer";
    protected static final String C_HEADER_CHARSET = "; charset=";
    protected static final String C_HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String C_HEADER_TRANCEFER_ENCODE = "Content-Transfer-Encoding";
    protected static final String C_HEADER_MIME_VERSION = "Mime-Version";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturnPath(String returnPath) {
        SimpleMailSenderFactoryService simpleMailSenderFactoryService = this;
        synchronized (simpleMailSenderFactoryService) {
            this.mReturnPath = returnPath;
        }
    }

    public void setMailSenderClassName(String clsName) {
        this.mClassName = clsName;
    }

    public void setLogger(Logger logger) {
        this.mLogger = logger;
    }

    public void setKeepAlive(QueryKeepAlive keepAlive) {
        this.mKeepAlive = keepAlive;
    }

    public void startService() throws ServiceException {
        if (this.mLoggerName != null) {
            this.mLogger = (Logger)ServiceManagerFactory.getServiceObject(this.mLoggerName);
        }
        this.mKeepAlive = (QueryKeepAlive)ServiceManagerFactory.getServiceObject(this.mKeepAliveServiceName);
        if (this.mKeepAlive == null) {
            throw new ServiceException("MAILSENDER002", "KeepAliveService don't exist name = " + this.mKeepAliveServiceName);
        }
        CsvArrayList list = new CsvArrayList();
        if (this.mConvertString != null) {
            list.split(this.mConvertString, C_SEMICOLON);
            for (int cnt = 0; cnt < list.size(); ++cnt) {
                String tmp = list.getStr(cnt);
                CsvArrayList cnv = new CsvArrayList();
                cnv.split(tmp, C_CAMMA);
                list.set(cnt, cnv);
            }
        }
        this.mConvertStringList = list;
    }

    public void setConnectionTimeOut(long timeoutMiliSeconds) {
        this.mConnectionTimeOut = new Long(timeoutMiliSeconds).toString();
    }

    public void setSendTimeOut(long timeoutMiliSeconds) {
        this.mSendTimeOut = new Long(timeoutMiliSeconds).toString();
    }

    public String getReturnPath() {
        return this.mReturnPath;
    }

    public void setReplyTo(String replyTo) {
        this.mReplyTo = replyTo;
    }

    public String getReplyTo() {
        return this.mReplyTo;
    }

    public void setMailer(String mailer) {
        this.mMailer = mailer;
    }

    public String getMailer() {
        return this.mMailer;
    }

    public void setContentType(String contentType) {
        CsvArrayList parser = new CsvArrayList();
        try {
            parser.split(contentType, C_CAMMA);
            this.mContentType = parser.getStr(0);
            this.mEncoding = parser.getStr(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentType() {
        SimpleMailSenderFactoryService simpleMailSenderFactoryService = this;
        synchronized (simpleMailSenderFactoryService) {
            return this.mContentType + C_CAMMA + this.mEncoding;
        }
    }

    public void setTransferEncoding(String transferEncode) {
        this.mTransferEncoding = transferEncode;
    }

    public String getTransferEncoding() {
        return this.mTransferEncoding;
    }

    public void setMimeVersion(String mimeVersion) {
        this.mMimeVersion = mimeVersion;
    }

    public String getMimeVersion() {
        return this.mMimeVersion;
    }

    public void setNotSending(String sendToAdr) {
        this.mNotSendAnywhere = true;
        this.mSendingTo = sendToAdr;
    }

    public void unsetNotSending() {
        this.mNotSendAnywhere = false;
        this.mSendingTo = null;
    }

    public boolean isNotSendingStatus() {
        return this.mNotSendAnywhere;
    }

    public void setRetryMax(int retryCnt) {
        this.mRetryMax = retryCnt;
    }

    public int getRetryMax() {
        return this.mRetryMax;
    }

    public void setRetryIntervalMiliSeconds(long milisecs) {
        this.mRetryInterval = milisecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRetryIntervalMiliSeconds() {
        Hashtable hashtable = this.mCheckerNameHash;
        synchronized (hashtable) {
            return this.mRetryInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsingCheckerServiceNames(ServiceName[] serviceNames) {
        Hashtable hashtable = this.mCheckerNameHash;
        synchronized (hashtable) {
            this.mCheckerNameHash.clear();
            for (int cnt = 0; cnt < serviceNames.length; ++cnt) {
                this.mCheckerNameHash.put(serviceNames[cnt], serviceNames[cnt]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceName[] getUsingCheckerServiceNames() {
        ServiceName[] ret = null;
        Hashtable hashtable = this.mCheckerNameHash;
        synchronized (hashtable) {
            ret = new ServiceName[this.mCheckerNameHash.size()];
            int cnt = 0;
            Enumeration enumeration = this.mCheckerNameHash.keys();
            while (enumeration.hasMoreElements()) {
                ret[cnt] = (ServiceName)enumeration.nextElement();
                ++cnt;
            }
        }
        return ret;
    }

    public void setUseRoudRobin(boolean isRoundrobin) {
        this.mIsRoundrobin = isRoundrobin;
    }

    public boolean isUseRoudRobin() {
        return this.mIsRoundrobin;
    }

    public void setKeepAliveServiceName(ServiceName name) {
        this.mKeepAliveServiceName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceName sendSmtp(MailSenderOperator op) throws ServiceException {
        if (op.getTo() == null || op.getFrom() == null || op.getBody() == null) {
            throw new ServiceException("MAILSENDER010", "Parameter is invalid");
        }
        long retryCount = 0L;
        boolean ret = false;
        ServiceName sendServer = null;
        while ((long)this.mRetryMax >= retryCount) {
            CsvArrayList serverList = null;
            Hashtable hashtable = this.mCheckerNameHash;
            synchronized (hashtable) {
                serverList = this.mIsRoundrobin ? (this.mCheckerNameHash.size() == 0 ? this.mKeepAlive.getRoundrobinAry() : this.mKeepAlive.getRoundrobinAry(this.mCheckerNameHash)) : (this.mCheckerNameHash.size() == 0 ? this.mKeepAlive.getPriolityAry() : this.mKeepAlive.getPriolityAry(this.mCheckerNameHash));
            }
            for (int cnt = 0; cnt < serverList.size(); ++cnt) {
                SmtpKeepAliveChecker info = null;
                Object value = serverList.get(cnt);
                if (value instanceof ServiceName) {
                    info = (SmtpKeepAliveChecker)ServiceManagerFactory.getServiceObject((ServiceName)value);
                } else if (value instanceof SmtpKeepAliveChecker) {
                    info = (SmtpKeepAliveChecker)value;
                }
                try {
                    ret = this.send(info, op);
                }
                catch (MessagingException e) {
                    if (this.mLogger != null) {
                        this.mLogger.write("MAIL000001", e);
                    }
                    if ((long)this.mRetryMax <= retryCount && cnt == serverList.size() - 1) {
                        throw new ServiceException("MAILSENDER202", "MailSend Error ", e);
                    }
                    ret = false;
                }
                if (ret) {
                    sendServer = (ServiceName)serverList.get(cnt);
                    break;
                }
                this.mKeepAlive.updateTbl((ServiceName)serverList.get(cnt), false);
            }
            if (ret) break;
            if (this.mRetryMax != 0) {
                ++retryCount;
            }
            try {
                Thread.sleep(this.mRetryInterval);
            }
            catch (InterruptedException e) {}
        }
        if (sendServer == null) {
            if (this.mLogger != null) {
                this.mLogger.write("MAIL000003");
            }
            throw new ServiceException("MAILSENDER203", "MailSend Error NotFound");
        }
        return sendServer;
    }

    protected String[] toArrayOfTo(String toStr) {
        ArrayList<String> list = new ArrayList<String>();
        CsvArrayList parser = new CsvArrayList();
        parser.split(toStr, C_SEMICOLON);
        for (int i = 0; i < parser.size(); ++i) {
            String to = parser.getStr(i).trim();
            if (to.length() <= 0) continue;
            list.add(to);
        }
        return list.toArray(new String[0]);
    }

    private String convBody(String input) {
        String tmp = input;
        for (int cnt = 0; cnt < this.mConvertStringList.size(); ++cnt) {
            CsvArrayList cnvList = (CsvArrayList)this.mConvertStringList.get(cnt);
            tmp = StringOperator.replaceString(tmp, cnvList.getStr(0), cnvList.getStr(1));
        }
        return tmp;
    }

    protected boolean send(SmtpKeepAliveChecker info, MailSenderOperator op) throws MessagingException {
        String host = info.getHostIp();
        Properties props = new Properties();
        props.put(C_HOST_PROP_KRY, host);
        if (this.mConnectionTimeOut != null) {
            props.put(C_CONNECTIONTIMEOUT_PROP_KEY, this.mConnectionTimeOut);
        }
        if (this.mSendTimeOut != null) {
            props.put(C_SENDTIMEOUT_PROP_KEY, this.mSendTimeOut);
        }
        Session session = Session.getInstance((Properties)props);
        MimeMessage msg = new MimeMessage(session);
        try {
            CsvArrayList ps = new CsvArrayList();
            int num = ps.split(op.getFrom(), C_SEMICOLON);
            if (!this.mNotSendAnywhere) {
                if (num < 2) {
                    msg.setFrom((Address)new InternetAddress(op.getFrom()));
                } else {
                    msg.setFrom((Address)new InternetAddress(ps.getStr(0), ps.getStr(1), this.mEncoding));
                }
                String[] array = this.toArrayOfTo(op.getTo());
                for (int i = 0; i < array.length; ++i) {
                    msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(array[i]));
                }
            } else {
                msg.setFrom((Address)new InternetAddress(this.mSendingTo));
                msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.mSendingTo));
            }
            msg.setSubject(op.getSubject(), this.mEncoding);
            String body = this.convBody(op.getBody());
            msg.setText(body, this.mEncoding);
            Address[] replyTo = new Address[]{new InternetAddress(this.mReplyTo)};
            msg.setReplyTo(replyTo);
            msg.setHeader(C_HEADER_RETURN_PATH, this.mReturnPath);
            msg.setHeader(C_HEADER_XMAILER, this.mMailer);
            String contentType = this.mContentType + C_HEADER_CHARSET + this.mEncoding;
            msg.setHeader(C_HEADER_CONTENT_TYPE, contentType);
            msg.setHeader(C_HEADER_TRANCEFER_ENCODE, this.mTransferEncoding);
            msg.setSentDate(new Date());
            if (this.mMimeVersion != null) {
                msg.addHeader(C_HEADER_MIME_VERSION, this.mMimeVersion);
            }
            msg.saveChanges();
            if (this.mLogger != null) {
                this.mLogger.write("MAIL000004");
            }
        }
        catch (Exception ex) {
            if (this.mLogger != null) {
                this.mLogger.write("MAIL000002", ex);
            }
            throw new ServiceException("MAILSENDER201", "MailSend Environment invalid ", ex);
        }
        Transport.send((Message)msg);
        if (this.mLogger != null) {
            this.mLogger.write("MAIL000005");
        }
        return true;
    }

    public MailSender createMailSender() {
        Class<?> cls = null;
        MailSenderOperator ret = null;
        try {
            cls = Class.forName(this.mClassName, true, NimbusClassLoader.getInstance());
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("MAILSENDER101", "ClassNotFoundException clsname = " + this.mClassName, e);
        }
        try {
            ret = (MailSenderOperator)cls.newInstance();
        }
        catch (InstantiationException e) {
            throw new ServiceException("MAILSENDER102", "InstantiationException clsname = " + this.mClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("MAILSENDER103", "IllegalAccessException clsname = " + this.mClassName, e);
        }
        ret.setFactory(this);
        return (MailSender)((Object)ret);
    }

    public void setConvertString(String cnvStr) {
        this.mConvertString = cnvStr;
    }

    public void setLoggerServiceName(ServiceName name) {
        this.mLoggerName = name;
    }
}

