/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import jp.ossc.nimbus.service.jms.JMSConnectionCreateException;
import jp.ossc.nimbus.service.jms.JMSConnectionFactoryService;

public class JMSQueueConnectionFactoryService
extends JMSConnectionFactoryService {
    public synchronized Connection getConnection(String user, String pwd) throws JMSConnectionCreateException {
        if (this.connectionFactory == null) {
            throw new JMSConnectionCreateException("ConnectionFactory is null.");
        }
        QueueConnection con = null;
        if (this.isSingleConnection) {
            if (this.connectionCache != null) {
                con = (Connection)this.connectionCache.get(this.connectionKey);
                if (con != null) {
                    return con;
                }
            } else if (this.connection != null) {
                return this.connection;
            }
        }
        try {
            con = user != null ? ((QueueConnectionFactory)this.connectionFactory).createQueueConnection(user, pwd) : ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
            if (this.isConnectionManagement) {
                this.connections.add(con);
            }
        }
        catch (JMSException e) {
            throw new JMSConnectionCreateException(e);
        }
        if (this.isSingleConnection && con != null) {
            if (this.connectionCache != null) {
                this.connectionCache.put(this.connectionKey, con);
                this.connectionCache.getCachedReference(this.connectionKey).addCacheRemoveListener(this);
            } else {
                this.connection = con;
            }
        }
        return con;
    }
}

