/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ioccall;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.UnitOfWork;
import jp.ossc.nimbus.ioc.ejb.command.SLSBCommandRemote;
import jp.ossc.nimbus.ioc.ejb.facade.SLSBFacadeRemote;
import jp.ossc.nimbus.ioc.ejb.unitofwork.SLSBUnitOfWorkRemote;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.ejb.EJBFactory;
import jp.ossc.nimbus.service.ioccall.DefaultFacadeCallServiceMBean;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.jmsqueue.QueueTransanctionResource;

public class DefaultFacadeCallService
extends ServiceBase
implements DefaultFacadeCallServiceMBean,
FacadeCaller {
    private ServiceName mEJBFactoryServiceName = null;
    private ServiceName mUnitOfWorkEJBFactoryServiceName = null;
    private ServiceName mCommandEJBFactoryServiceName = null;
    private EJBFactory mEjbFactory = null;
    private EJBFactory mUnitOfWorkEjbFactory = null;
    private EJBFactory mCommandEjbFactory = null;
    private ServiceName mJndiFinderServiceName = null;
    private JndiFinder mJndiFinder = null;
    private ServiceName mResourceFactoryServiceName = null;
    private ResourceFactory mResourceFactory = null;
    private String mQueueName = null;
    private String deliveryModeStr = "PERSISTENT";
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private String facadeEjbName = "";

    public void startService() {
        if (this.mEJBFactoryServiceName != null) {
            this.mEjbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.mEJBFactoryServiceName);
        }
        if (this.mResourceFactoryServiceName != null) {
            this.mResourceFactory = (ResourceFactory)ServiceManagerFactory.getServiceObject(this.mResourceFactoryServiceName);
        }
        if (this.mJndiFinderServiceName != null) {
            this.mJndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.mJndiFinderServiceName);
        }
        if (this.mUnitOfWorkEJBFactoryServiceName != null) {
            this.mUnitOfWorkEjbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.mUnitOfWorkEJBFactoryServiceName);
        }
        if (this.mCommandEJBFactoryServiceName != null) {
            this.mCommandEjbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.mCommandEJBFactoryServiceName);
        }
        if (this.mEjbFactory == null && this.mResourceFactory == null && this.mJndiFinder == null && this.mUnitOfWorkEjbFactory == null && this.mCommandEjbFactory == null) {
            throw new ServiceException("DefaultFacadeCallService030", "Effective service is not found. ServiceName may not be defined.");
        }
    }

    public void stopService() {
        this.mEjbFactory = null;
        this.mResourceFactory = null;
        this.mJndiFinder = null;
    }

    public void setQueueFinderServiceName(ServiceName name) {
        this.mJndiFinderServiceName = name;
    }

    public ServiceName getQueueFinderServiceName() {
        return this.mJndiFinderServiceName;
    }

    public void setQueueSessionFactoryServiceName(ServiceName name) {
        this.mResourceFactoryServiceName = name;
    }

    public ServiceName getQueueSessionFactoryServiceName() {
        return this.mResourceFactoryServiceName;
    }

    public void setEjbFactoryServieName(ServiceName name) {
        this.mEJBFactoryServiceName = name;
    }

    public ServiceName getEjbFactoryServieName() {
        return this.mEJBFactoryServiceName;
    }

    public void setDeliveryMode(String mode) {
        if ("PERSISTENT".equals(mode)) {
            this.deliveryMode = 2;
        } else if ("NON_PERSISTENT".equals(mode)) {
            this.deliveryMode = 1;
        } else {
            throw new IllegalArgumentException(mode);
        }
        this.deliveryModeStr = mode;
    }

    public String getDeliveryMode() {
        return this.deliveryModeStr;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setTimeToLive(long millis) {
        this.timeToLive = millis;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void unsyncFacadeCall(FacadeValue value) {
        TransactionResource res = null;
        try {
            res = this.mResourceFactory.makeResource("");
        }
        catch (Exception e) {
            throw new ServiceException("DefaultFacadeCallService021", "Exception", e);
        }
        QueueSession qs = (QueueSession)res.getObject();
        ObjectMessage msg = null;
        try {
            msg = qs.createObjectMessage();
            msg.setObject((Serializable)value);
            Queue q = null;
            q = this.mQueueName == null ? (Queue)this.mJndiFinder.lookup() : (Queue)this.mJndiFinder.lookup(this.mQueueName);
            QueueSender qsender = null;
            qsender = qs.createSender(q);
            qsender.send((Message)msg, this.deliveryMode, this.priority, this.timeToLive);
        }
        catch (JMSException e4) {
            throw new ServiceException("DefaultFacadeCallService022", "JMSException", e4);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService023", "NamingException", e);
        }
        finally {
            try {
                res.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void unsyncFacadeCall(FacadeValue[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.unsyncFacadeCall(values[i]);
        }
    }

    public FacadeValue[] syncParallelFacadeCall(FacadeValue[] values) {
        return this.syncParallelFacadeCall(values, 0L);
    }

    public FacadeValue[] syncParallelFacadeCall(FacadeValue[] values, long timeout) {
        QueueTransanctionResource res = null;
        try {
            res = (QueueTransanctionResource)this.mResourceFactory.makeResource("");
            QueueConnection connection = res.getConnectionObject();
            connection.start();
        }
        catch (Exception e) {
            throw new ServiceException("DefaultFacadeCallService021", "Exception", e);
        }
        QueueSession qs = (QueueSession)res.getObject();
        ObjectMessage msg = null;
        try {
            TemporaryQueue replyQueue = qs.createTemporaryQueue();
            Queue q = null;
            q = this.mQueueName == null ? (Queue)this.mJndiFinder.lookup() : (Queue)this.mJndiFinder.lookup(this.mQueueName);
            QueueSender qsender = qs.createSender(q);
            for (int i = 0; i < values.length; ++i) {
                msg = qs.createObjectMessage();
                msg.setJMSReplyTo((Destination)replyQueue);
                msg.setObject((Serializable)values[i]);
                qsender.send((Message)msg, this.deliveryMode, this.priority, this.timeToLive);
            }
            QueueReceiver receiver = qs.createReceiver((Queue)replyQueue);
            FacadeValue[] result = new FacadeValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                ObjectMessage replyMessage = (ObjectMessage)receiver.receive(timeout);
                if (replyMessage == null) continue;
                Serializable ret = replyMessage.getObject();
                if (ret instanceof RuntimeException) {
                    throw (RuntimeException)ret;
                }
                result[i] = (FacadeValue)ret;
            }
            FacadeValue[] facadeValueArray = result;
            return facadeValueArray;
        }
        catch (JMSException e4) {
            throw new ServiceException("DefaultFacadeCallService022", "JMSException", e4);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService023", "NamingException", e);
        }
        finally {
            try {
                res.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public FacadeValue syncFacadeCall(FacadeValue value) {
        SLSBFacadeRemote remoteObj = null;
        try {
            remoteObj = (SLSBFacadeRemote)this.mEjbFactory.get(this.facadeEjbName);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService001", "NamingException", e);
        }
        catch (CreateException e) {
            throw new ServiceException("DefaultFacadeCallService002", "CreateException", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("DefaultFacadeCallService003", "NoSuchMethodException", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("DefaultFacadeCallService004", "IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("DefaultFacadeCallService005", "InvocationTargetException", e);
        }
        FacadeValue ret = null;
        try {
            ret = remoteObj.invokeFacade(value);
        }
        catch (RemoteException e1) {
            throw new ServiceException("DefaultFacadeCallService010", "RemoteException", e1.detail);
        }
        return ret;
    }

    public UnitOfWork syncUnitOfWorkCall(UnitOfWork value) {
        SLSBUnitOfWorkRemote remoteObj = null;
        try {
            remoteObj = (SLSBUnitOfWorkRemote)this.mUnitOfWorkEjbFactory.get("");
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService001", "NamingException", e);
        }
        catch (CreateException e) {
            throw new ServiceException("DefaultFacadeCallService002", "CreateException", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("DefaultFacadeCallService003", "NoSuchMethodException", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("DefaultFacadeCallService004", "IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("DefaultFacadeCallService005", "InvocationTargetException", e);
        }
        UnitOfWork ret = null;
        try {
            ret = remoteObj.invokeUnitOfWork(value);
        }
        catch (RemoteException e1) {
            throw new ServiceException("DefaultFacadeCallService010", "RemoteException", e1.detail);
        }
        return ret;
    }

    public void setQueueName(String queueName) {
        this.mQueueName = queueName;
    }

    public String getQueueName() {
        return this.mQueueName;
    }

    public void setUnitOfWorkEjbFactoryServieName(ServiceName name) {
        this.mUnitOfWorkEJBFactoryServiceName = name;
    }

    public void setCommandEjbFactoryServieName(ServiceName name) {
        this.mCommandEJBFactoryServiceName = name;
    }

    public void setFacadeEjbName(String name) {
        this.facadeEjbName = name;
    }

    public String getFacadeEjbName() {
        return this.facadeEjbName;
    }

    public Command syncCommandCall(Command value) {
        SLSBCommandRemote remoteObj = null;
        try {
            remoteObj = (SLSBCommandRemote)this.mCommandEjbFactory.get("");
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService001", "NamingException", e);
        }
        catch (CreateException e) {
            throw new ServiceException("DefaultFacadeCallService002", "CreateException", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("DefaultFacadeCallService003", "NoSuchMethodException", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("DefaultFacadeCallService004", "IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("DefaultFacadeCallService005", "InvocationTargetException", e);
        }
        Command ret = null;
        try {
            ret = remoteObj.invokeCommand(value);
        }
        catch (RemoteException e1) {
            throw new ServiceException("DefaultFacadeCallService010", "RemoteException", e1.detail);
        }
        return ret;
    }

    public void setEJBFactory(EJBFactory ejbFactory) {
        this.mEjbFactory = ejbFactory;
    }

    public void setCommandEJBFactory(EJBFactory commandEjbFactory) {
        this.mCommandEjbFactory = commandEjbFactory;
    }

    public void setUnitOfWorkEjbFactory(EJBFactory unitOfWorkEjbFactory) {
        this.mUnitOfWorkEjbFactory = unitOfWorkEjbFactory;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.mJndiFinder = jndiFinder;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.mResourceFactory = resourceFactory;
    }
}

