/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import jp.ossc.nimbus.service.graph.AbstractGraphCreatorService;
import jp.ossc.nimbus.service.graph.DefaultXYGraphCreatorServiceMBean;
import jp.ossc.nimbus.service.graph.XYGraphCreator;
import jp.ossc.nimbus.util.CsvArrayList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.Series;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DefaultXYGraphCreatorService
extends AbstractGraphCreatorService
implements XYGraphCreator,
DefaultXYGraphCreatorServiceMBean {
    protected String xLabel = "";
    protected String yLabel = "";
    protected int imageWidth = 800;
    protected int imageHeight = 800;
    protected int xIndex = 0;
    protected int startIndex = 0;
    protected int endIndex = -1;
    protected int samplingInterval = 0;
    protected Properties indexAndDataLabelMapping;
    protected TreeMap indexAndDataLabelMap;

    public void setXLabel(String label) {
        this.xLabel = label;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setYLabel(String label) {
        this.yLabel = label;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setImageWidth(int w) {
        this.imageWidth = w;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageHeight(int h) {
        this.imageHeight = h;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setStartIndex(int index) {
        this.startIndex = index;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setEndIndex(int index) {
        this.endIndex = index;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setSamplingInterval(int index) {
        this.samplingInterval = index;
    }

    public int getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setXIndex(int index) {
        this.xIndex = index;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public void setIndexAndDataLabelMapping(Properties mapping) {
        this.indexAndDataLabelMapping = mapping;
    }

    public Properties getIndexAndDataLabelMapping() {
        return this.indexAndDataLabelMapping;
    }

    public void createService() throws Exception {
        super.createService();
        this.indexAndDataLabelMap = new TreeMap();
    }

    public void startService() throws Exception {
        super.startService();
        if (this.indexAndDataLabelMapping == null || this.indexAndDataLabelMapping.size() == 0) {
            throw new IllegalArgumentException("indexAndDataLabelMapping is null");
        }
        Iterator<Object> indexs = this.indexAndDataLabelMapping.keySet().iterator();
        while (indexs.hasNext()) {
            String indexStr = (String)indexs.next();
            int index = Integer.parseInt(indexStr);
            this.indexAndDataLabelMap.put(new Integer(index), this.indexAndDataLabelMapping.getProperty(indexStr));
        }
    }

    public void stopService() throws Exception {
        this.indexAndDataLabelMap.clear();
        super.stopService();
    }

    protected JFreeChart createGraph(String key, Dataset ds) throws Exception {
        JFreeChart chart = this.createXYGraph(key, ds);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setBackgroundPaint((Paint)Color.lightGray);
        xyplot.setDomainGridlinePaint((Paint)Color.white);
        xyplot.setRangeGridlinePaint((Paint)Color.white);
        xyplot.setDomainCrosshairVisible(true);
        xyplot.setRangeCrosshairVisible(true);
        XYItemRenderer xyitemrenderer = xyplot.getRenderer();
        if (xyitemrenderer instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)xyitemrenderer;
            xylineandshaperenderer.setBaseShapesVisible(false);
        }
        return chart;
    }

    protected JFreeChart createXYGraph(String key, Dataset dataset) throws Exception {
        return ChartFactory.createXYLineChart((String)this.getGraphTitle(), (String)this.getXLabel(), (String)this.getYLabel(), (XYDataset)((XYDataset)dataset), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    }

    public JFreeChart createGraph(String key, int startIndex, int endIndex, int interval) throws Exception {
        Dataset ds = this.createDataset(key, startIndex, endIndex, interval);
        if (ds == null) {
            return null;
        }
        return this.createGraph(key, ds);
    }

    protected Dataset createDataset(String key, InputStreamReader reader) throws Exception {
        return this.createDataset(key, reader, this.startIndex, this.endIndex, this.samplingInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset createDataset(String key, int startIndex, int endIndex, int interval) throws Exception {
        FileInputStream fis = this.getInputFileInputStream(key);
        Dataset dataset = null;
        try {
            dataset = this.createDataset(key, this.encoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, this.encoding), startIndex, endIndex, interval);
        }
        finally {
            fis.close();
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dataset createDataset(String key, InputStreamReader reader, int startIndex, int endIndex, int samplingInterval) throws Exception {
        int i;
        Dataset ds = this.createNewDataset(key);
        if (ds == null) {
            return null;
        }
        if (this.indexAndDataLabelMap == null || this.indexAndDataLabelMap.size() == 0) {
            return null;
        }
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        int count = 0;
        int interval = 0;
        CsvArrayList csv = new CsvArrayList();
        Series[] seriesArray = null;
        Integer[] colIndexs = this.indexAndDataLabelMap.keySet().toArray(new Integer[this.indexAndDataLabelMap.size()]);
        while ((line = br.readLine()) != null) {
            try {
                if (count < startIndex) continue;
                if (endIndex > 0 && count > endIndex) break;
                if (samplingInterval > 0) {
                    if (++interval != 1 && interval <= samplingInterval) continue;
                    if (interval != 1) {
                        interval = 0;
                    }
                }
                csv.split(line);
                if (seriesArray == null) {
                    seriesArray = new Series[colIndexs.length];
                    for (i = 0; i < seriesArray.length; ++i) {
                        Integer colIndex = colIndexs[i];
                        seriesArray[i] = this.createNewSeries(key, (String)this.indexAndDataLabelMap.get(colIndex));
                    }
                }
                if (csv.size() <= this.xIndex) continue;
                String xValue = (String)csv.get(this.xIndex);
                for (int i2 = 0; i2 < seriesArray.length; ++i2) {
                    if (csv.size() <= colIndexs[i2]) continue;
                    Series series = seriesArray[i2];
                    String yValue = (String)csv.get(colIndexs[i2]);
                    this.addData(key, series, xValue, yValue);
                }
            }
            finally {
                ++count;
            }
        }
        if (seriesArray != null) {
            for (i = 0; i < seriesArray.length; ++i) {
                this.addSeries(key, (Series)seriesArray[i], ds);
            }
        }
        return ds;
    }

    protected Dataset createNewDataset(String key) throws Exception {
        return new XYSeriesCollection();
    }

    protected Series createNewSeries(String key, String label) throws Exception {
        return new XYSeries((Comparable)((Object)label));
    }

    protected void addData(String key, Series series, String x, String y) throws Exception {
        XYSeries xySeries = (XYSeries)series;
        xySeries.add(Double.parseDouble(x), Double.parseDouble(y));
    }

    protected void addSeries(String key, Series series, Dataset ds) throws Exception {
        XYSeriesCollection collection = (XYSeriesCollection)ds;
        collection.addSeries((XYSeries)series);
    }

    protected Image createImage(String key, JFreeChart chart) throws Exception {
        return chart.createBufferedImage(this.imageWidth, this.imageHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image createImage(String key, int startIndex, int endIndex, int samplingInterval) throws Exception {
        if (this.keyAndDataFileMapping == null || !this.keyAndDataFileMapping.containsKey(key)) {
            return null;
        }
        String filePath = this.keyAndDataFileMapping.getProperty(key);
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        Dataset dataset = null;
        try {
            dataset = this.createDataset(key, this.encoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, this.encoding), startIndex, endIndex, samplingInterval);
        }
        finally {
            fis.close();
        }
        return this.createImage(key, this.createGraph(key, dataset));
    }

    public void saveAsJPEG(String key, String file, float quality, int width, int height) throws Exception {
        int tmpWidth = width > 0 ? width : this.getImageWidth();
        int tmpHeight = height > 0 ? height : this.getImageHeight();
        super.saveAsJPEG(key, file, quality, tmpWidth, tmpHeight);
    }

    public void saveAsPNG(String key, String file, int width, int height) throws Exception {
        int tmpWidth = width > 0 ? width : this.getImageWidth();
        int tmpHeight = height > 0 ? height : this.getImageHeight();
        super.saveAsPNG(key, file, tmpWidth, tmpHeight);
    }
}

