/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.WrappedConnectionFactoryServiceMBean;

public class WrappedConnectionFactoryService
extends ServiceBase
implements WrappedConnectionFactoryServiceMBean,
Serializable {
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private String connectionWrapperClassName;
    private Class connectionWrapperClass;
    private Map connectionWrapperProperties;
    private Map properties;
    static /* synthetic */ Class class$java$sql$Connection;

    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        } else if (this.connectionFactory == null) {
            throw new IllegalArgumentException("Argument : ConnectionFactoryServiceName or ConnectionFactory is null.");
        }
        if (this.getConnectionWrapperClassName() != null) {
            this.connectionWrapperClass = Class.forName(this.getConnectionWrapperClassName(), true, NimbusClassLoader.getInstance());
        }
        if (this.connectionWrapperProperties != null && this.connectionWrapperProperties.size() != 0) {
            this.properties = new HashMap();
            Iterator props = this.connectionWrapperProperties.keySet().iterator();
            while (props.hasNext()) {
                String propName = (String)props.next();
                Object val = this.connectionWrapperProperties.get(propName);
                Property property = PropertyFactory.createProperty(propName);
                this.properties.put(property, val);
            }
        }
    }

    public void stopService() throws Exception {
        this.connectionFactory = null;
        this.connectionWrapperClass = null;
        this.properties = null;
    }

    public Connection getConnection() throws ConnectionFactoryException {
        Connection con = this.connectionFactory.getConnection();
        if (con != null && this.connectionWrapperClass != null) {
            try {
                Constructor constructor = this.connectionWrapperClass.getConstructor(class$java$sql$Connection == null ? (class$java$sql$Connection = WrappedConnectionFactoryService.class$("java.sql.Connection")) : class$java$sql$Connection);
                con = (Connection)constructor.newInstance(con);
                if (this.properties != null) {
                    Iterator props = this.properties.keySet().iterator();
                    while (props.hasNext()) {
                        Property prop = (Property)props.next();
                        Object val = this.properties.get(prop);
                        prop.setProperty(con, val);
                    }
                }
            }
            catch (InstantiationException e) {
                throw new ConnectionFactoryException(e);
            }
            catch (IllegalAccessException e) {
                throw new ConnectionFactoryException(e);
            }
            catch (InvocationTargetException e) {
                throw new ConnectionFactoryException(e.getTargetException());
            }
            catch (NoSuchMethodException e) {
                throw new ConnectionFactoryException(e);
            }
            catch (NoSuchPropertyException e) {
                throw new ConnectionFactoryException(e);
            }
        }
        return con;
    }

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setConnectionWrapperClassName(String className) {
        this.connectionWrapperClassName = className;
    }

    public String getConnectionWrapperClassName() {
        return this.connectionWrapperClassName;
    }

    public void setConnectionWrapperProperties(Map prop) {
        this.connectionWrapperProperties = prop;
    }

    public Map getConnectionWrapperProperties() {
        return this.connectionWrapperProperties;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

