/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.javassist;

import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;
import jp.ossc.nimbus.core.AspectTranslator;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.javassist.MethodInterceptorAspectServiceMBean;
import jp.ossc.nimbus.service.aop.javassist.WrappedMethodReflectionCallInvokerService;

public class MethodInterceptorAspectService
extends ServiceBase
implements AspectTranslator,
Invoker,
MethodInterceptorAspectServiceMBean {
    private static final String MODIFIER_PUBLIC = "public";
    private static final String MODIFIER_PROTECTED = "protected";
    private static final String MODIFIER_DEFAULT = "default";
    private static final String MODIFIER_PRIVATE = "private";
    private static final String MODIFIER_FINAL = "final";
    private static final String MODIFIER_STATIC = "static";
    private static final String MODIFIER_SYNCHRONIZED = "synchronized";
    private static final String MODIFIER_ABSTRACT = "abstract";
    private static final String NOT_TRANSFORMABLE_SUFFIX1 = "$nimbus_aop";
    private static final String NOT_TRANSFORMABLE_SUFFIX2 = "$";
    private static final String INTERCEPTOR_CHAIN_CLASS_NAME = (class$jp$ossc$nimbus$service$aop$InterceptorChain == null ? (class$jp$ossc$nimbus$service$aop$InterceptorChain = MethodInterceptorAspectService.class$("jp.ossc.nimbus.service.aop.InterceptorChain")) : class$jp$ossc$nimbus$service$aop$InterceptorChain).getName();
    private static final String INTERCEPTOR_CHAIN_IMPL_CLASS_NAME = (class$jp$ossc$nimbus$service$aop$DefaultThreadLocalInterceptorChain == null ? (class$jp$ossc$nimbus$service$aop$DefaultThreadLocalInterceptorChain = MethodInterceptorAspectService.class$("jp.ossc.nimbus.service.aop.DefaultThreadLocalInterceptorChain")) : class$jp$ossc$nimbus$service$aop$DefaultThreadLocalInterceptorChain).getName();
    private static final String INVOCATION_CONTEXT_CLASS_NAME = (class$jp$ossc$nimbus$service$aop$javassist$WrappedMethodInvocationContext == null ? (class$jp$ossc$nimbus$service$aop$javassist$WrappedMethodInvocationContext = MethodInterceptorAspectService.class$("jp.ossc.nimbus.service.aop.javassist.WrappedMethodInvocationContext")) : class$jp$ossc$nimbus$service$aop$javassist$WrappedMethodInvocationContext).getName();
    private static final Random random = new Random();
    private Boolean isPublicClass;
    private Boolean isProtectedClass;
    private Boolean isDefaultClass;
    private Boolean isPrivateClass;
    private Boolean isFinalClass;
    private Boolean isStaticClass;
    private Boolean isAbstractClass;
    private String targetClassModifiers;
    private Boolean isPublicMethod;
    private Boolean isProtectedMethod;
    private Boolean isDefaultMethod;
    private Boolean isPrivateMethod;
    private Boolean isFinalMethod;
    private Boolean isStaticMethod;
    private Boolean isSynchronizedMethod;
    private String targetMethodModifiers;
    private String targetClassName;
    private String targetInstanceClassName;
    private String targetMethodName;
    private String[] targetParameterTypes;
    private ServiceName interceptorChainListServiceName;
    private ServiceName invokerServiceName;
    private WrappedMethodReflectionCallInvokerService defaultInvoker;
    private Invoker invoker;
    private String aspectKey;
    private boolean isRegisterVMClassLoader = true;
    private Map classBytes;
    private final Map classPools = new WeakHashMap();
    static /* synthetic */ Class class$jp$ossc$nimbus$service$aop$InterceptorChain;
    static /* synthetic */ Class class$jp$ossc$nimbus$service$aop$DefaultThreadLocalInterceptorChain;
    static /* synthetic */ Class class$jp$ossc$nimbus$service$aop$javassist$WrappedMethodInvocationContext;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Error;
    static /* synthetic */ Class class$java$lang$Throwable;

    public void setTargetClassModifiers(String modifiers) {
        Boolean isPublicClass = null;
        Boolean isProtectedClass = null;
        Boolean isDefaultClass = null;
        Boolean isPrivateClass = null;
        Boolean isFinalClass = null;
        Boolean isStaticClass = null;
        Boolean isAbstractClass = null;
        if (modifiers != null && modifiers.length() != 0) {
            StringTokenizer tokens = new StringTokenizer(modifiers, " ");
            while (tokens.hasMoreTokens()) {
                String modifier = tokens.nextToken();
                if (modifier.endsWith(MODIFIER_PUBLIC)) {
                    isPublicClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_PROTECTED)) {
                    isProtectedClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_DEFAULT)) {
                    isDefaultClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_PRIVATE)) {
                    isPrivateClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_FINAL)) {
                    isFinalClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_STATIC)) {
                    isStaticClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_ABSTRACT)) {
                    isAbstractClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                throw new IllegalArgumentException("Invalid class modifier : " + modifier);
            }
        }
        this.targetClassModifiers = modifiers;
        this.isPublicClass = isPublicClass;
        this.isProtectedClass = isProtectedClass;
        this.isDefaultClass = isDefaultClass;
        this.isPrivateClass = isPrivateClass;
        this.isFinalClass = isFinalClass;
        this.isStaticClass = isStaticClass;
        this.isAbstractClass = isAbstractClass;
    }

    public String getTargetClassModifiers() {
        return this.targetClassModifiers;
    }

    public void setTargetClassName(String name) {
        this.targetClassName = name;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public void setTargetInstanceClassName(String name) {
        this.targetInstanceClassName = name;
    }

    public String getTargetInstanceClassName() {
        return this.targetInstanceClassName;
    }

    public void setTargetMethodModifiers(String modifiers) {
        Boolean isPublicMethod = null;
        Boolean isProtectedMethod = null;
        Boolean isDefaultMethod = null;
        Boolean isPrivateMethod = null;
        Boolean isFinalMethod = null;
        Boolean isStaticMethod = null;
        Boolean isSynchronizedMethod = null;
        if (modifiers != null && modifiers.length() != 0) {
            StringTokenizer tokens = new StringTokenizer(modifiers, " ");
            while (tokens.hasMoreTokens()) {
                String modifier = tokens.nextToken();
                if (modifier.endsWith(MODIFIER_PUBLIC)) {
                    isPublicMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_PROTECTED)) {
                    isProtectedMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_DEFAULT)) {
                    isDefaultMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_PRIVATE)) {
                    isPrivateMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_FINAL)) {
                    isFinalMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_STATIC)) {
                    isStaticMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_SYNCHRONIZED)) {
                    isSynchronizedMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                throw new IllegalArgumentException("Invalid class modifier : " + modifier);
            }
        }
        this.targetMethodModifiers = modifiers;
        this.isPublicMethod = isPublicMethod;
        this.isProtectedMethod = isProtectedMethod;
        this.isDefaultMethod = isDefaultMethod;
        this.isPrivateMethod = isPrivateMethod;
        this.isFinalMethod = isFinalMethod;
        this.isStaticMethod = isStaticMethod;
        this.isSynchronizedMethod = isSynchronizedMethod;
    }

    public String getTargetMethodModifiers() {
        return this.targetMethodModifiers;
    }

    public void setTargetMethodName(String name) {
        this.targetMethodName = name;
    }

    public String getTargetMethodName() {
        return this.targetMethodName;
    }

    public void setTargetParameterTypes(String[] paramTypes) {
        this.targetParameterTypes = paramTypes;
    }

    public String[] getTargetParameterTypes() {
        return this.targetParameterTypes;
    }

    public void setInterceptorChainListServiceName(ServiceName name) {
        this.interceptorChainListServiceName = name;
    }

    public ServiceName getInterceptorChainListServiceName() {
        return this.interceptorChainListServiceName;
    }

    public void setInvokerServiceName(ServiceName name) {
        this.invokerServiceName = name;
    }

    public ServiceName getInvokerServiceName() {
        return this.invokerServiceName;
    }

    public void setRegisterVMClassLoader(boolean isRegister) {
        this.isRegisterVMClassLoader = isRegister;
    }

    public boolean isRegisterVMClassLoader() {
        return this.isRegisterVMClassLoader;
    }

    public void setAspectKey(String key) {
        this.aspectKey = key;
    }

    public String getAspectKey() {
        if (this.aspectKey == null) {
            return this.getServiceName();
        }
        return this.aspectKey;
    }

    public void createService() throws Exception {
        this.classBytes = new WeakHashMap();
    }

    public void startService() throws Exception {
        if (this.getInvokerServiceName() == null) {
            if (this.getDefaultInvokerService() == null) {
                WrappedMethodReflectionCallInvokerService defaultInvoker = new WrappedMethodReflectionCallInvokerService();
                defaultInvoker.create();
                defaultInvoker.start();
                this.setDefaultInvokerService(defaultInvoker);
            } else {
                this.getDefaultInvokerService().start();
            }
            this.setInvokerService(this.getDefaultInvokerService());
        } else {
            this.setInvokerService((Invoker)ServiceManagerFactory.getServiceObject(this.getInvokerServiceName()));
        }
        if (this.isRegisterVMClassLoader) {
            NimbusClassLoader.addVMAspectTranslator(this);
        } else {
            NimbusClassLoader.getInstance().addAspectTranslator(this);
        }
    }

    public void stopService() throws Exception {
        if (this.getInvokerService() == this.getDefaultInvokerService()) {
            this.getDefaultInvokerService().stop();
        }
        NimbusClassLoader.removeVMAspectTranslator(this);
        NimbusClassLoader.getInstance().removeAspectTranslator(this);
        this.classBytes.clear();
    }

    public void destroyService() throws Exception {
        if (this.getInvokerService() == this.getDefaultInvokerService() && this.getDefaultInvokerService() != null) {
            this.getDefaultInvokerService().destroy();
            this.setDefaultInvokerService(null);
        }
        this.classBytes = null;
    }

    private synchronized ClassPool getClassPool() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (this.classPools.containsKey(contextLoader)) {
            return (ClassPool)this.classPools.get(contextLoader);
        }
        ClassPool classPool = new ClassPool(ClassPool.getDefault());
        classPool.appendClassPath((ClassPath)new LoaderClassPath(contextLoader));
        this.classPools.put(contextLoader, classPool);
        return classPool;
    }

    private Map getClassBytes() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (this.classBytes.containsKey(contextLoader)) {
            return (Map)this.classBytes.get(contextLoader);
        }
        HashMap classBytesMap = new HashMap();
        this.classBytes.put(contextLoader, classBytesMap);
        return classBytesMap;
    }

    public synchronized byte[] transform(ClassLoader loader, String className, ProtectionDomain domain, byte[] bytecode) {
        if (this.getState() != 3) {
            return null;
        }
        if (this.targetClassName == null && this.targetInstanceClassName == null) {
            return null;
        }
        if (this.targetClassName != null && !this.targetClassName.equals(className) && !Pattern.matches(this.targetClassName, className)) {
            return null;
        }
        try {
            ClassPool classPool = this.getClassPool();
            CtClass clazz = null;
            if (classPool.find(className) == null) {
                ByteArrayClassPath classPath = new ByteArrayClassPath(className, bytecode);
                classPool.insertClassPath((ClassPath)classPath);
                this.getClassBytes().put(className, bytecode);
                clazz = classPool.get(className);
            } else {
                clazz = classPool.get(className);
                if (this.getClassBytes().containsKey(className) && !this.getClassBytes().get(className).equals(bytecode)) {
                    clazz.detach();
                    clazz = classPool.get(className);
                } else {
                    this.getClassBytes().put(className, bytecode);
                    clazz.defrost();
                }
            }
            if (clazz.isInterface()) {
                return null;
            }
            if (this.targetClassModifiers != null) {
                int modifiers = clazz.getModifiers();
                if (this.isPublicClass != null && Modifier.isPublic((int)modifiers) != this.isPublicClass || this.isProtectedClass != null && Modifier.isProtected((int)modifiers) != this.isProtectedClass || this.isDefaultClass != null && (!Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers) && !Modifier.isPrivate((int)modifiers)) != this.isDefaultClass || this.isPrivateClass != null && Modifier.isPrivate((int)modifiers) != this.isPrivateClass || this.isFinalClass != null && Modifier.isFinal((int)modifiers) != this.isFinalClass || this.isStaticClass != null && Modifier.isStatic((int)modifiers) != this.isStaticClass || this.isAbstractClass != null && Modifier.isAbstract((int)modifiers) != this.isAbstractClass) {
                    return null;
                }
            }
            if (this.targetInstanceClassName != null && !clazz.subtypeOf(classPool.get(this.targetInstanceClassName)) && !this.targetInstanceClassName.equals(className)) {
                return null;
            }
            CtClass transformed = this.addInterceptor(classPool, clazz);
            return transformed == null ? null : transformed.toBytecode();
        }
        catch (CannotCompileException e) {
            System.err.println("Can not compile! : " + className);
            e.printStackTrace();
            return null;
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected CtClass addInterceptor(ClassPool classPool, CtClass clazz) throws NotFoundException, CannotCompileException {
        CtClass result = clazz;
        CtClass target = clazz;
        boolean isTransfer = false;
        HashSet<String> overwrideSignatures = new HashSet<String>();
        do {
            CtMethod[] methods = target.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                CtClass tmp;
                int mod;
                String signature = methods[i].getName() + methods[i].getSignature();
                if (overwrideSignatures.contains(signature)) continue;
                overwrideSignatures.add(signature);
                if (!clazz.equals(target) && (Modifier.isPrivate((int)(mod = methods[i].getModifiers())) || !Modifier.isPublic((int)mod) && !Modifier.isProtected((int)mod) && !clazz.getPackageName().equals(target.getPackageName())) || (tmp = this.addInterceptorForMethod(classPool, result, methods[i])) == null) continue;
                isTransfer = true;
                result = tmp;
            }
        } while ((target = target.getSuperclass()) != null);
        return isTransfer ? result : null;
    }

    protected String createWrappedMethodName(CtClass clazz, String className, String methodName) {
        String name = className.replace('.', '$') + '$' + methodName + MethodInterceptorAspectService.createRandomNumberString() + NOT_TRANSFORMABLE_SUFFIX1;
        CtClass tmpClazz = clazz;
        do {
            CtMethod[] methods = tmpClazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(name)) continue;
                return this.createWrappedMethodName(clazz, className, methodName);
            }
            try {
                tmpClazz = tmpClazz.getSuperclass();
            }
            catch (NotFoundException e) {
                tmpClazz = null;
            }
        } while (tmpClazz != null);
        return name;
    }

    protected String createInterceptorChainFieldName(CtClass clazz, String className, String methodName) {
        String name = className.replace('.', '$') + '$' + methodName + '$' + "InterceptorChain" + MethodInterceptorAspectService.createRandomNumberString() + NOT_TRANSFORMABLE_SUFFIX1;
        try {
            clazz.getField(name);
        }
        catch (NotFoundException e) {
            return name;
        }
        return this.createInterceptorChainFieldName(clazz, className, methodName);
    }

    private static String createRandomNumberString() {
        return String.valueOf(Math.abs(random.nextInt()));
    }

    protected CtClass addInterceptorForMethod(ClassPool classPool, CtClass clazz, CtMethod method) throws NotFoundException, CannotCompileException {
        int modifiers = method.getModifiers();
        if (Modifier.isNative((int)modifiers) || Modifier.isAbstract((int)modifiers)) {
            return null;
        }
        String originalName = method.getName();
        if (originalName.endsWith(NOT_TRANSFORMABLE_SUFFIX1) || originalName.endsWith(NOT_TRANSFORMABLE_SUFFIX2)) {
            return null;
        }
        if (this.targetMethodName != null && !this.targetMethodName.equals(originalName) && !Pattern.matches(this.targetMethodName, originalName)) {
            return null;
        }
        if (this.targetMethodModifiers != null && (this.isPublicMethod != null && Modifier.isPublic((int)modifiers) != this.isPublicMethod || this.isProtectedMethod != null && Modifier.isProtected((int)modifiers) != this.isProtectedMethod || this.isDefaultMethod != null && (!Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers) && !Modifier.isPrivate((int)modifiers)) != this.isDefaultMethod || this.isPrivateMethod != null && Modifier.isPrivate((int)modifiers) != this.isPrivateMethod || this.isFinalMethod != null && Modifier.isFinal((int)modifiers) != this.isFinalMethod || this.isStaticMethod != null && Modifier.isStatic((int)modifiers) != this.isStaticMethod || this.isSynchronizedMethod != null && Modifier.isAbstract((int)modifiers) != this.isSynchronizedMethod)) {
            return null;
        }
        if (this.targetParameterTypes != null) {
            CtClass[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != this.targetParameterTypes.length) {
                return null;
            }
            for (int i = 0; i < this.targetParameterTypes.length; ++i) {
                String paramName = paramTypes[i].getName();
                if (this.targetParameterTypes[i].equals(paramName) || Pattern.matches(this.targetParameterTypes[i], paramName)) continue;
                return null;
            }
        }
        try {
            clazz.stopPruning(true);
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        CtClass decClass = method.getDeclaringClass();
        boolean isDeclaredMethod = decClass.getName().equals(clazz.getName());
        CtClass returnType = method.getReturnType();
        CtMethod callMethod = method;
        if (isDeclaredMethod) {
            callMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            clazz.removeMethod(callMethod);
        } else {
            if (Modifier.isFinal((int)modifiers) || Modifier.isStatic((int)modifiers)) {
                return null;
            }
            callMethod = CtNewMethod.copy((CtMethod)method, (CtClass)clazz, null);
            if (returnType.equals(CtClass.voidType)) {
                callMethod.setBody("super." + method.getName() + "($$);");
            } else {
                callMethod.setBody("return super." + method.getName() + "($$);");
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append("private ");
        if (isStatic) {
            buf.append("static ");
        }
        buf.append("final ").append(INTERCEPTOR_CHAIN_CLASS_NAME).append(' ');
        String fieldName = this.createInterceptorChainFieldName(clazz, clazz.getName(), callMethod.getName());
        buf.append(fieldName);
        buf.append(" = new ").append(INTERCEPTOR_CHAIN_IMPL_CLASS_NAME);
        if (this.getInterceptorChainListServiceName() == null) {
            buf.append("((jp.ossc.nimbus.core.ServiceName)null,");
        } else {
            buf.append("(new jp.ossc.nimbus.core.ServiceName(\"");
            buf.append(this.getInterceptorChainListServiceName().getServiceManagerName()).append("\", \"");
            buf.append(this.getInterceptorChainListServiceName().getServiceName()).append("\"),");
        }
        buf.append("new jp.ossc.nimbus.core.ServiceName(\"");
        if (this.getInvokerServiceName() == null) {
            buf.append(this.getServiceManagerName()).append("\", \"");
            buf.append(this.getServiceName()).append("\"));");
        } else {
            buf.append(this.getInvokerServiceName().getServiceManagerName()).append("\", \"");
            buf.append(this.getInvokerServiceName().getServiceName()).append("\"));");
        }
        CtField field = CtField.make((String)buf.toString(), (CtClass)clazz);
        clazz.addField(field);
        buf.setLength(0);
        CtMethod wrappedMethod = CtNewMethod.copy((CtMethod)callMethod, (CtClass)clazz, null);
        String wrappedName = this.createWrappedMethodName(clazz, clazz.getName(), method.getName());
        callMethod.setName(wrappedName);
        clazz.addMethod(callMethod);
        if (!Modifier.isPublic((int)modifiers)) {
            callMethod.setModifiers(modifiers & 0xFFFFFFF9 | 1);
        }
        buf.append("try{");
        if (!returnType.equals(CtClass.voidType)) {
            buf.append("return ($r)");
        }
        buf.append(fieldName).append(".invokeNext(new ");
        CtClass invocationClass = classPool.get(INVOCATION_CONTEXT_CLASS_NAME);
        buf.append(invocationClass.getName()).append('(');
        if (isStatic) {
            buf.append("null, ");
        } else {
            buf.append("$0, ");
        }
        if (isStatic) {
            buf.append("Class.forName(\"").append(clazz.getName()).append("\")").append(".getDeclaredMethod(\"").append(originalName).append("\",").append(" $sig), ");
            buf.append("Class.forName(\"").append(clazz.getName()).append("\")").append(".getDeclaredMethod(\"").append(wrappedName).append("\",").append(" $sig), $args));}");
        } else {
            buf.append("getClass()").append(".getDeclaredMethod(\"").append(originalName).append("\",").append(" $sig), ");
            buf.append("getClass()").append(".getDeclaredMethod(\"").append(wrappedName).append("\",").append(" $sig), $args));}");
        }
        CtClass[] exceptionTypes = callMethod.getExceptionTypes();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            this.addCatch(buf, exceptionTypes[i], "throw $e;");
        }
        CtClass runtimeExClass = classPool.get((class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = MethodInterceptorAspectService.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).getName());
        this.addCatch(buf, runtimeExClass, "throw $e;");
        CtClass errorClass = classPool.get((class$java$lang$Error == null ? (class$java$lang$Error = MethodInterceptorAspectService.class$("java.lang.Error")) : class$java$lang$Error).getName());
        this.addCatch(buf, errorClass, "throw $e;");
        CtClass thClass = classPool.get((class$java$lang$Throwable == null ? (class$java$lang$Throwable = MethodInterceptorAspectService.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName());
        if (returnType.equals(CtClass.voidType)) {
            this.addCatch(buf, thClass, "$e.printStackTrace();return;");
        } else if (returnType.isPrimitive()) {
            if (returnType.equals(CtClass.booleanType)) {
                this.addCatch(buf, thClass, "$e.printStackTrace();return false;");
            } else {
                this.addCatch(buf, thClass, "{$e.printStackTrace();return (" + returnType.getName() + ")0;}");
            }
        } else {
            this.addCatch(buf, thClass, "{$e.printStackTrace();return (" + returnType.getName() + ")null;}");
        }
        String wrappedName2 = this.createWrappedMethodName(clazz, clazz.getName(), method.getName());
        wrappedMethod.setName(wrappedName2);
        wrappedMethod.setBody(buf.toString());
        clazz.addMethod(wrappedMethod);
        wrappedMethod.setName(originalName);
        return clazz;
    }

    private StringBuffer addCatch(StringBuffer buf, CtClass th, String logic) {
        buf.append("catch(").append(th.getName());
        buf.append(" e").append(NOT_TRANSFORMABLE_SUFFIX1);
        String tmpLogic = logic;
        if (tmpLogic.indexOf("$e") != -1) {
            StringBuffer tmpBuf = new StringBuffer(logic);
            int index = logic.length();
            while ((index = tmpBuf.lastIndexOf("$e", index - 1)) != -1) {
                tmpBuf.replace(index, index + 2, "e$nimbus_aop");
            }
            tmpLogic = tmpBuf.toString();
        }
        buf.append("){").append(tmpLogic).append("}");
        return buf;
    }

    public Object invoke(InvocationContext context) throws Throwable {
        if (this.getInvokerService() == null) {
            return null;
        }
        return this.getInvokerService().invoke(context);
    }

    protected void setInvokerService(Invoker invoker) {
        this.invoker = invoker;
    }

    protected Invoker getInvokerService() {
        return this.invoker;
    }

    protected WrappedMethodReflectionCallInvokerService getDefaultInvokerService() {
        return this.defaultInvoker;
    }

    protected void setDefaultInvokerService(WrappedMethodReflectionCallInvokerService invoker) {
        this.defaultInvoker = invoker;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

