/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.core.DefaultLogMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import jp.ossc.nimbus.core.Utility;
import org.w3c.dom.Element;

public class ServerMetaData
extends MetaData
implements Serializable {
    public static final String SERVER_TAG_NAME = "server";
    private static final String REF_URL_TAG_NAME = "ref-url";
    private static final String REPOSITORY_TAG_NAME = "manager-repository";
    private static final String PROPERTY_EDITORS_TAG_NAME = "property-editors";
    private static final String PROPERTY_EDITOR_TAG_NAME = "property-editor";
    private static final String LOG_TAG_NAME = "log";
    private static final String MESSAGE_TAG_NAME = "message";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String SERVER_PROPERTY_TAG_NAME = "server-property";
    private final Map managers = new HashMap();
    private final Set referenceURL = new HashSet();
    private final Map propertyEditors = new HashMap();
    private final URL myUrl;
    private ServiceNameMetaData repository;
    private ServiceNameMetaData log;
    private ServiceNameMetaData message;
    private DefaultLogMetaData defaultLog;
    private ServiceLoader myLoader;
    private Properties properties = new Properties();

    public ServerMetaData(ServiceLoader loader, URL url) {
        this.myUrl = url;
        this.myLoader = loader;
    }

    public ServiceLoader getServiceLoader() {
        return this.myLoader;
    }

    public ManagerMetaData getManager(String name) {
        return (ManagerMetaData)this.managers.get(name);
    }

    public Collection getManagers() {
        return this.managers.values();
    }

    public void addManager(ManagerMetaData manager) {
        this.managers.put(manager.getName(), manager);
    }

    public Set getReferenceURL() {
        return this.referenceURL;
    }

    public Map getPropertyEditors() {
        return this.propertyEditors;
    }

    public void addPropertyEditor(String type, String editor) {
        this.propertyEditors.put(type, editor);
    }

    public ServiceNameMetaData getRepository() {
        return this.repository;
    }

    public ServiceNameMetaData getLog() {
        return this.log;
    }

    public ServiceNameMetaData getMessage() {
        return this.message;
    }

    public DefaultLogMetaData getDefaultLog() {
        return this.defaultLog;
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void importXML(Element element) throws DeploymentException {
        Element editorsElement;
        Element messageElement;
        Element logElement;
        super.importXML(element);
        if (!element.getTagName().equals(SERVER_TAG_NAME)) {
            throw new DeploymentException("Root tag must be server : " + element.getTagName());
        }
        Iterator refURLElements = ServerMetaData.getChildrenByTagName(element, REF_URL_TAG_NAME);
        while (refURLElements.hasNext()) {
            Element refURLelement = (Element)refURLElements.next();
            String content = ServerMetaData.getElementContent(refURLelement);
            if (content == null || content.length() == 0) continue;
            URL url = null;
            try {
                url = new URL(content);
                url.openConnection();
            }
            catch (MalformedURLException e) {
                url = null;
            }
            catch (IOException e) {
                url = null;
            }
            if (url == null) {
                String urlString = this.myUrl.toString();
                urlString = urlString.substring(0, urlString.lastIndexOf(47) + 1);
                try {
                    url = new URL(urlString + content);
                    url.openConnection();
                }
                catch (MalformedURLException e) {
                    url = null;
                }
                catch (IOException e) {
                    url = null;
                }
                if (url == null) {
                    try {
                        url = Utility.convertServicePathToURL(content);
                    }
                    catch (IllegalArgumentException e) {
                        throw new DeploymentException("ref-url tag is illegal value : " + content);
                    }
                }
            }
            this.referenceURL.add(url);
        }
        Iterator managerElements = ServerMetaData.getChildrenByTagName(element, "manager");
        while (managerElements.hasNext()) {
            ManagerMetaData managerData = new ManagerMetaData(this.myLoader, this);
            managerData.importXML((Element)managerElements.next());
            this.addManager(managerData);
        }
        Element repositoryElement = ServerMetaData.getOptionalChild(element, REPOSITORY_TAG_NAME);
        if (repositoryElement != null) {
            this.repository = new ServiceNameMetaData(this);
            this.repository.importXML(repositoryElement);
        }
        if ((logElement = ServerMetaData.getOptionalChild(element, LOG_TAG_NAME)) != null) {
            this.log = new ServiceNameMetaData(this);
            this.log.importXML(logElement);
        }
        if ((messageElement = ServerMetaData.getOptionalChild(element, MESSAGE_TAG_NAME)) != null) {
            this.message = new ServiceNameMetaData(this);
            this.message.importXML(messageElement);
        }
        Iterator propElements = ServerMetaData.getChildrenByTagName(element, SERVER_PROPERTY_TAG_NAME);
        while (propElements.hasNext()) {
            Element propElement = (Element)propElements.next();
            String serverProp = ServerMetaData.getElementContent(propElement);
            this.properties.setProperty(ServerMetaData.getUniqueAttribute(propElement, NAME_ATTRIBUTE_NAME), serverProp);
        }
        Element defaultLogElement = ServerMetaData.getOptionalChild(element, "default-log");
        if (defaultLogElement != null) {
            this.defaultLog = new DefaultLogMetaData(this);
            this.defaultLog.importXML(defaultLogElement);
        }
        if ((editorsElement = ServerMetaData.getOptionalChild(element, PROPERTY_EDITORS_TAG_NAME)) != null) {
            Iterator editorElements = ServerMetaData.getChildrenByTagName(editorsElement, PROPERTY_EDITOR_TAG_NAME);
            while (editorElements.hasNext()) {
                Element editorElement = (Element)editorElements.next();
                String type = ServerMetaData.getUniqueAttribute(editorElement, TYPE_ATTRIBUTE_NAME);
                String editor = ServerMetaData.getElementContent(editorElement);
                if (editor == null) {
                    throw new DeploymentException("Contents of property-editor element is null.");
                }
                this.addPropertyEditor(type, editor);
            }
        }
    }
}

