/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.RecordSchema;

public class Record
implements Serializable,
Cloneable,
Map {
    private static final long serialVersionUID = -6640296864936227160L;
    protected String schema;
    protected transient RecordSchema recordSchema;
    protected Map values;

    public Record(String schema) throws PropertySchemaDefineException {
        this(schema, RecordSchema.getInstance(schema));
    }

    public Record(String schema, RecordSchema recordSchema) {
        this.schema = schema;
        this.recordSchema = recordSchema;
    }

    public String getSchema() {
        return this.schema;
    }

    public RecordSchema getRecordSchema() {
        return this.recordSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, Object val) throws PropertySetException {
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + name);
        }
        if (this.values == null) {
            Record record = this;
            synchronized (record) {
                if (this.values == null) {
                    this.values = Collections.synchronizedMap(new HashMap());
                }
            }
        }
        this.values.put(name, propertySchema.set(val));
    }

    public void setProperty(int index, Object val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, boolean val) throws PropertySetException {
        this.setProperty(name, (Object)(val ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setProperty(int index, boolean val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, byte val) throws PropertySetException {
        this.setProperty(name, (Object)new Byte(val));
    }

    public void setProperty(int index, byte val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, char val) throws PropertySetException {
        this.setProperty(name, (Object)new Character(val));
    }

    public void setProperty(int index, char val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, short val) throws PropertySetException {
        this.setProperty(name, (Object)new Short(val));
    }

    public void setProperty(int index, short val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, int val) throws PropertySetException {
        this.setProperty(name, (Object)new Integer(val));
    }

    public void setProperty(int index, int val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, long val) throws PropertySetException {
        this.setProperty(name, (Object)new Long(val));
    }

    public void setProperty(int index, long val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, float val) throws PropertySetException {
        this.setProperty(name, (Object)new Float(val));
    }

    public void setProperty(int index, float val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, double val) throws PropertySetException {
        this.setProperty(name, (Object)new Double(val));
    }

    public void setProperty(int index, double val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public Object getProperty(String name) throws PropertyGetException {
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertyGetException(null, "No such property : " + name);
        }
        return propertySchema.get(this.values == null ? null : this.values.get(name));
    }

    public Object getProperty(int index) throws PropertyGetException {
        return this.getProperty(this.recordSchema.getPropertyName(index));
    }

    public boolean getBooleanProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return false;
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        if (ret instanceof String) {
            try {
                return Integer.parseInt((String)ret) != 0;
            }
            catch (NumberFormatException e) {
                return Boolean.valueOf((String)ret);
            }
        }
        if (ret instanceof Number) {
            return ((Number)ret).intValue() != 0;
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public boolean getBooleanProperty(int index) throws PropertyGetException {
        return this.getBooleanProperty(this.recordSchema.getPropertyName(index));
    }

    public byte getByteProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).byteValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? (byte)1 : 0;
        }
        if (ret instanceof String) {
            try {
                return Byte.parseByte((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public byte getByteProperty(int index) throws PropertyGetException {
        return this.getByteProperty(this.recordSchema.getPropertyName(index));
    }

    public short getShortProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).shortValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? (short)1 : 0;
        }
        if (ret instanceof String) {
            try {
                return Short.parseShort((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public short getShortProperty(int index) throws PropertyGetException {
        return this.getShortProperty(this.recordSchema.getPropertyName(index));
    }

    public int getIntProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).intValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1 : 0;
        }
        if (ret instanceof String) {
            try {
                return Integer.parseInt((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public int getIntProperty(int index) throws PropertyGetException {
        return this.getIntProperty(this.recordSchema.getPropertyName(index));
    }

    public long getLongProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0L;
        }
        if (ret instanceof Number) {
            return ((Number)ret).longValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1L : 0L;
        }
        if (ret instanceof String) {
            try {
                return Long.parseLong((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public long getLongProperty(int index) throws PropertyGetException {
        return this.getLongProperty(this.recordSchema.getPropertyName(index));
    }

    public float getFloatProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0.0f;
        }
        if (ret instanceof Number) {
            return ((Number)ret).floatValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1.0f : 0.0f;
        }
        if (ret instanceof String) {
            try {
                return Float.parseFloat((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public float getFloatProperty(int index) throws PropertyGetException {
        return this.getFloatProperty(this.recordSchema.getPropertyName(index));
    }

    public double getDoubleProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0.0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).doubleValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1.0 : 0.0;
        }
        if (ret instanceof String) {
            try {
                return Double.parseDouble((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public double getDoubleProperty(int index) throws PropertyGetException {
        return this.getDoubleProperty(this.recordSchema.getPropertyName(index));
    }

    public String getStringProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return null;
        }
        if (ret instanceof String) {
            return (String)ret;
        }
        return ret.toString();
    }

    public String getStringProperty(int index) throws PropertyGetException {
        return this.getStringProperty(this.recordSchema.getPropertyName(index));
    }

    public Object getFormatProperty(String name) throws PropertyGetException {
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertyGetException(null, "No such property : " + name);
        }
        return propertySchema.format(this.getProperty(name));
    }

    public Object getFormatProperty(int index) throws PropertyGetException {
        return this.getFormatProperty(this.recordSchema.getPropertyName(index));
    }

    public void setParseProperty(String name, Object val) throws PropertySetException {
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + name);
        }
        this.setProperty(name, propertySchema.parse(val));
    }

    public void setParseProperty(int index, Object val) throws PropertySetException {
        this.setParseProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void clear() {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public Record cloneSchema() {
        return new Record(this.schema);
    }

    public Record cloneRecord() {
        Record record = this.cloneSchema();
        if (this.values != null) {
            record.values = Collections.synchronizedMap(new HashMap());
            record.values.putAll(this.values);
        }
        return record;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.cloneRecord();
    }

    public String toString() {
        return this.values == null ? "{}" : this.values.toString();
    }

    public int size() {
        return this.recordSchema.getPropertySize();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.recordSchema.getPropertySchema(key == null ? (String)key : key.toString()) != null;
    }

    public boolean containsValue(Object value) {
        return this.values == null ? value == null : this.values.containsValue(value);
    }

    public Object get(Object key) {
        return this.getProperty(key == null ? (String)key : key.toString());
    }

    public Object put(Object key, Object value) {
        Object old = this.get(key);
        this.setProperty(key == null ? (String)key : key.toString(), value);
        return old;
    }

    public Object remove(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        Object old = this.get(key);
        if (old != null) {
            this.setProperty(key == null ? (String)key : key.toString(), null);
        }
        if (this.values != null) {
            this.values.remove(key);
        }
        return old;
    }

    public void putAll(Map t) {
        if (t == null) {
            return;
        }
        Iterator entries = t.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set keySet() {
        return new KeySet();
    }

    public Collection values() {
        return new Values();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record record = (Record)o;
        if (this.recordSchema != record.recordSchema) {
            return false;
        }
        if (this.values == record.values) {
            return true;
        }
        if (this.values == null && record.values != null || this.values != null && record.values == null) {
            return false;
        }
        return ((Object)this.values).equals(record.values);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.recordSchema != null) {
            hashCode += this.recordSchema.hashCode();
        }
        if (this.values != null) {
            hashCode += ((Object)this.values).hashCode();
        }
        return hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.schema != null) {
            this.recordSchema = RecordSchema.getInstance(this.schema);
        }
    }

    protected class EntrySet
    implements Set,
    Serializable {
        protected List entries;

        public EntrySet() {
            PropertySchema[] schemata = Record.this.recordSchema.getPropertySchemata();
            this.entries = new ArrayList();
            for (int i = 0; i < schemata.length; ++i) {
                this.entries.add(new Entry(schemata[i].getName()));
            }
        }

        public int size() {
            return this.entries.size();
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public boolean contains(Object o) {
            return this.entries.contains(o);
        }

        public Iterator iterator() {
            return new EntrySetIterator();
        }

        public Object[] toArray() {
            return this.entries.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.entries.toArray(a);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return Record.this.remove(((Map.Entry)o).getKey()) != null;
        }

        public boolean containsAll(Collection c) {
            return this.entries.containsAll(c);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator itr = this.entries.iterator();
            while (itr.hasNext()) {
                Object key = ((Map.Entry)itr.next()).getKey();
                if (c.contains(key)) continue;
                result |= this.remove(key);
            }
            return result;
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator itr = this.entries.iterator();
            while (itr.hasNext()) {
                Object key = ((Map.Entry)itr.next()).getKey();
                if (!c.contains(key)) continue;
                result |= this.remove(key);
            }
            return result;
        }

        public void clear() {
            Record.this.clear();
        }

        public boolean equals(Object o) {
            return ((Object)this.entries).equals(o);
        }

        public int hashCode() {
            return ((Object)this.entries).hashCode();
        }

        protected class EntrySetIterator
        implements Iterator,
        Serializable {
            protected int index;

            protected EntrySetIterator() {
            }

            public boolean hasNext() {
                return EntrySet.this.entries.size() > this.index;
            }

            public Object next() {
                return this.hasNext() ? EntrySet.this.entries.get(this.index++) : null;
            }

            public void remove() {
                if (EntrySet.this.entries.size() > this.index) {
                    Record.this.remove(((Entry)EntrySet.this.entries.get(this.index)).getKey());
                }
            }
        }

        protected class Entry
        implements Map.Entry,
        Serializable {
            protected String key;

            public Entry(String key) {
                this.key = key;
            }

            public Object getKey() {
                return this.key;
            }

            public Object getValue() {
                return Record.this.getProperty(this.key);
            }

            public Object setValue(Object value) {
                return Record.this.put(this.key, value);
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
            }

            public int hashCode() {
                return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
            }
        }
    }

    protected class Values
    implements Collection,
    Serializable {
        protected List valueList;

        public Values() {
            PropertySchema[] schemata = Record.this.recordSchema.getPropertySchemata();
            this.valueList = new ArrayList();
            for (int i = 0; i < schemata.length; ++i) {
                this.valueList.add(Record.this.getProperty(schemata[i].getName()));
            }
        }

        public int size() {
            return this.valueList.size();
        }

        public boolean isEmpty() {
            return this.valueList.isEmpty();
        }

        public boolean contains(Object o) {
            return this.valueList.contains(o);
        }

        public Iterator iterator() {
            return new ValuesIterator();
        }

        public Object[] toArray() {
            return this.valueList.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.valueList.toArray(a);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            int index = this.valueList.indexOf(o);
            if (index == -1) {
                return false;
            }
            return Record.this.remove(Record.this.recordSchema.getPropertyName(index)) != null;
        }

        public boolean containsAll(Collection c) {
            return this.valueList.containsAll(c);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator itr = this.valueList.iterator();
            while (itr.hasNext()) {
                Object val = itr.next();
                if (c.contains(val)) continue;
                result |= this.remove(val);
            }
            return result;
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator itr = this.valueList.iterator();
            while (itr.hasNext()) {
                Object val = itr.next();
                if (!c.contains(val)) continue;
                result |= this.remove(val);
            }
            return result;
        }

        public void clear() {
            Record.this.clear();
        }

        public boolean equals(Object o) {
            return ((Object)this.valueList).equals(o);
        }

        public int hashCode() {
            return ((Object)this.valueList).hashCode();
        }

        protected class ValuesIterator
        implements Iterator,
        Serializable {
            protected int index;

            protected ValuesIterator() {
            }

            public boolean hasNext() {
                return Values.this.valueList.size() > this.index;
            }

            public Object next() {
                return this.hasNext() ? Values.this.valueList.get(this.index++) : null;
            }

            public void remove() {
                if (Values.this.valueList.size() > this.index) {
                    Values.this.remove(Values.this.valueList.get(this.index));
                }
            }
        }
    }

    protected class KeySet
    implements Set,
    Serializable {
        protected List keys;

        public KeySet() {
            PropertySchema[] schemata = Record.this.recordSchema.getPropertySchemata();
            this.keys = new ArrayList();
            for (int i = 0; i < schemata.length; ++i) {
                this.keys.add(schemata[i].getName());
            }
        }

        public int size() {
            return this.keys.size();
        }

        public boolean isEmpty() {
            return this.keys.isEmpty();
        }

        public boolean contains(Object o) {
            return this.keys.contains(o);
        }

        public Iterator iterator() {
            return new KeySetIterator();
        }

        public Object[] toArray() {
            return this.keys.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.keys.toArray(a);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            return Record.this.remove(o) != null;
        }

        public boolean containsAll(Collection c) {
            return this.keys.containsAll(c);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator itr = this.keys.iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                if (c.contains(key)) continue;
                result |= this.remove(key);
            }
            return result;
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator itr = this.keys.iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                if (!c.contains(key)) continue;
                result |= this.remove(key);
            }
            return result;
        }

        public void clear() {
            Record.this.clear();
        }

        public boolean equals(Object o) {
            return ((Object)this.keys).equals(o);
        }

        public int hashCode() {
            return ((Object)this.keys).hashCode();
        }

        protected class KeySetIterator
        implements Iterator,
        Serializable {
            protected int index;

            protected KeySetIterator() {
            }

            public boolean hasNext() {
                return KeySet.this.keys.size() > this.index;
            }

            public Object next() {
                return this.hasNext() ? KeySet.this.keys.get(this.index++) : null;
            }

            public void remove() {
                if (KeySet.this.keys.size() > this.index) {
                    Record.this.remove(KeySet.this.keys.get(this.index));
                }
            }
        }
    }
}

